/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.JupyterClientType;
import org.jetbrains.kotlinx.jupyter.util.JupyterClientDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00009\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ5\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u001e\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u0006\u0012\u0004\u0012\u00020\u00100\u000eH\u0002\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlinx/jupyter/util/JupyterClientDetector;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "detectors", "", "Lorg/jetbrains/kotlinx/jupyter/util/JupyterClientDetector$Detector;", "detect", "Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;", "detector", "org/jetbrains/kotlinx/jupyter/util/JupyterClientDetector$detector$1", "type", "predicate", "Lkotlin/Function2;", "", "", "(Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlinx/jupyter/util/JupyterClientDetector$detector$1;", "doDetect", "Detector", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nJupyterClientDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterClientDetector.kt\norg/jetbrains/kotlinx/jupyter/util/JupyterClientDetector\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logging.kt\norg/jetbrains/kotlinx/jupyter/config/LoggingKt\n*L\n1#1,63:1\n26#2:64\n288#3,2:65\n10#4:67\n*S KotlinDebug\n*F\n+ 1 JupyterClientDetector.kt\norg/jetbrains/kotlinx/jupyter/util/JupyterClientDetector\n*L\n24#1:64\n27#1:65,2\n61#1:67\n*E\n"})
public final class JupyterClientDetector {
    @NotNull
    public static final JupyterClientDetector INSTANCE = new JupyterClientDetector();
    @NotNull
    private static final List<Detector> detectors;
    @NotNull
    private static final Logger LOG;

    private JupyterClientDetector() {
    }

    @NotNull
    public final JupyterClientType detect() {
        JupyterClientType jupyterClientType2;
        try {
            jupyterClientType2 = this.doDetect();
        }
        catch (LinkageError e) {
            LOG.error("Unable to detect Jupyter client type because of incompatible JVM version", (Throwable)e);
            jupyterClientType2 = JupyterClientType.UNKNOWN;
        }
        return jupyterClientType2;
    }

    private final JupyterClientType doDetect() {
        LOG.info("Detecting Jupyter client type");
        ProcessHandle currentHandle = ProcessHandle.current();
        List ancestors2 = SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)currentHandle, (Function1)doDetect.ancestors.1.INSTANCE));
        for (ProcessHandle handle : ancestors2) {
            Object v1;
            block2: {
                ProcessHandle.Info info = handle.info();
                String command = info.command().orElse("");
                boolean $i$f$emptyArray = false;
                String[] stringArray = info.arguments().orElse(new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"orElse(...)");
                List arguments = ArraysKt.toList((Object[])stringArray);
                LOG.info("Inspecting process: " + command + ' ' + CollectionsKt.joinToString$default((Iterable)arguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                Iterable $this$firstOrNull$iv = detectors;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Detector it = (Detector)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)command);
                    if (!it.isThisClient(command, arguments)) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            Detector detector2 = v1;
            if (detector2 == null) continue;
            Detector correctDetector = detector2;
            LOG.info("Detected type is " + correctDetector.getType());
            return correctDetector.getType();
        }
        LOG.info("Client type has not been detected");
        return JupyterClientType.UNKNOWN;
    }

    private final detector.1 detector(JupyterClientType type, Function2<? super String, ? super List<String>, Boolean> predicate) {
        return new Detector(type, predicate){
            final /* synthetic */ JupyterClientType $type;
            final /* synthetic */ Function2<String, List<String>, Boolean> $predicate;
            {
                this.$type = $type;
                this.$predicate = $predicate;
            }

            @NotNull
            public JupyterClientType getType() {
                return this.$type;
            }

            public boolean isThisClient(@NotNull String command, @NotNull List<String> arguments) {
                Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
                return (Boolean)this.$predicate.invoke((Object)command, arguments);
            }
        };
    }

    static {
        Object[] objectArray = new Detector[]{INSTANCE.detector(JupyterClientType.JUPYTER_NOTEBOOK, (Function2<? super String, ? super List<String>, Boolean>)((Function2)detectors.1.INSTANCE)), INSTANCE.detector(JupyterClientType.JUPYTER_LAB, (Function2<? super String, ? super List<String>, Boolean>)((Function2)detectors.2.INSTANCE)), INSTANCE.detector(JupyterClientType.KERNEL_TESTS, (Function2<? super String, ? super List<String>, Boolean>)((Function2)detectors.3.INSTANCE))};
        detectors = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(JupyterClientDetector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\bb\u0018\u00002\u00020\u0001J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlinx/jupyter/util/JupyterClientDetector$Detector;", "", "type", "Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;", "getType", "()Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;", "isThisClient", "", "command", "", "arguments", "", "shared-compiler"})
    private static interface Detector {
        @NotNull
        public JupyterClientType getType();

        public boolean isThisClient(@NotNull String var1, @NotNull List<String> var2);
    }
}

