/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.protocol;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.messaging.InputReply;
import org.jetbrains.kotlinx.jupyter.messaging.InputRequest;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterConnectionInternalKt;
import org.jetbrains.kotlinx.jupyter.messaging.Message;
import org.jetbrains.kotlinx.jupyter.messaging.MessageContent;
import org.jetbrains.kotlinx.jupyter.messaging.MessageData;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactory;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactoryKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSocketBase;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSocketKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\nH\u0016J \u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlinx/jupyter/protocol/StdinInputStream;", "Ljava/io/InputStream;", "stdinSocket", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterSocketBase;", "messageFactory", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageFactory;", "(Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterSocketBase;Lorg/jetbrains/kotlinx/jupyter/messaging/MessageFactory;)V", "currentBuf", "", "currentBufPos", "", "getInput", "", "initializeCurrentBuf", "read", "b", "off", "len", "shared-compiler"})
public final class StdinInputStream
extends InputStream {
    @NotNull
    private final JupyterSocketBase stdinSocket;
    @NotNull
    private final MessageFactory messageFactory;
    @Nullable
    private byte[] currentBuf;
    private int currentBufPos;

    public StdinInputStream(@NotNull JupyterSocketBase stdinSocket, @NotNull MessageFactory messageFactory) {
        Intrinsics.checkNotNullParameter((Object)stdinSocket, (String)"stdinSocket");
        Intrinsics.checkNotNullParameter((Object)messageFactory, (String)"messageFactory");
        this.stdinSocket = stdinSocket;
        this.messageFactory = messageFactory;
    }

    private final String getInput() {
        MessageContent messageContent;
        JupyterConnectionInternalKt.sendMessage(this.stdinSocket, MessageFactoryKt.makeReplyMessage$default(this.messageFactory, MessageType.INPUT_REQUEST, null, null, null, null, new InputRequest("stdin:", false, 2, null), 30, null));
        Message msg = JupyterSocketKt.receiveMessage(this.stdinSocket);
        Object object = msg;
        MessageContent messageContent2 = messageContent = object != null && (object = ((Message)object).getData()) != null ? ((MessageData)object).getContent() : null;
        InputReply content = messageContent instanceof InputReply ? (InputReply)messageContent : null;
        Object object2 = content;
        if (object2 == null || (object2 = ((InputReply)object2).getValue()) == null) {
            throw new UnsupportedOperationException("Unexpected input message " + msg);
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] initializeCurrentBuf() {
        byte[] byArray;
        byte[] buf = this.currentBuf;
        if (buf != null) {
            byArray = buf;
        } else {
            void var2_3;
            String string = this.getInput();
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            byte[] newBuf = byArray2;
            this.currentBuf = newBuf;
            this.currentBufPos = 0;
            byArray = var2_3;
        }
        return byArray;
    }

    @Override
    public synchronized int read() {
        byte[] buf = this.initializeCurrentBuf();
        if (this.currentBufPos >= buf.length) {
            this.currentBuf = null;
            return -1;
        }
        int n = this.currentBufPos;
        this.currentBufPos = n + 1;
        return buf[n];
    }

    @Override
    public synchronized int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        byte[] buf = this.initializeCurrentBuf();
        int lenLeft = buf.length - this.currentBufPos;
        if (lenLeft <= 0) {
            this.currentBuf = null;
            return -1;
        }
        int lenToRead = Math.min(len, lenLeft);
        for (int i = 0; i < lenToRead; ++i) {
            b[off + i] = buf[this.currentBufPos + i];
        }
        this.currentBufPos += lenToRead;
        return lenToRead;
    }
}

