/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.DisplayResult;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplException;
import org.jetbrains.kotlinx.jupyter.messaging.ErrorJupyterResponse;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteAbortReply;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteErrorReply;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteReplyMetadata;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteSuccessReply;
import org.jetbrains.kotlinx.jupyter.messaging.ExecutionResultMessage;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacility;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacilityKt;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterConnectionInternalKt;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterOutType;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterResponse;
import org.jetbrains.kotlinx.jupyter.messaging.Message;
import org.jetbrains.kotlinx.jupyter.messaging.MessageContent;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactory;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactoryKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageReplyContent;
import org.jetbrains.kotlinx.jupyter.messaging.MessageStatus;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSocketBase;
import org.jetbrains.kotlinx.jupyter.protocol.RawMessageImplKt;
import org.jetbrains.kotlinx.jupyter.repl.EvaluatedSnippetMetadata;
import org.jetbrains.kotlinx.jupyter.util.SerializersKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u001a\u001c\u0010\u000e\u001a\u00020\u0003*\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\n\u001a\"\u0010\u0011\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u0016\u0010\u0014\u001a\u00020\u0013*\u00020\u00152\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\b2\u0006\u0010\t\u001a\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"EXECUTION_INTERRUPTED_MESSAGE", "", "sendExecuteReply", "", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;", "status", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageStatus;", "exception", "Lorg/jetbrains/kotlinx/jupyter/exceptions/ReplException;", "requestCount", "", "startedTime", "metadata", "Lorg/jetbrains/kotlinx/jupyter/repl/EvaluatedSnippetMetadata;", "sendExecuteResult", "result", "Lorg/jetbrains/kotlinx/jupyter/api/DisplayResult;", "sendResponse", "response", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterResponse;", "toErrorJupyterResponse", "", "toExecuteErrorReply", "Lorg/jetbrains/kotlinx/jupyter/messaging/ExecuteErrorReply;", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nJupyterResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterResponse.kt\norg/jetbrains/kotlinx/jupyter/messaging/JupyterResponseKt\n+ 2 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,145:1\n211#2:146\n11065#3:147\n11400#3,3:148\n*S KotlinDebug\n*F\n+ 1 JupyterResponse.kt\norg/jetbrains/kotlinx/jupyter/messaging/JupyterResponseKt\n*L\n118#1:146\n141#1:147\n141#1:148,3\n*E\n"})
public final class JupyterResponseKt {
    @NotNull
    public static final String EXECUTION_INTERRUPTED_MESSAGE = "The execution was interrupted";

    public static final void sendResponse(@NotNull JupyterCommunicationFacility $this$sendResponse, @NotNull JupyterResponse response2, long requestCount, @NotNull String startedTime) {
        Intrinsics.checkNotNullParameter((Object)$this$sendResponse, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)startedTime, (String)"startedTime");
        String stdErr = response2.getStdErr();
        CharSequence charSequence = stdErr;
        if (!(charSequence == null || charSequence.length() == 0)) {
            JupyterCommunicationFacilityKt.sendOut($this$sendResponse, JupyterOutType.STDERR, stdErr);
        }
        JupyterResponseKt.sendExecuteResult($this$sendResponse, response2.getDisplayResult(), requestCount);
        JupyterResponseKt.sendExecuteReply($this$sendResponse, response2.getStatus(), response2.getException(), requestCount, startedTime, response2.getMetadata());
    }

    public static final void sendExecuteResult(@NotNull JupyterCommunicationFacility $this$sendExecuteResult, @Nullable DisplayResult result2, long requestCount) {
        Intrinsics.checkNotNullParameter((Object)$this$sendExecuteResult, (String)"<this>");
        if (result2 == null) {
            return;
        }
        JsonObject resultJson = result2.toJson(SerializersKt.getEMPTY((Json)((Json)Json.Default)), null);
        JupyterSocketBase jupyterSocketBase = $this$sendExecuteResult.getSocketManager().getIopub();
        MessageFactory messageFactory = $this$sendExecuteResult.getMessageFactory();
        Object object = resultJson.get((Object)"data");
        Intrinsics.checkNotNull((Object)object);
        JsonElement jsonElement = (JsonElement)object;
        Object object2 = resultJson.get((Object)"metadata");
        Intrinsics.checkNotNull((Object)object2);
        JsonElement jsonElement2 = (JsonElement)object2;
        JupyterConnectionInternalKt.sendMessage(jupyterSocketBase, MessageFactoryKt.makeReplyMessage$default(messageFactory, MessageType.EXECUTE_RESULT, null, null, null, null, new ExecutionResultMessage(jsonElement, jsonElement2, requestCount), 30, null));
    }

    public static final void sendExecuteReply(@NotNull JupyterCommunicationFacility $this$sendExecuteReply, @NotNull MessageStatus status, @Nullable ReplException exception, long requestCount, @NotNull String startedTime, @Nullable EvaluatedSnippetMetadata metadata) {
        MessageContent messageContent;
        Intrinsics.checkNotNullParameter((Object)$this$sendExecuteReply, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter((Object)startedTime, (String)"startedTime");
        ExecuteReplyMetadata replyMetadata = new ExecuteReplyMetadata(true, $this$sendExecuteReply.getMessageFactory().getSessionId(), status, startedTime, metadata);
        Object object = exception;
        if (object != null && (object = JupyterResponseKt.toExecuteErrorReply((ReplException)object, requestCount)) != null) {
            messageContent = (MessageContent)object;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1: 
                case 2: {
                    messageContent = new ExecuteAbortReply();
                    break;
                }
                case 3: {
                    messageContent = new ExecuteSuccessReply(requestCount, null, null, null, 14, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        MessageContent replyContent = messageContent;
        MessageFactory messageFactory = $this$sendExecuteReply.getMessageFactory();
        MessageType messageType = MessageType.EXECUTE_REPLY;
        MessageReplyContent messageReplyContent = (MessageReplyContent)replyContent;
        Json $this$encodeToJsonElement$iv = RawMessageImplKt.getMessageFormat();
        boolean $i$f$encodeToJsonElement = false;
        $this$encodeToJsonElement$iv.getSerializersModule();
        JsonElement jsonElement = $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)ExecuteReplyMetadata.Companion.serializer(), (Object)replyMetadata);
        Message reply = MessageFactoryKt.makeReplyMessage$default(messageFactory, messageType, null, null, null, jsonElement, messageReplyContent, 14, null);
        switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                System.err.println("Sending error: " + reply);
                break;
            }
            case 2: {
                System.err.println("Sending abort: " + reply);
            }
        }
        JupyterConnectionInternalKt.sendMessage($this$sendExecuteReply.getSocketManager().getShell(), reply);
    }

    public static /* synthetic */ void sendExecuteReply$default(JupyterCommunicationFacility jupyterCommunicationFacility, MessageStatus messageStatus, ReplException replException, long l, String string, EvaluatedSnippetMetadata evaluatedSnippetMetadata, int n, Object object) {
        if ((n & 0x10) != 0) {
            evaluatedSnippetMetadata = null;
        }
        JupyterResponseKt.sendExecuteReply(jupyterCommunicationFacility, messageStatus, replException, l, string, evaluatedSnippetMetadata);
    }

    @NotNull
    public static final JupyterResponse toErrorJupyterResponse(@NotNull Throwable $this$toErrorJupyterResponse, @Nullable EvaluatedSnippetMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$toErrorJupyterResponse, (String)"<this>");
        Throwable exception = $this$toErrorJupyterResponse;
        if (!(exception instanceof ReplException)) {
            throw exception;
        }
        return new ErrorJupyterResponse(((ReplException)exception).render(), (ReplException)exception, metadata);
    }

    public static /* synthetic */ JupyterResponse toErrorJupyterResponse$default(Throwable throwable, EvaluatedSnippetMetadata evaluatedSnippetMetadata, int n, Object object) {
        if ((n & 1) != 0) {
            evaluatedSnippetMetadata = null;
        }
        return JupyterResponseKt.toErrorJupyterResponse(throwable, evaluatedSnippetMetadata);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ExecuteErrorReply toExecuteErrorReply(@NotNull ReplException $this$toExecuteErrorReply, long requestCount) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toExecuteErrorReply, (String)"<this>");
        String string = $this$toExecuteErrorReply.getClass().getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
        String string2 = $this$toExecuteErrorReply.getMessage();
        if (string2 == null) {
            string2 = "";
        }
        StackTraceElement[] stackTraceElementArray = $this$toExecuteErrorReply.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
        Object[] objectArray = stackTraceElementArray;
        String string3 = string2;
        String string4 = string;
        long l = requestCount;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string5 = it.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
            collection.add(string5);
        }
        collection = (List)destination$iv$iv;
        JsonObject jsonObject = $this$toExecuteErrorReply.getAdditionalInfoJson();
        if (jsonObject == null) {
            jsonObject = SerializersKt.getEMPTY((Json)((Json)Json.Default));
        }
        JsonObject jsonObject2 = jsonObject;
        List list = collection;
        String string6 = string3;
        String string7 = string4;
        long l2 = l;
        return new ExecuteErrorReply(l2, string7, string6, list, jsonObject2);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageStatus.values().length];
            try {
                nArray[MessageStatus.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageStatus.ABORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageStatus.OK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

