/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.io.File;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.common.HttpClient;
import org.jetbrains.kotlinx.jupyter.common.HttpUtilKt;
import org.jetbrains.kotlinx.jupyter.common.ResponseKt;
import org.jetbrains.kotlinx.jupyter.common.ResponseWrapper;
import org.jetbrains.kotlinx.jupyter.common.Status;
import org.jetbrains.kotlinx.jupyter.libraries.AbstractLibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryHttpUtil;
import org.jetbrains.kotlinx.jupyter.libraries.ResolutionInfoProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\rH\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/StandardResolutionInfoProvider;", "Lorg/jetbrains/kotlinx/jupyter/libraries/ResolutionInfoProvider;", "fallback", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;", "httpUtil", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryHttpUtil;", "(Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryHttpUtil;)V", "getFallback", "()Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;", "setFallback", "(Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;)V", "get", "string", "", "tryGetAsDir", "dirName", "tryGetAsFile", "fileName", "tryGetAsRef", "ref", "tryGetAsURL", "url", "Companion", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nStandardResolutionInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardResolutionInfoProvider.kt\norg/jetbrains/kotlinx/jupyter/libraries/StandardResolutionInfoProvider\n+ 2 logging.kt\norg/jetbrains/kotlinx/jupyter/config/LoggingKt\n*L\n1#1,47:1\n10#2:48\n*S KotlinDebug\n*F\n+ 1 StandardResolutionInfoProvider.kt\norg/jetbrains/kotlinx/jupyter/libraries/StandardResolutionInfoProvider\n*L\n44#1:48\n*E\n"})
public final class StandardResolutionInfoProvider
implements ResolutionInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LibraryResolutionInfo fallback;
    @NotNull
    private final LibraryHttpUtil httpUtil;
    @NotNull
    private static final Logger LOG;

    public StandardResolutionInfoProvider(@NotNull LibraryResolutionInfo fallback, @NotNull LibraryHttpUtil httpUtil) {
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        Intrinsics.checkNotNullParameter((Object)httpUtil, (String)"httpUtil");
        this.fallback = fallback;
        this.httpUtil = httpUtil;
    }

    @Override
    @NotNull
    public LibraryResolutionInfo getFallback() {
        return this.fallback;
    }

    @Override
    public void setFallback(@NotNull LibraryResolutionInfo libraryResolutionInfo) {
        Intrinsics.checkNotNullParameter((Object)libraryResolutionInfo, (String)"<set-?>");
        this.fallback = libraryResolutionInfo;
    }

    @Override
    @NotNull
    public LibraryResolutionInfo get(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (((CharSequence)string).length() == 0) {
            return this.getFallback();
        }
        LibraryResolutionInfo libraryResolutionInfo = this.tryGetAsRef(string);
        if (libraryResolutionInfo == null && (libraryResolutionInfo = this.tryGetAsDir(string)) == null && (libraryResolutionInfo = this.tryGetAsFile(string)) == null && (libraryResolutionInfo = this.tryGetAsURL(string)) == null) {
            libraryResolutionInfo = this.getFallback();
        }
        return libraryResolutionInfo;
    }

    private final LibraryResolutionInfo tryGetAsRef(String ref) {
        return this.httpUtil.getLibraryDescriptorsManager().checkRefExistence(ref) ? (LibraryResolutionInfo)this.httpUtil.getLibraryInfoCache().getLibraryInfoByRef(ref) : null;
    }

    private final LibraryResolutionInfo tryGetAsDir(String dirName) {
        File file = new File(dirName);
        return file.isDirectory() ? (LibraryResolutionInfo)new AbstractLibraryResolutionInfo.ByDir(file) : null;
    }

    private final LibraryResolutionInfo tryGetAsFile(String fileName) {
        File file = new File(fileName);
        return file.isFile() ? (LibraryResolutionInfo)new AbstractLibraryResolutionInfo.ByFile(file) : null;
    }

    private final LibraryResolutionInfo tryGetAsURL(String url) {
        ResponseWrapper responseWrapper;
        try {
            responseWrapper = HttpUtilKt.getHttp((HttpClient)this.httpUtil.getHttpClient(), (String)url);
        }
        catch (Throwable e) {
            LOG.warn("Unable to load library by URL " + url, e);
            return null;
        }
        ResponseWrapper response2 = responseWrapper;
        return ResponseKt.getSuccessful((Status)response2.getStatus()) ? (LibraryResolutionInfo)new AbstractLibraryResolutionInfo.ByURL(new URL(url)) : null;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(StandardResolutionInfoProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/StandardResolutionInfoProvider$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "getLOG", "()Lorg/slf4j/Logger;", "shared-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

