/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinition;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryReference;
import org.jetbrains.kotlinx.jupyter.api.libraries.Variable;
import org.jetbrains.kotlinx.jupyter.common.LibraryDescriptorsManager;
import org.jetbrains.kotlinx.jupyter.config.LoggingKt;
import org.jetbrains.kotlinx.jupyter.libraries.ChainedLibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptor;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.ParsingKt;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J \u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\fH\u0014J\u0014\u0010\u0018\u001a\u00020\u0007*\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/LocalLibraryResolver;", "Lorg/jetbrains/kotlinx/jupyter/libraries/ChainedLibraryResolver;", "parent", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolver;", "libraryDescriptorsManager", "Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager;", "mainLibrariesDir", "Ljava/io/File;", "(Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolver;Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager;Ljava/io/File;)V", "logger", "Lorg/slf4j/Logger;", "pathsToCheck", "", "save", "", "reference", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryReference;", "definition", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryDefinition;", "shouldResolve", "", "tryResolve", "arguments", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/Variable;", "getFile", "dir", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nlibraryResolvers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 libraryResolvers.kt\norg/jetbrains/kotlinx/jupyter/libraries/LocalLibraryResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n1#2:225\n1#2:236\n1603#3,9:226\n1855#3:235\n1856#3:237\n1612#3:238\n*S KotlinDebug\n*F\n+ 1 libraryResolvers.kt\norg/jetbrains/kotlinx/jupyter/libraries/LocalLibraryResolver\n*L\n70#1:236\n70#1:226,9\n70#1:235\n70#1:237\n70#1:238\n*E\n"})
public final class LocalLibraryResolver
extends ChainedLibraryResolver {
    @NotNull
    private final LibraryDescriptorsManager libraryDescriptorsManager;
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<File> pathsToCheck;

    public LocalLibraryResolver(@Nullable LibraryResolver parent, @NotNull LibraryDescriptorsManager libraryDescriptorsManager2, @Nullable File mainLibrariesDir) {
        Intrinsics.checkNotNullParameter((Object)libraryDescriptorsManager2, (String)"libraryDescriptorsManager");
        super(parent);
        this.libraryDescriptorsManager = libraryDescriptorsManager2;
        this.logger = LoggingKt.getLogger$default(null, 1, null);
        Object[] objectArray = new File[]{this.libraryDescriptorsManager.getUserCacheDir(), this.libraryDescriptorsManager.getUserLibrariesDir()};
        List paths = CollectionsKt.mutableListOf((Object[])objectArray);
        File file = mainLibrariesDir;
        if (file != null) {
            File it = file;
            boolean bl = false;
            paths.add(it);
        }
        this.pathsToCheck = paths;
    }

    @Override
    protected boolean shouldResolve(@NotNull LibraryReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        return reference.getShouldBeCachedLocally();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected LibraryDefinition tryResolve(@NotNull LibraryReference reference, @NotNull List<Variable> arguments) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Iterable $this$mapNotNull$iv = this.pathsToCheck;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            File it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File dir = (File)element$iv$iv;
            boolean bl2 = false;
            File file = this.getFile(reference, dir);
            if ((file.exists() ? file : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List files = (List)destination$iv$iv;
        if (files.size() > 1) {
            this.logger.warn("More than one file for library " + reference + " found in local cache directories");
        }
        File file = (File)CollectionsKt.firstOrNull((List)files);
        if (file == null) {
            return null;
        }
        File jsonFile = file;
        return LibraryDescriptor.convertToDefinition$default(ParsingKt.parseLibraryDescriptor(FilesKt.readText$default((File)jsonFile, null, (int)1, null)), arguments, null, 2, null);
    }

    @Override
    protected void save(@NotNull LibraryReference reference, @NotNull LibraryDefinition definition) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        String string = definition.getOriginalDescriptorText();
        if (string == null) {
            return;
        }
        String text = string;
        File dir = (File)CollectionsKt.first(this.pathsToCheck);
        File file = this.getFile(reference, dir);
        file.getParentFile().mkdirs();
        FilesKt.writeText$default((File)file, (String)text, null, (int)2, null);
    }

    private final File getFile(LibraryReference $this$getFile, File dir) {
        return FilesKt.resolve((File)dir, (String)this.libraryDescriptorsManager.descriptorFileName($this$getFile.getKey()));
    }
}

