/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.execution;

import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.exceptions.UtilKt;
import org.jetbrains.kotlinx.jupyter.execution.ExecutionResult;
import org.jetbrains.kotlinx.jupyter.execution.JupyterExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J9\u0010\f\u001a\u00020\n2'\u0010\r\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e\u00a2\u0006\u0002\b\u0011H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J8\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\b\b\u0000\u0010\u0015*\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutorImpl;", "Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutor;", "Ljava/io/Closeable;", "()V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "currentExecutions", "", "Ljava/lang/Thread;", "close", "", "interruptExecutions", "launchJob", "runnable", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;)V", "runExecution", "Lorg/jetbrains/kotlinx/jupyter/execution/ExecutionResult;", "T", "name", "", "classLoader", "Ljava/lang/ClassLoader;", "body", "Lkotlin/Function0;", "Companion", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nJupyterExecutorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterExecutorImpl.kt\norg/jetbrains/kotlinx/jupyter/execution/JupyterExecutorImpl\n+ 2 logging.kt\norg/jetbrains/kotlinx/jupyter/config/LoggingKt\n*L\n1#1,87:1\n10#2:88\n*S KotlinDebug\n*F\n+ 1 JupyterExecutorImpl.kt\norg/jetbrains/kotlinx/jupyter/execution/JupyterExecutorImpl\n*L\n84#1:88\n*E\n"})
public final class JupyterExecutorImpl
implements JupyterExecutor,
Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Thread> currentExecutions;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private static final Logger LOG;

    public JupyterExecutorImpl() {
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
        this.currentExecutions = set;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()));
    }

    @Override
    @NotNull
    public <T> ExecutionResult<T> runExecution(@NotNull String name, @Nullable ClassLoader classLoader, @NotNull Function0<? extends T> body) {
        ExecutionResult executionResult;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Ref.ObjectRef execRes = new Ref.ObjectRef();
        Ref.ObjectRef execException = new Ref.ObjectRef();
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = Thread.currentThread().getContextClassLoader();
        }
        ClassLoader classLoader3 = classLoader2;
        Thread execThread2 = ThreadsKt.thread$default((boolean)false, (boolean)false, (ClassLoader)classLoader3, (String)name, (int)0, (Function0)((Function0)new Function0<Unit>(execRes, body, (Ref.ObjectRef<Throwable>)execException){
            final /* synthetic */ Ref.ObjectRef<T> $execRes;
            final /* synthetic */ Function0<T> $body;
            final /* synthetic */ Ref.ObjectRef<Throwable> $execException;
            {
                this.$execRes = $execRes;
                this.$body = $body;
                this.$execException = $execException;
                super(0);
            }

            public final void invoke() {
                try {
                    this.$execRes.element = this.$body.invoke();
                }
                catch (Throwable e) {
                    this.$execException.element = e;
                }
            }
        }), (int)19, null);
        this.currentExecutions.add(execThread2);
        execThread2.join();
        this.currentExecutions.remove(execThread2);
        Throwable exception = (Throwable)execException.element;
        if (exception == null) {
            Object object = execRes.element;
            Intrinsics.checkNotNull((Object)object);
            executionResult = new ExecutionResult.Success<Object>(object);
        } else {
            executionResult = UtilKt.isInterruptedException(exception) ? (ExecutionResult)ExecutionResult.Interrupted.INSTANCE : (ExecutionResult)new ExecutionResult.Failure(exception);
        }
        return executionResult;
    }

    @Override
    public void interruptExecutions() {
        LOG.info("Stopping " + this.currentExecutions.size() + " executions...");
        while (!((Collection)this.currentExecutions).isEmpty() && (Thread)CollectionsKt.firstOrNull((Iterable)this.currentExecutions) != null) {
            Thread execution;
            String executionName = execution.getName();
            LOG.info("Stopping " + executionName + "...");
            execution.interrupt();
            LOG.info(executionName + " interrupted");
            try {
                execution.stop();
                LOG.info(executionName + " stopped");
            }
            catch (UnsupportedOperationException e) {
                LOG.warn("We tried to stop " + executionName + " thread, but it's not supported in the current version of JRE", (Throwable)e);
            }
            this.currentExecutions.remove(execution);
        }
    }

    @Override
    public void launchJob(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, runnable, (int)3, null);
    }

    @Override
    public void close() {
        this.interruptExecutions();
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, (String)"Jupyter executor was shut down", null, (int)2, null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(JupyterExecutorImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlinx/jupyter/execution/JupyterExecutorImpl$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "getLOG", "()Lorg/slf4j/Logger;", "shared-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

