/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.magics;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.CodePreprocessor;
import org.jetbrains.kotlinx.jupyter.api.ExtensionsProcessor;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelHost;
import org.jetbrains.kotlinx.jupyter.exceptions.KernelInternalObject;
import org.jetbrains.kotlinx.jupyter.exceptions.LibraryProblemPart;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplLibraryExceptionKt;
import org.jetbrains.kotlinx.jupyter.util.PriorityList;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0004\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013H\u0016J\u001a\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00110\u00160\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001H\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlinx/jupyter/magics/CompoundCodePreprocessor;", "Lorg/jetbrains/kotlinx/jupyter/api/CodePreprocessor;", "Lorg/jetbrains/kotlinx/jupyter/api/ExtensionsProcessor;", "preprocessors", "", "([Lorg/jetbrains/kotlinx/jupyter/api/CodePreprocessor;)V", "Lorg/jetbrains/kotlinx/jupyter/util/PriorityList;", "process", "Lorg/jetbrains/kotlinx/jupyter/api/CodePreprocessor$Result;", "code", "", "host", "Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelHost;", "register", "", "extension", "priority", "", "registeredExtensions", "", "registeredExtensionsWithPriority", "", "Lkotlin/Pair;", "unregister", "unregisterAll", "shared-compiler"})
public final class CompoundCodePreprocessor
implements CodePreprocessor,
ExtensionsProcessor<CodePreprocessor> {
    @NotNull
    private final PriorityList<CodePreprocessor> preprocessors;

    public CompoundCodePreprocessor(CodePreprocessor ... preprocessors) {
        Intrinsics.checkNotNullParameter((Object)preprocessors, (String)"preprocessors");
        this.preprocessors = new PriorityList(false, 1, null);
        for (CodePreprocessor preprocessor : preprocessors) {
            this.register((Object)preprocessor);
        }
    }

    @NotNull
    public CodePreprocessor.Result process(@NotNull String code, @NotNull KotlinKernelHost host) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Ref.ObjectRef result = new Ref.ObjectRef();
        result.element = new CodePreprocessor.Result(code, CollectionsKt.emptyList());
        for (CodePreprocessor preprocessor : this.preprocessors) {
            if (preprocessor instanceof KernelInternalObject) {
                CompoundCodePreprocessor.process$iteration((Ref.ObjectRef<CodePreprocessor.Result>)result, host, preprocessor);
                continue;
            }
            ReplLibraryExceptionKt.rethrowAsLibraryException(LibraryProblemPart.CODE_PREPROCESSORS, (Function0)new Function0<Unit>(preprocessor, (Ref.ObjectRef<CodePreprocessor.Result>)result, host){
                final /* synthetic */ CodePreprocessor $preprocessor;
                final /* synthetic */ Ref.ObjectRef<CodePreprocessor.Result> $result;
                final /* synthetic */ KotlinKernelHost $host;
                {
                    this.$preprocessor = $preprocessor;
                    this.$result = $result;
                    this.$host = $host;
                    super(0);
                }

                public final void invoke() {
                    CompoundCodePreprocessor.access$process$iteration(this.$result, this.$host, this.$preprocessor);
                }
            });
        }
        return (CodePreprocessor.Result)result.element;
    }

    public void register(@NotNull CodePreprocessor extension, int priority) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.preprocessors.add(extension, priority);
    }

    public void unregister(@NotNull CodePreprocessor extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.preprocessors.remove(extension);
    }

    public void unregisterAll() {
        this.preprocessors.clear();
    }

    @NotNull
    public Collection<CodePreprocessor> registeredExtensions() {
        return this.preprocessors.elements();
    }

    @NotNull
    public List<Pair<CodePreprocessor, Integer>> registeredExtensionsWithPriority() {
        return this.preprocessors.elementsWithPriority();
    }

    public void register(@NotNull CodePreprocessor extension) {
        ExtensionsProcessor.DefaultImpls.register((ExtensionsProcessor)this, (Object)extension);
    }

    public boolean accepts(@NotNull String code) {
        return CodePreprocessor.DefaultImpls.accepts((CodePreprocessor)this, (String)code);
    }

    public void registerAll(@NotNull Iterable<? extends CodePreprocessor> extensions) {
        ExtensionsProcessor.DefaultImpls.registerAll((ExtensionsProcessor)this, extensions);
    }

    private static final void process$iteration(Ref.ObjectRef<CodePreprocessor.Result> result, KotlinKernelHost $host, CodePreprocessor preprocessor) {
        if (preprocessor.accepts(((CodePreprocessor.Result)result.element).getCode())) {
            CodePreprocessor.Result newResult = preprocessor.process(((CodePreprocessor.Result)result.element).getCode(), $host);
            result.element = new CodePreprocessor.Result(newResult.getCode(), CollectionsKt.plus((Collection)((CodePreprocessor.Result)result.element).getLibraries(), (Iterable)newResult.getLibraries()));
        }
    }

    public static final /* synthetic */ void access$process$iteration(Ref.ObjectRef result, KotlinKernelHost $host, CodePreprocessor preprocessor) {
        CompoundCodePreprocessor.process$iteration((Ref.ObjectRef<CodePreprocessor.Result>)result, $host, preprocessor);
    }
}

