/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.protocol;

import java.security.SignatureException;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.libraries.RawMessage;
import org.jetbrains.kotlinx.jupyter.config.LoggingKt;
import org.jetbrains.kotlinx.jupyter.protocol.ConnectionKt;
import org.jetbrains.kotlinx.jupyter.protocol.HMAC;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSocket;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSocketInfo;
import org.jetbrains.kotlinx.jupyter.startup.KernelConfig;
import org.slf4j.Logger;
import org.zeromq.SocketType;
import org.zeromq.ZMQ;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u000b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0016J\b\u0010\u001f\u001a\u00020\u001dH\u0016J.\u0010 \u001a\u0004\u0018\u00010\u00132\u001d\u0010!\u001a\u0019\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\b\u0015H\u0016\u00a2\u0006\u0002\u0010#JF\u0010$\u001a\u001d\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011j\u0002`\u0014\u00a2\u0006\u0002\b\u00152!\u0010%\u001a\u001d\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011j\u0002`\u0014\u00a2\u0006\u0002\b\u0015H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010\u00122\u0006\u0010'\u001a\u00020\"H\u0016J+\u0010(\u001a\u00020\u00132!\u0010%\u001a\u001d\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011j\u0002`\u0014\u00a2\u0006\u0002\b\u0015H\u0016J\u000f\u0010)\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0012H\u0016R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR/\u0010\u000f\u001a#\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011j\u0002`\u0014\u00a2\u0006\u0002\b\u00150\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlinx/jupyter/protocol/SocketWrapper;", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterSocket;", "socketInfo", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterSocketInfo;", "socket", "Lorg/zeromq/ZMQ$Socket;", "hmac", "Lorg/jetbrains/kotlinx/jupyter/protocol/HMAC;", "kernelConfig", "Lorg/jetbrains/kotlinx/jupyter/startup/KernelConfig;", "(Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterSocketInfo;Lorg/zeromq/ZMQ$Socket;Lorg/jetbrains/kotlinx/jupyter/protocol/HMAC;Lorg/jetbrains/kotlinx/jupyter/startup/KernelConfig;)V", "address", "", "getAddress", "()Ljava/lang/String;", "callbacks", "", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/RawMessage;", "", "Lorg/jetbrains/kotlinx/jupyter/protocol/SocketRawMessageCallback;", "Lkotlin/ExtensionFunctionType;", "logger", "Lorg/slf4j/Logger;", "name", "getName", "getSocket", "()Lorg/zeromq/ZMQ$Socket;", "bind", "", "close", "connect", "onData", "body", "", "(Lkotlin/jvm/functions/Function2;)Lkotlin/Unit;", "onRawMessage", "callback", "receiveRawMessage", "start", "removeCallback", "runCallbacksOnMessage", "()Lkotlin/Unit;", "sendRawMessage", "msg", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nSocketWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketWrapper.kt\norg/jetbrains/kotlinx/jupyter/protocol/SocketWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1#2:118\n1855#3,2:119\n*S KotlinDebug\n*F\n+ 1 SocketWrapper.kt\norg/jetbrains/kotlinx/jupyter/protocol/SocketWrapper\n*L\n60#1:119,2\n*E\n"})
public final class SocketWrapper
implements JupyterSocket {
    @NotNull
    private final JupyterSocketInfo socketInfo;
    @NotNull
    private final ZMQ.Socket socket;
    @NotNull
    private final HMAC hmac;
    @NotNull
    private final KernelConfig kernelConfig;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Set<Function2<JupyterSocket, RawMessage, Unit>> callbacks;

    public SocketWrapper(@NotNull JupyterSocketInfo socketInfo, @NotNull ZMQ.Socket socket, @NotNull HMAC hmac, @NotNull KernelConfig kernelConfig) {
        Intrinsics.checkNotNullParameter((Object)((Object)socketInfo), (String)"socketInfo");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)hmac, (String)"hmac");
        Intrinsics.checkNotNullParameter((Object)kernelConfig, (String)"kernelConfig");
        this.socketInfo = socketInfo;
        this.socket = socket;
        this.hmac = hmac;
        this.kernelConfig = kernelConfig;
        String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        this.logger = LoggingKt.getLogger(string);
        this.callbacks = new LinkedHashSet();
    }

    @Override
    @NotNull
    public ZMQ.Socket getSocket() {
        return this.socket;
    }

    @NotNull
    public final String getName() {
        return this.socketInfo.name();
    }

    private final String getAddress() {
        Integer port = this.kernelConfig.getPorts().get(this.socketInfo.getType());
        return this.kernelConfig.getTransport() + "://*:" + port;
    }

    @Override
    public boolean bind() {
        boolean res = this.getSocket().bind(this.getAddress());
        if (this.getSocket().getSocketType() == SocketType.PUB) {
            Thread.sleep(500L);
        }
        this.logger.debug('[' + this.getName() + "] listen: " + this.getAddress());
        return res;
    }

    @Override
    public boolean connect() {
        return this.getSocket().connect(this.getAddress());
    }

    @Override
    @NotNull
    public Function2<JupyterSocket, RawMessage, Unit> onRawMessage(@NotNull Function2<? super JupyterSocket, ? super RawMessage, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callbacks.add(callback);
        return callback;
    }

    @Override
    public void removeCallback(@NotNull Function2<? super JupyterSocket, ? super RawMessage, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callbacks.remove(callback);
    }

    @Override
    @Nullable
    public Unit onData(@NotNull Function2<? super JupyterSocket, ? super byte[], Unit> body) {
        Unit unit;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        byte[] byArray = this.getSocket().recv();
        if (byArray != null) {
            byte[] it = byArray;
            boolean bl = false;
            body.invoke((Object)this, (Object)it);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Override
    @Nullable
    public Unit runCallbacksOnMessage() {
        Unit unit;
        byte[] byArray = this.getSocket().recv();
        if (byArray != null) {
            byte[] bytes = byArray;
            boolean bl = false;
            RawMessage rawMessage = this.receiveRawMessage(bytes);
            if (rawMessage != null) {
                RawMessage message = rawMessage;
                boolean bl2 = false;
                Iterable $this$forEach$iv = this.callbacks;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function2 callback = (Function2)element$iv;
                    boolean bl3 = false;
                    try {
                        callback.invoke((Object)this, (Object)message);
                    }
                    catch (Throwable e) {
                        this.logger.error("Exception thrown while processing a message", e);
                    }
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else {
            unit = null;
        }
        return unit;
    }

    @Override
    public void sendRawMessage(@NotNull RawMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.logger.debug('[' + this.getName() + "] snd>: " + msg);
        ConnectionKt.sendRawMessage(this.getSocket(), msg, this.hmac);
    }

    @Override
    @Nullable
    public RawMessage receiveRawMessage(@NotNull byte[] start) {
        RawMessage rawMessage;
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        try {
            RawMessage msg = ConnectionKt.receiveRawMessage(this.getSocket(), start, this.hmac);
            this.logger.debug('[' + this.getName() + "] >rcv: " + msg);
        }
        catch (SignatureException e) {
            this.logger.error('[' + this.getName() + "] " + e.getMessage());
            rawMessage = null;
        }
        return rawMessage;
    }

    @Override
    public void close() {
        this.callbacks.clear();
        this.getSocket().close();
    }
}

