/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.common;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.common.ExceptionsHandler;
import org.jetbrains.kotlinx.jupyter.common.HttpUtilKt;
import org.jetbrains.kotlinx.jupyter.common.ResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 H2\u00020\u0001:\u0002GHBW\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J-\u0010&\u001a\u0004\u0018\u0001H'\"\u0004\b\u0000\u0010'2\b\b\u0002\u0010(\u001a\u00020\u00032\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H'0*H\u0002\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0003J\u000e\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020\u0003J\u000e\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003J\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u0002042\u0006\u00100\u001a\u00020\u0003J\u0016\u00106\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003J\u0010\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0003H\u0002J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0003H\u0002J\u001c\u0010<\u001a\u0004\u0018\u00010=2\u0006\u00100\u001a\u00020\u00032\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\u0003J\u0012\u0010?\u001a\u00020\r2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010\rJ\u000e\u0010A\u001a\u00020-2\u0006\u0010B\u001a\u00020\rJ\u000e\u0010C\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003J\u0010\u0010D\u001a\u0002042\u0006\u00100\u001a\u00020\u0003H\u0002J\u0016\u0010E\u001a\u000204*\u00020\r2\b\b\u0002\u0010F\u001a\u00020\u0003H\u0002R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0011\u0010 \u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0016R\u0011\u0010$\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0016\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager;", "", "user", "", "repo", "remotePath", "localPath", "homePath", "userPath", "resourcesPath", "exceptionsHandler", "Lorg/jetbrains/kotlinx/jupyter/common/ExceptionsHandler;", "userSettingsDir", "Ljava/io/File;", "logger", "Lorg/slf4j/Logger;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlinx/jupyter/common/ExceptionsHandler;Ljava/io/File;Lorg/slf4j/Logger;)V", "apiPrefix", "authToken", "authUser", "commitHashFile", "getCommitHashFile", "()Ljava/io/File;", "commitHashFile$delegate", "Lkotlin/Lazy;", "defaultBranch", "getDefaultBranch", "()Ljava/lang/String;", "latestCommitOnDefaultBranch", "getLatestCommitOnDefaultBranch", "localLibrariesDir", "getLocalLibrariesDir", "localPropertiesFile", "getLocalPropertiesFile", "userCacheDir", "getUserCacheDir", "userLibrariesDir", "getUserLibrariesDir", "catchAll", "T", "message", "body", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "checkIfRefUpToDate", "", "remoteRef", "checkRefExistence", "ref", "descriptorFileName", "name", "downloadLatestPropertiesFile", "", "downloadLibraries", "downloadLibraryDescriptor", "downloadSingleFile", "contentsApiUrl", "getGithubHttpWithAuth", "Lorg/jetbrains/kotlinx/jupyter/common/ResponseWrapper;", "url", "getLatestCommitToLibraries", "Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager$CommitInfo;", "sinceTimestamp", "homeLibrariesDir", "homeDir", "isLibraryDescriptor", "file", "resourceFilePath", "saveLocalRef", "createDirsAndWrite", "text", "CommitInfo", "Companion", "common-dependencies"})
public final class LibraryDescriptorsManager {
    private final String authUser;
    private final String authToken;
    private final String apiPrefix;
    @NotNull
    private final File userLibrariesDir;
    @NotNull
    private final File userCacheDir;
    @NotNull
    private final File localLibrariesDir;
    @NotNull
    private final String defaultBranch;
    @NotNull
    private final File localPropertiesFile;
    @NotNull
    private final Lazy commitHashFile$delegate;
    private final String remotePath;
    private final String homePath;
    private final String resourcesPath;
    private final ExceptionsHandler exceptionsHandler;
    private final Logger logger;
    private static final String GITHUB_API_HOST = "api.github.com";
    private static final String DESCRIPTOR_EXTENSION = "json";
    private static final String PROPERTIES_FILE = ".properties";
    private static final String COMMIT_HASH_FILE = "commit_sha";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final File getUserLibrariesDir() {
        return this.userLibrariesDir;
    }

    @NotNull
    public final File getUserCacheDir() {
        return this.userCacheDir;
    }

    @NotNull
    public final File getLocalLibrariesDir() {
        return this.localLibrariesDir;
    }

    @NotNull
    public final String getDefaultBranch() {
        return this.defaultBranch;
    }

    @Nullable
    public final String getLatestCommitOnDefaultBranch() {
        CommitInfo commitInfo = LibraryDescriptorsManager.getLatestCommitToLibraries$default(this, this.defaultBranch, null, 2, null);
        return commitInfo != null ? commitInfo.getSha() : null;
    }

    @NotNull
    public final File homeLibrariesDir(@Nullable File homeDir) {
        File file = homeDir;
        if (file == null) {
            file = new File("");
        }
        return FilesKt.resolve((File)file, (String)this.homePath);
    }

    public static /* synthetic */ File homeLibrariesDir$default(LibraryDescriptorsManager libraryDescriptorsManager, File file, int n, Object object) {
        if ((n & 1) != 0) {
            file = null;
        }
        return libraryDescriptorsManager.homeLibrariesDir(file);
    }

    @NotNull
    public final File getLocalPropertiesFile() {
        return this.localPropertiesFile;
    }

    @NotNull
    public final File getCommitHashFile() {
        Lazy lazy = this.commitHashFile$delegate;
        LibraryDescriptorsManager libraryDescriptorsManager = this;
        Object var3_3 = null;
        return (File)lazy.getValue();
    }

    @NotNull
    public final String descriptorFileName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return name + ".json";
    }

    @NotNull
    public final String resourceFilePath(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.resourcesPath + '/' + this.descriptorFileName(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isLibraryDescriptor(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isFile()) return false;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        if (!StringsKt.endsWith$default((String)string, (String)".json", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Nullable
    public final CommitInfo getLatestCommitToLibraries(@NotNull String ref, @Nullable String sinceTimestamp) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        return (CommitInfo)LibraryDescriptorsManager.catchAll$default(this, null, (Function0)new Function0<CommitInfo>(this, ref, sinceTimestamp){
            final /* synthetic */ LibraryDescriptorsManager this$0;
            final /* synthetic */ String $ref;
            final /* synthetic */ String $sinceTimestamp;

            @Nullable
            public final CommitInfo invoke() {
                CommitInfo commitInfo;
                String url = LibraryDescriptorsManager.access$getApiPrefix$p(this.this$0) + "/commits?path=" + LibraryDescriptorsManager.access$getRemotePath$p(this.this$0) + "&sha=" + this.$ref;
                if (this.$sinceTimestamp != null) {
                    url = url + "&since=" + this.$sinceTimestamp;
                }
                LibraryDescriptorsManager.access$getLogger$p(this.this$0).info("Checking for new commits to library descriptors at " + url);
                JsonArray arr = HttpUtilKt.getJsonArrayOrNull(LibraryDescriptorsManager.access$getGithubHttpWithAuth(this.this$0, url));
                if (arr == null) {
                    LibraryDescriptorsManager.access$getLogger$p(this.this$0).error("Request for the latest commit in libraries failed");
                    return null;
                }
                if (arr.isEmpty()) {
                    if (this.$sinceTimestamp != null) {
                        commitInfo = this.this$0.getLatestCommitToLibraries(this.$ref, null);
                    } else {
                        LibraryDescriptorsManager.access$getLogger$p(this.this$0).info("Didn't find any commits to libraries at " + url);
                        commitInfo = null;
                    }
                } else {
                    JsonElement jsonElement = arr.get(0);
                    if (jsonElement == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
                    }
                    JsonObject commit = (JsonObject)jsonElement;
                    Object object = commit.get((Object)"sha");
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.json.JsonPrimitive");
                    }
                    String sha = ((JsonPrimitive)object).getContent();
                    Object object2 = commit.get((Object)"commit");
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
                    }
                    Object object3 = ((JsonObject)object2).get((Object)"committer");
                    if (object3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
                    }
                    Object object4 = ((JsonObject)object3).get((Object)"date");
                    if (object4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.json.JsonPrimitive");
                    }
                    String timestamp = ((JsonPrimitive)object4).getContent();
                    commitInfo = new CommitInfo(sha, timestamp);
                }
                return commitInfo;
            }
            {
                this.this$0 = libraryDescriptorsManager;
                this.$ref = string;
                this.$sinceTimestamp = string2;
                super(0);
            }
        }, 1, null);
    }

    public static /* synthetic */ CommitInfo getLatestCommitToLibraries$default(LibraryDescriptorsManager libraryDescriptorsManager, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return libraryDescriptorsManager.getLatestCommitToLibraries(string, string2);
    }

    @NotNull
    public final String downloadLibraryDescriptor(@NotNull String ref, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String url = this.apiPrefix + "/contents/" + this.remotePath + '/' + name + ".json?ref=" + ref;
        this.logger.info("Requesting library descriptor at " + url);
        return this.downloadSingleFile(url);
    }

    public final boolean checkRefExistence(@NotNull String ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        ResponseWrapper response = this.getGithubHttpWithAuth(this.apiPrefix + "/contents/" + this.remotePath + "?ref=" + ref);
        return response.getStatus().getSuccessful();
    }

    public final boolean checkIfRefUpToDate(@Nullable String remoteRef) {
        if (!this.getCommitHashFile().exists()) {
            return false;
        }
        if (remoteRef == null) {
            this.logger.warn("Considering reference up-to-date because getting the last reference failed");
            return true;
        }
        String localRef = FilesKt.readText$default((File)this.getCommitHashFile(), null, (int)1, null);
        return Intrinsics.areEqual((Object)localRef, (Object)remoteRef);
    }

    public final void downloadLibraries(@NotNull String ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        this.localLibrariesDir.mkdirs();
        String url = this.apiPrefix + "/contents/" + this.remotePath + "?ref=" + ref;
        this.logger.info("Requesting library descriptors at " + url);
        JsonArray response = HttpUtilKt.getJsonArray(this.getGithubHttpWithAuth(url));
        Iterator iterator = response.iterator();
        while (iterator.hasNext()) {
            JsonElement item;
            JsonElement jsonElement = item = (JsonElement)iterator.next();
            if (jsonElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
            }
            JsonObject cfr_ignored_0 = (JsonObject)jsonElement;
            JsonElement jsonElement2 = (JsonElement)((JsonObject)item).get((Object)"type");
            if (Intrinsics.areEqual((Object)(jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement2)) != null ? jsonElement2.getContent() : null), (Object)"file") ^ true) continue;
            Object object = ((JsonObject)item).get((Object)"name");
            Intrinsics.checkNotNull((Object)object);
            String fileName = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object)).getContent();
            if (!StringsKt.endsWith$default((String)fileName, (String)".json", (boolean)false, (int)2, null)) continue;
            Object object2 = ((JsonObject)item).get((Object)"download_url");
            Intrinsics.checkNotNull((Object)object2);
            String downloadUrl = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object2)).getContent();
            ResponseWrapper descriptorResponse = HttpUtilKt.getHttp(downloadUrl);
            String descriptorText = HttpUtilKt.getText(descriptorResponse);
            File file = FilesKt.resolve((File)this.localLibrariesDir, (String)fileName);
            FilesKt.writeText$default((File)file, (String)descriptorText, null, (int)2, null);
        }
        this.saveLocalRef(ref);
    }

    public final void downloadLatestPropertiesFile() {
        String string = this.getLatestCommitOnDefaultBranch();
        if (string == null) {
            if (this.localPropertiesFile.exists()) {
                this.logger.warn("Cannot load .properties file, but it exists locally");
                return;
            }
            throw (Throwable)new IOException("Cannot load .properties file");
        }
        String ref = string;
        String url = this.apiPrefix + "/contents/" + this.remotePath + "/.properties?ref=" + ref;
        this.logger.info("Requesting .properties file at " + url);
        String text = this.downloadSingleFile(url);
        this.createDirsAndWrite(this.localPropertiesFile, text);
    }

    private final ResponseWrapper getGithubHttpWithAuth(String url) {
        return this.authToken == null || this.authUser == null ? HttpUtilKt.getHttp(url) : HttpUtilKt.getHttpWithAuth(url, this.authUser, this.authToken);
    }

    private final String downloadSingleFile(String contentsApiUrl) {
        JsonObject response = HttpUtilKt.getJsonObject(this.getGithubHttpWithAuth(contentsApiUrl));
        Object object = response.get((Object)"download_url");
        Intrinsics.checkNotNull((Object)object);
        String downloadUrl = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object)).getContent();
        ResponseWrapper res = HttpUtilKt.getHttp(downloadUrl);
        HttpUtilKt.assertSuccessful(res);
        return HttpUtilKt.getText(res);
    }

    private final void saveLocalRef(String ref) {
        this.createDirsAndWrite(this.getCommitHashFile(), ref);
    }

    private final void createDirsAndWrite(File $this$createDirsAndWrite, String text) {
        $this$createDirsAndWrite.getParentFile().mkdirs();
        FilesKt.writeText$default((File)$this$createDirsAndWrite, (String)text, null, (int)2, null);
    }

    static /* synthetic */ void createDirsAndWrite$default(LibraryDescriptorsManager libraryDescriptorsManager, File file, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        libraryDescriptorsManager.createDirsAndWrite(file, string);
    }

    private final <T> T catchAll(String message, Function0<? extends T> body) {
        Object object;
        try {
            object = body.invoke();
        }
        catch (Throwable e) {
            this.exceptionsHandler.handle(this.logger, message, e);
            object = null;
        }
        return (T)object;
    }

    static /* synthetic */ Object catchAll$default(LibraryDescriptorsManager libraryDescriptorsManager, String string, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return libraryDescriptorsManager.catchAll(string, function0);
    }

    private LibraryDescriptorsManager(String user, String repo, String remotePath, String localPath, String homePath, String userPath, String resourcesPath, ExceptionsHandler exceptionsHandler, File userSettingsDir, Logger logger) {
        this.remotePath = remotePath;
        this.homePath = homePath;
        this.resourcesPath = resourcesPath;
        this.exceptionsHandler = exceptionsHandler;
        this.logger = logger;
        this.authUser = System.getenv("KOTLIN_JUPYTER_GITHUB_USER");
        this.authToken = System.getenv("KOTLIN_JUPYTER_GITHUB_TOKEN");
        this.apiPrefix = "https://api.github.com/repos/" + user + '/' + repo;
        this.userLibrariesDir = FilesKt.resolve((File)userSettingsDir, (String)userPath);
        this.userCacheDir = FilesKt.resolve((File)userSettingsDir, (String)"cache");
        this.localLibrariesDir = new File(localPath);
        this.defaultBranch = "master";
        this.localPropertiesFile = FilesKt.resolve((File)this.localLibrariesDir, (String)PROPERTIES_FILE);
        this.commitHashFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ LibraryDescriptorsManager this$0;

            @NotNull
            public final File invoke() {
                File file;
                File file2 = file = FilesKt.resolve((File)this.this$0.getLocalLibrariesDir(), (String)"commit_sha");
                boolean bl = false;
                if (!file2.exists()) {
                    LibraryDescriptorsManager.createDirsAndWrite$default(this.this$0, file2, null, 1, null);
                }
                return file;
            }
            {
                this.this$0 = libraryDescriptorsManager;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ String access$getApiPrefix$p(LibraryDescriptorsManager $this) {
        return $this.apiPrefix;
    }

    public static final /* synthetic */ String access$getRemotePath$p(LibraryDescriptorsManager $this) {
        return $this.remotePath;
    }

    public static final /* synthetic */ Logger access$getLogger$p(LibraryDescriptorsManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ ResponseWrapper access$getGithubHttpWithAuth(LibraryDescriptorsManager $this, String url) {
        return $this.getGithubHttpWithAuth(url);
    }

    public /* synthetic */ LibraryDescriptorsManager(String user, String repo, String remotePath, String localPath, String homePath, String userPath, String resourcesPath, ExceptionsHandler exceptionsHandler, File userSettingsDir, Logger logger, DefaultConstructorMarker $constructor_marker) {
        this(user, repo, remotePath, localPath, homePath, userPath, resourcesPath, exceptionsHandler, userSettingsDir, logger);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager$CommitInfo;", "", "sha", "", "timestamp", "(Ljava/lang/String;Ljava/lang/String;)V", "getSha", "()Ljava/lang/String;", "getTimestamp", "common-dependencies"})
    public static final class CommitInfo {
        @NotNull
        private final String sha;
        @NotNull
        private final String timestamp;

        @NotNull
        public final String getSha() {
            return this.sha;
        }

        @NotNull
        public final String getTimestamp() {
            return this.timestamp;
        }

        public CommitInfo(@NotNull String sha, @NotNull String timestamp) {
            Intrinsics.checkNotNullParameter((Object)sha, (String)"sha");
            Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
            this.sha = sha;
            this.timestamp = timestamp;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager$Companion;", "", "()V", "COMMIT_HASH_FILE", "", "DESCRIPTOR_EXTENSION", "GITHUB_API_HOST", "PROPERTIES_FILE", "getInstance", "Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager;", "logger", "Lorg/slf4j/Logger;", "exceptionsHandler", "Lorg/jetbrains/kotlinx/jupyter/common/ExceptionsHandler;", "common-dependencies"})
    public static final class Companion {
        @NotNull
        public final LibraryDescriptorsManager getInstance(@NotNull Logger logger, @NotNull ExceptionsHandler exceptionsHandler) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)exceptionsHandler, (String)"exceptionsHandler");
            return new LibraryDescriptorsManager("Kotlin", "kotlin-jupyter-libraries", "", "libraries", "libraries", "libraries", "jupyterLibraries", exceptionsHandler, FilesKt.resolve((File)new File(System.getProperty("user.home")), (String)".jupyter_kotlin"), logger, null);
        }

        public static /* synthetic */ LibraryDescriptorsManager getInstance$default(Companion companion, Logger logger, ExceptionsHandler exceptionsHandler, int n, Object object) {
            if ((n & 1) != 0) {
                Logger logger2 = LoggerFactory.getLogger(LibraryDescriptorsManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LoggerFactory.getLogger(\u2026ptorsManager::class.java)");
                logger = logger2;
            }
            if ((n & 2) != 0) {
                exceptionsHandler = ExceptionsHandler.DEFAULT.INSTANCE;
            }
            return companion.getInstance(logger, exceptionsHandler);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

