/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.api;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.internal.ReflectProperties;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.TextRendererWithDescription;
import org.jetbrains.kotlinx.jupyter.api.TextRenderers;
import org.jetbrains.kotlinx.jupyter.api.TextRenderersProcessor;
import org.jetbrains.kotlinx.jupyter.api.TextRenderingKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jb\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\u00150\u001b2\u001a\u0010\u001c\u001a\u0016\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001dH\u0002J\u001e\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0001H\u0002J1\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u00012\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002\u00a2\u0006\u0002\u0010\"J8\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u00012\u0018\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0002\b\u00030&0%H\u0002J*\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u00012\n\u0010'\u001a\u0006\u0012\u0002\b\u00030(H\u0002JL\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00152\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\u00192\b\b\u0002\u0010.\u001a\u00020\u00152\b\b\u0002\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u00020\u00152\b\b\u0002\u00102\u001a\u00020\u0015H\u0002JZ\u00103\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00152\u000e\u00104\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00142\b\b\u0002\u00105\u001a\u00020\u00152\b\b\u0002\u0010.\u001a\u00020\u00152\b\b\u0002\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u00020\u00152\b\b\u0002\u00102\u001a\u00020\u0015H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlinx/jupyter/api/TextRenderers;", "", "()V", "AVOID", "Lorg/jetbrains/kotlinx/jupyter/api/TextRendererWithDescription;", "getAVOID", "()Lorg/jetbrains/kotlinx/jupyter/api/TextRendererWithDescription;", "CLASS", "getCLASS", "ITERABLES", "getITERABLES", "MAPS", "getMAPS", "NULL", "getNULL", "OBJECT", "getOBJECT", "PRIMITIVES", "getPRIMITIVES", "buildAbstractObjectMap", "", "", "P", "obj", "abstractProps", "", "nameGetter", "Lkotlin/Function1;", "valueGetter", "Lkotlin/Function2;", "buildObjectMapByJavaFields", "fields", "", "Ljava/lang/reflect/Field;", "(Ljava/lang/Object;[Ljava/lang/reflect/Field;)Ljava/util/Map;", "buildObjectMapByKotlinProperties", "properties", "", "Lkotlin/reflect/KProperty1;", "clazz", "Lkotlin/reflect/KClass;", "renderIterable", "processor", "Lorg/jetbrains/kotlinx/jupyter/api/TextRenderersProcessor;", "title", "iterable", "separator", "multiline", "", "openBracket", "closeBracket", "renderMap", "map", "arrowString", "api"})
@SourceDebugExtension(value={"SMAP\ntextRendering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 textRendering.kt\norg/jetbrains/kotlinx/jupyter/api/TextRenderers\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n1#2:241\n*E\n"})
public final class TextRenderers {
    @NotNull
    public static final TextRenderers INSTANCE = new TextRenderers();
    @NotNull
    private static final TextRendererWithDescription NULL = new TextRendererWithDescription("renders null", TextRenderers::NULL$lambda$0);
    @NotNull
    private static final TextRendererWithDescription PRIMITIVES = new TextRendererWithDescription("renders strings, booleans and numbers", TextRenderers::PRIMITIVES$lambda$1);
    @NotNull
    private static final TextRendererWithDescription ITERABLES = new TextRendererWithDescription("renders iterables, elements are rendered transitively", TextRenderers::ITERABLES$lambda$2);
    @NotNull
    private static final TextRendererWithDescription MAPS = new TextRendererWithDescription("renders maps, keys and values are rendered transitively", TextRenderers::MAPS$lambda$3);
    @NotNull
    private static final TextRendererWithDescription CLASS = new TextRendererWithDescription("renders KClass<*> objects", TextRenderers::CLASS$lambda$4);
    @NotNull
    private static final TextRendererWithDescription OBJECT = new TextRendererWithDescription("renders any objects", TextRenderers::OBJECT$lambda$5);
    @NotNull
    private static final TextRendererWithDescription AVOID = new TextRendererWithDescription("skips text rendering for some kinds of objects such as java.lang.Class", TextRenderers::AVOID$lambda$6);

    private TextRenderers() {
    }

    @NotNull
    public final TextRendererWithDescription getNULL() {
        return NULL;
    }

    @NotNull
    public final TextRendererWithDescription getPRIMITIVES() {
        return PRIMITIVES;
    }

    @NotNull
    public final TextRendererWithDescription getITERABLES() {
        return ITERABLES;
    }

    @NotNull
    public final TextRendererWithDescription getMAPS() {
        return MAPS;
    }

    @NotNull
    public final TextRendererWithDescription getCLASS() {
        return CLASS;
    }

    @NotNull
    public final TextRendererWithDescription getOBJECT() {
        return OBJECT;
    }

    @NotNull
    public final TextRendererWithDescription getAVOID() {
        return AVOID;
    }

    private final String renderIterable(TextRenderersProcessor processor, String title, Iterable<?> iterable, String separator, boolean multiline, String openBracket, String closeBracket) {
        StringBuilder stringBuilder;
        StringBuilder $this$renderIterable_u24lambda_u249 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$renderIterable_u24lambda_u249.append(title + openBracket);
        if (multiline) {
            $this$renderIterable_u24lambda_u249.append('\n');
        }
        Collection collection = iterable instanceof Collection ? (Collection)iterable : null;
        Iterator<?> iterator = iterable.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            Object el = iterator.next();
            String rel = processor.render(el);
            boolean bl2 = false;
            String it = multiline ? TextRenderingKt.indent$default(rel, null, false, 3, null) : rel;
            boolean bl3 = false;
            $this$renderIterable_u24lambda_u249.append(it);
            if (collection == null || i < collection.size() - 1) {
                $this$renderIterable_u24lambda_u249.append(separator);
                if (!multiline) {
                    $this$renderIterable_u24lambda_u249.append(' ');
                }
            }
            if (!multiline) continue;
            $this$renderIterable_u24lambda_u249.append('\n');
        }
        $this$renderIterable_u24lambda_u249.append(closeBracket);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    static /* synthetic */ String renderIterable$default(TextRenderers textRenderers, TextRenderersProcessor textRenderersProcessor, String string, Iterable iterable, String string2, boolean bl, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = ",";
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            string3 = "[";
        }
        if ((n & 0x40) != 0) {
            string4 = "]";
        }
        return textRenderers.renderIterable(textRenderersProcessor, string, iterable, string2, bl, string3, string4);
    }

    private final String renderMap(TextRenderersProcessor processor, String title, Map<?, ?> map, String arrowString, String separator, boolean multiline, String openBracket, String closeBracket) {
        StringBuilder stringBuilder;
        StringBuilder $this$renderMap_u24lambda_u2414 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$renderMap_u24lambda_u2414.append(title + openBracket);
        if (multiline) {
            $this$renderMap_u24lambda_u2414.append('\n');
        }
        int i = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            String rk = processor.render(k);
            boolean bl2 = false;
            String it = multiline ? TextRenderingKt.indent$default(rk, null, false, 3, null) : rk;
            boolean bl3 = false;
            $this$renderMap_u24lambda_u2414.append(it);
            $this$renderMap_u24lambda_u2414.append(arrowString);
            String rv = processor.render(v);
            boolean bl4 = false;
            it = multiline ? TextRenderingKt.indent$default(rv, null, true, 1, null) : rv;
            boolean bl5 = false;
            $this$renderMap_u24lambda_u2414.append(it);
            if (i < map.size() - 1) {
                $this$renderMap_u24lambda_u2414.append(separator);
                if (!multiline) {
                    $this$renderMap_u24lambda_u2414.append(' ');
                }
            }
            if (multiline) {
                $this$renderMap_u24lambda_u2414.append('\n');
            }
            ++i;
        }
        $this$renderMap_u24lambda_u2414.append(closeBracket);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    static /* synthetic */ String renderMap$default(TextRenderers textRenderers, TextRenderersProcessor textRenderersProcessor, String string, Map map, String string2, String string3, boolean bl, String string4, String string5, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = " => ";
        }
        if ((n & 0x10) != 0) {
            string3 = ",";
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            string4 = "{";
        }
        if ((n & 0x80) != 0) {
            string5 = "}";
        }
        return textRenderers.renderMap(textRenderersProcessor, string, map, string2, string3, bl, string4, string5);
    }

    private final Map<String, Object> buildObjectMapByJavaFields(Object obj) {
        Class<?> clazz = obj.getClass();
        Field[] fieldArray = clazz.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"clazz.declaredFields");
        return this.buildObjectMapByJavaFields(obj, fieldArray);
    }

    private final Map<String, Object> buildObjectMapByJavaFields(Object obj, Field[] fields) {
        return this.buildAbstractObjectMap(obj, ArraysKt.toList((Object[])fields), buildObjectMapByJavaFields.1.INSTANCE, buildObjectMapByJavaFields.2.INSTANCE);
    }

    private final Map<String, Object> buildObjectMapByKotlinProperties(Object obj, KClass<?> clazz) {
        return this.buildObjectMapByKotlinProperties(obj, KClasses.getMemberProperties(clazz));
    }

    private final Map<String, Object> buildObjectMapByKotlinProperties(Object obj, Collection<? extends KProperty1<? extends Object, ?>> properties) {
        return this.buildAbstractObjectMap(obj, (Iterable)properties, buildObjectMapByKotlinProperties.1.INSTANCE, buildObjectMapByKotlinProperties.2.INSTANCE);
    }

    private final <P> Map<String, Object> buildAbstractObjectMap(Object obj, Iterable<? extends P> abstractProps, Function1<? super P, String> nameGetter, Function2<? super P, Object, ? extends Object> valueGetter) {
        HashMap<String, String> hashMap;
        HashMap<String, String> $this$buildAbstractObjectMap_u24lambda_u2415 = hashMap = new HashMap<String, String>();
        boolean bl = false;
        for (P prop : abstractProps) {
            Object object;
            String name = (String)nameGetter.invoke(prop);
            try {
                object = valueGetter.invoke(prop, obj);
            }
            catch (IllegalAccessException e) {
                object = "[exception thrown]";
            }
            catch (RuntimeException e) {
                object = "[inaccessible field]";
            }
            String value = object;
            $this$buildAbstractObjectMap_u24lambda_u2415.put(name, value);
        }
        return hashMap;
    }

    private static final String NULL$lambda$0(TextRenderersProcessor textRenderersProcessor, Object value) {
        Intrinsics.checkNotNullParameter((Object)textRenderersProcessor, (String)"<anonymous parameter 0>");
        return value == null ? "null" : null;
    }

    private static final String PRIMITIVES$lambda$1(TextRenderersProcessor textRenderersProcessor, Object value) {
        Intrinsics.checkNotNullParameter((Object)textRenderersProcessor, (String)"<anonymous parameter 0>");
        Object object = value;
        return object instanceof String ? (String)value : (object instanceof Number ? ((Number)value).toString() : (object instanceof Boolean ? String.valueOf((Boolean)value) : null));
    }

    private static final String ITERABLES$lambda$2(TextRenderersProcessor processor, Object value) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        return !(value instanceof Iterable) ? null : ((Iterable)value instanceof ClosedRange ? value.toString() : TextRenderers.renderIterable$default(INSTANCE, processor, processor.render(Reflection.getOrCreateKotlinClass(value.getClass())), (Iterable)value, null, false, null, null, 120, null));
    }

    private static final String MAPS$lambda$3(TextRenderersProcessor processor, Object value) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        return !(value instanceof Map) ? null : TextRenderers.renderMap$default(INSTANCE, processor, processor.render(Reflection.getOrCreateKotlinClass(value.getClass())), (Map)value, null, null, false, null, null, 248, null);
    }

    private static final String CLASS$lambda$4(TextRenderersProcessor textRenderersProcessor, Object value) {
        Intrinsics.checkNotNullParameter((Object)textRenderersProcessor, (String)"<anonymous parameter 0>");
        return !(value instanceof KClass) ? null : ((KClass)value).getSimpleName();
    }

    private static final String OBJECT$lambda$5(TextRenderersProcessor processor, Object value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        if (value == null) {
            string = null;
        } else {
            Object object = value;
            if (object instanceof ReflectProperties.Val) {
                string = ((ReflectProperties.Val)value).toString();
            } else if (object instanceof KClass) {
                string = ((KClass)value).getSimpleName();
            } else if (object instanceof Class) {
                string = ((Class)value).getSimpleName();
            } else {
                Object object2 = value;
                Map<String, Object> valueMap = object2 instanceof MatchResult ? INSTANCE.buildObjectMapByKotlinProperties(value, Reflection.getOrCreateKotlinClass(MatchResult.class)) : (object2 instanceof MatchGroup ? INSTANCE.buildObjectMapByKotlinProperties(value, Reflection.getOrCreateKotlinClass(MatchGroup.class)) : INSTANCE.buildObjectMapByJavaFields(value));
                string = TextRenderers.renderMap$default(INSTANCE, processor, processor.render(Reflection.getOrCreateKotlinClass(value.getClass())), valueMap, "=", null, false, "(", ")", 48, null);
            }
        }
        return string;
    }

    private static final String AVOID$lambda$6(TextRenderersProcessor textRenderersProcessor, Object value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)textRenderersProcessor, (String)"<anonymous parameter 0>");
        if (value == null) {
            string = null;
        } else {
            String className;
            KClass clazz = Reflection.getOrCreateKotlinClass(value.getClass());
            String string2 = className = clazz.getQualifiedName();
            string = (string2 != null ? StringsKt.startsWith$default((String)string2, (String)"java.lang.", (boolean)false, (int)2, null) : false) ? value.toString() : null;
        }
        return string;
    }
}

