/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.inference.savedmodel;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.KGraph;
import org.jetbrains.kotlinx.dl.api.core.util.ConvertersKt;
import org.jetbrains.kotlinx.dl.api.inference.TensorFlowInferenceModel;
import org.jetbrains.kotlinx.dl.api.inference.savedmodel.SavedModel;
import org.jetbrains.kotlinx.dl.dataset.OnHeapDataset;
import org.jetbrains.kotlinx.dl.impl.util.AutoClosableExtensionsKt;
import org.tensorflow.Graph;
import org.tensorflow.SavedModelBundle;
import org.tensorflow.Session;
import org.tensorflow.Tensor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/savedmodel/SavedModel;", "Lorg/jetbrains/kotlinx/dl/api/inference/TensorFlowInferenceModel;", "()V", "bundle", "Lorg/tensorflow/SavedModelBundle;", "close", "", "predict", "", "inputData", "", "inputTensorName", "", "outputTensorName", "", "dataset", "Lorg/jetbrains/kotlinx/dl/dataset/OnHeapDataset;", "Companion", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nSavedModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SavedModel.kt\norg/jetbrains/kotlinx/dl/api/inference/savedmodel/SavedModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public class SavedModel
extends TensorFlowInferenceModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private SavedModelBundle bundle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int predict(@NotNull float[] inputData) {
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        if (!this.isShapeInitialized()) {
            boolean $i$a$-require-SavedModel$predict$22 = false;
            String $i$a$-require-SavedModel$predict$22 = "Data shape is missed!";
            throw new IllegalArgumentException($i$a$-require-SavedModel$predict$22.toString());
        }
        FloatBuffer preparedData = ConvertersKt.serializeToBuffer(inputData);
        Tensor tensor = Tensor.create((long[])this.getShape(), (FloatBuffer)preparedData);
        AutoCloseable autoCloseable = (AutoCloseable)tensor;
        Throwable throwable = null;
        try {
            Tensor it = (Tensor)autoCloseable;
            boolean bl = false;
            Session.Runner runner = this.getSession$tensorflow().runner();
            List list = runner.feed(this.getInput().getTfName(), it).fetch(this.getOutput().getTfName()).run();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"runner.feed(input.tfName\u2026e)\n                .run()");
            int n = ((Number)AutoClosableExtensionsKt.use((List)list, (Function1)predict.2.1.INSTANCE)).intValue();
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int predict(@NotNull float[] inputData, @NotNull String inputTensorName, @NotNull String outputTensorName) {
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        Intrinsics.checkNotNullParameter((Object)inputTensorName, (String)"inputTensorName");
        Intrinsics.checkNotNullParameter((Object)outputTensorName, (String)"outputTensorName");
        if (!this.isShapeInitialized()) {
            boolean $i$a$-require-SavedModel$predict$42 = false;
            String $i$a$-require-SavedModel$predict$42 = "Data shape is missed!";
            throw new IllegalArgumentException($i$a$-require-SavedModel$predict$42.toString());
        }
        FloatBuffer preparedData = ConvertersKt.serializeToBuffer(inputData);
        Tensor tensor = Tensor.create((long[])this.getShape(), (FloatBuffer)preparedData);
        AutoCloseable autoCloseable = (AutoCloseable)tensor;
        Throwable throwable = null;
        try {
            Tensor it = (Tensor)autoCloseable;
            boolean bl = false;
            Session.Runner runner = this.getSession$tensorflow().runner();
            List list = runner.feed(inputTensorName, it).fetch(outputTensorName).run();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"runner.feed(inputTensorN\u2026e)\n                .run()");
            int n = ((Number)AutoClosableExtensionsKt.use((List)list, (Function1)predict.4.1.INSTANCE)).intValue();
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public final List<Integer> predict(@NotNull OnHeapDataset dataset, @NotNull String inputTensorName, @NotNull String outputTensorName) {
        Intrinsics.checkNotNullParameter((Object)dataset, (String)"dataset");
        Intrinsics.checkNotNullParameter((Object)inputTensorName, (String)"inputTensorName");
        Intrinsics.checkNotNullParameter((Object)outputTensorName, (String)"outputTensorName");
        List predictedLabels = new ArrayList();
        int n = dataset.xSize();
        for (int i = 0; i < n; ++i) {
            int predictedLabel = this.predict(dataset.getX(i), inputTensorName, outputTensorName);
            predictedLabels.add(predictedLabel);
        }
        return predictedLabels;
    }

    @Override
    public void close() {
        super.close();
        SavedModelBundle savedModelBundle = this.bundle;
        if (savedModelBundle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundle");
            savedModelBundle = null;
        }
        savedModelBundle.close();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/savedmodel/SavedModel$Companion;", "", "()V", "load", "Lorg/jetbrains/kotlinx/dl/api/inference/savedmodel/SavedModel;", "pathToModel", "", "tensorflow"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SavedModel load(@NotNull String pathToModel) {
            Intrinsics.checkNotNullParameter((Object)pathToModel, (String)"pathToModel");
            SavedModel model = new SavedModel();
            String[] stringArray = new String[]{"serve"};
            SavedModelBundle savedModelBundle = SavedModelBundle.load((String)pathToModel, (String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)savedModelBundle, (String)"load(pathToModel, \"serve\")");
            model.bundle = savedModelBundle;
            SavedModelBundle savedModelBundle2 = model.bundle;
            if (savedModelBundle2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bundle");
                savedModelBundle2 = null;
            }
            Session session = savedModelBundle2.session();
            Intrinsics.checkNotNullExpressionValue((Object)session, (String)"model.bundle.session()");
            model.setSession$tensorflow(session);
            SavedModelBundle savedModelBundle3 = model.bundle;
            if (savedModelBundle3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bundle");
                savedModelBundle3 = null;
            }
            Graph graph = savedModelBundle3.graph();
            byte[] graphDef = graph.toGraphDef();
            Intrinsics.checkNotNullExpressionValue((Object)graphDef, (String)"graphDef");
            model.setKGraph(new KGraph(graphDef));
            return model;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

