/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.inference.loaders;

import io.jhdf.HdfFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.Functional;
import org.jetbrains.kotlinx.dl.api.core.GraphTrainableModel;
import org.jetbrains.kotlinx.dl.api.core.GraphTrainableModelKt;
import org.jetbrains.kotlinx.dl.api.core.Sequential;
import org.jetbrains.kotlinx.dl.api.core.loss.Losses;
import org.jetbrains.kotlinx.dl.api.core.metric.Metrics;
import org.jetbrains.kotlinx.dl.api.core.optimizer.Adam;
import org.jetbrains.kotlinx.dl.api.core.optimizer.Optimizer;
import org.jetbrains.kotlinx.dl.api.core.shape.TensorShape;
import org.jetbrains.kotlinx.dl.api.inference.InferenceModel;
import org.jetbrains.kotlinx.dl.api.inference.keras.WeightLoaderKt;
import org.jetbrains.kotlinx.dl.api.inference.loaders.ModelHub;
import org.jetbrains.kotlinx.dl.api.inference.loaders.ModelType;
import org.jetbrains.kotlinx.dl.api.inference.loaders.TFModelHub;
import org.jetbrains.kotlinx.dl.api.inference.loaders.TFModelType;
import org.jetbrains.kotlinx.dl.api.preprocessing.Operation;
import org.jetbrains.kotlinx.dl.impl.inference.imagerecognition.ImageRecognitionModel;
import org.jetbrains.kotlinx.dl.impl.inference.imagerecognition.InputType;
import org.jetbrains.kotlinx.dl.impl.preprocessing.image.ColorMode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\bH\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels;", "", "()V", "loadModel", "Lorg/jetbrains/kotlinx/dl/api/core/GraphTrainableModel;", "modelHub", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/ModelHub;", "modelType", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "CV", "tensorflow"})
public final class TFModels {
    @NotNull
    public static final TFModels INSTANCE = new TFModels();

    private TFModels() {
    }

    private final GraphTrainableModel loadModel(ModelHub modelHub, CV<? extends GraphTrainableModel> modelType) {
        Intrinsics.checkNotNull((Object)modelHub, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dl.api.inference.loaders.TFModelHub");
        TFModelHub cfr_ignored_0 = (TFModelHub)modelHub;
        GraphTrainableModel model = (GraphTrainableModel)ModelHub.loadModel$default((ModelHub)modelHub, (ModelType)modelType, null, (int)2, null);
        model.compile((Optimizer)new Adam(0.0f, 0.0f, 0.0f, 0.0f, false, null, 63, null), Losses.MAE, Metrics.ACCURACY);
        HdfFile hdfFile = TFModelHub.loadWeights$default((TFModelHub)modelHub, modelType, null, 2, null);
        WeightLoaderKt.loadWeights(model, hdfFile);
        return model;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003:\u0013\u001d\u001e\u001f !\"#$%&'()*+,-./B9\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u0082\u0001\u00130123456789:;<=>?@AB\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "T", "Lorg/jetbrains/kotlinx/dl/api/core/GraphTrainableModel;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModelType;", "Lorg/jetbrains/kotlinx/dl/impl/inference/imagerecognition/ImageRecognitionModel;", "relativePath", "", "channelsFirst", "", "inputColorMode", "Lorg/jetbrains/kotlinx/dl/impl/preprocessing/image/ColorMode;", "inputShape", "", "noTop", "(Ljava/lang/String;ZLorg/jetbrains/kotlinx/dl/impl/preprocessing/image/ColorMode;[IZ)V", "getInputShape", "()[I", "setInputShape", "([I)V", "modelRelativePath", "getModelRelativePath", "()Ljava/lang/String;", "loadModelConfiguration", "jsonFile", "Ljava/io/File;", "(Ljava/io/File;)Lorg/jetbrains/kotlinx/dl/api/core/GraphTrainableModel;", "pretrainedModel", "modelHub", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/ModelHub;", "DenseNet121", "DenseNet169", "DenseNet201", "Inception", "MobileNet", "MobileNetV2", "NASNetLarge", "NASNetMobile", "ResNet101", "ResNet101v2", "ResNet152", "ResNet152v2", "ResNet18", "ResNet34", "ResNet50", "ResNet50v2", "VGG16", "VGG19", "Xception", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$DenseNet121;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$DenseNet169;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$DenseNet201;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$Inception;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$MobileNet;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$MobileNetV2;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$NASNetLarge;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$NASNetMobile;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$ResNet101;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$ResNet101v2;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$ResNet152;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$ResNet152v2;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$ResNet18;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$ResNet34;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$ResNet50;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$ResNet50v2;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$VGG16;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$VGG19;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$Xception;", "tensorflow"})
    @SourceDebugExtension(value={"SMAP\nTFModels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TFModels.kt\norg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,565:1\n1#2:566\n*E\n"})
    public static abstract class CV<T extends GraphTrainableModel>
    implements TFModelType<T, ImageRecognitionModel> {
        private final boolean channelsFirst;
        @NotNull
        private final ColorMode inputColorMode;
        @Nullable
        private int[] inputShape;
        @NotNull
        private final String modelRelativePath;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private CV(String relativePath, boolean channelsFirst, ColorMode inputColorMode, int[] inputShape, boolean noTop) {
            this.channelsFirst = channelsFirst;
            this.inputColorMode = inputColorMode;
            this.inputShape = inputShape;
            this.modelRelativePath = noTop ? relativePath + "/notop" : relativePath;
            if (this.inputShape == null) return;
            Intrinsics.checkNotNull((Object)this.inputShape);
            if (!(this.inputShape.length == 3)) {
                boolean $i$a$-require-TFModels$CV$32 = false;
                String $i$a$-require-TFModels$CV$32 = "Input shape for the model " + JvmClassMappingKt.getKotlinClass(this.getClass()).getSimpleName() + " should contain 3 number: height, weight and number of channels.";
                throw new IllegalArgumentException($i$a$-require-TFModels$CV$32.toString());
            }
            Intrinsics.checkNotNull((Object)this.inputShape);
            if (this.inputShape[0] >= 32) {
                Intrinsics.checkNotNull((Object)this.inputShape);
                if (this.inputShape[1] >= 32) {
                    return;
                }
            }
            boolean bl = false;
            if (bl) return;
            boolean bl2 = false;
            String string = "Width and height should be no smaller than 32 for the model " + JvmClassMappingKt.getKotlinClass(this.getClass()).getSimpleName() + '.';
            throw new IllegalArgumentException(string.toString());
        }

        public /* synthetic */ CV(String string, boolean bl, ColorMode colorMode, int[] nArray, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                colorMode = ColorMode.RGB;
            }
            if ((n & 8) != 0) {
                nArray = null;
            }
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            this(string, bl, colorMode, nArray, bl2, null);
        }

        @Nullable
        public final int[] getInputShape() {
            return this.inputShape;
        }

        public final void setInputShape(@Nullable int[] nArray) {
            this.inputShape = nArray;
        }

        @NotNull
        public String getModelRelativePath() {
            return this.modelRelativePath;
        }

        @NotNull
        public ImageRecognitionModel pretrainedModel(@NotNull ModelHub modelHub) {
            Intrinsics.checkNotNullParameter((Object)modelHub, (String)"modelHub");
            GraphTrainableModel model = INSTANCE.loadModel(modelHub, this);
            return new ImageRecognitionModel((InferenceModel)model, this.inputColorMode, this.channelsFirst, this.getPreprocessor(), Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
        }

        @Override
        @NotNull
        public T loadModelConfiguration(@NotNull File jsonFile) {
            GraphTrainableModel graphTrainableModel;
            Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
            Functional functional2 = Functional.Companion.loadModelConfiguration(jsonFile, this.inputShape);
            Intrinsics.checkNotNull((Object)functional2, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlinx.dl.api.inference.loaders.TFModels.CV");
            GraphTrainableModel $this$loadModelConfiguration_u24lambda_u242 = graphTrainableModel = (GraphTrainableModel)functional2;
            boolean bl = false;
            GraphTrainableModelKt.freeze($this$loadModelConfiguration_u24lambda_u242);
            return (T)graphTrainableModel;
        }

        @NotNull
        public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
            return TFModelType.DefaultImpls.getPreprocessor(this);
        }

        @NotNull
        public T model(@NotNull ModelHub modelHub) {
            return (T)((GraphTrainableModel)TFModelType.DefaultImpls.model(this, modelHub));
        }

        public /* synthetic */ CV(String relativePath, boolean channelsFirst, ColorMode inputColorMode, int[] inputShape, boolean noTop, DefaultConstructorMarker $constructor_marker) {
            this(relativePath, channelsFirst, inputColorMode, inputShape, noTop);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005R8\u0010\u0006\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$DenseNet121;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "inputShape", "", "([I)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "tensorflow"})
        public static final class DenseNet121
        extends CV<Functional> {
            public DenseNet121(@Nullable int[] inputShape) {
                super("models/tensorflow/cv/densenet121", false, null, inputShape, false, 6, null);
            }

            public /* synthetic */ DenseNet121(int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    nArray = null;
                }
                this(nArray);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.TORCH, (boolean)false, (int)1, null);
            }

            public DenseNet121() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005R8\u0010\u0006\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$DenseNet169;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "inputShape", "", "([I)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "tensorflow"})
        public static final class DenseNet169
        extends CV<Functional> {
            public DenseNet169(@Nullable int[] inputShape) {
                super("models/tensorflow/cv/densenet169", false, null, inputShape, false, 6, null);
            }

            public /* synthetic */ DenseNet169(int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    nArray = null;
                }
                this(nArray);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.TORCH, (boolean)false, (int)1, null);
            }

            public DenseNet169() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005R8\u0010\u0006\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$DenseNet201;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "inputShape", "", "([I)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "tensorflow"})
        public static final class DenseNet201
        extends CV<Functional> {
            public DenseNet201(@Nullable int[] inputShape) {
                super("models/tensorflow/cv/densenet201", false, null, inputShape, false, 6, null);
            }

            public /* synthetic */ DenseNet201(int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    nArray = null;
                }
                this(nArray);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.TORCH, (boolean)false, (int)1, null);
            }

            public DenseNet201() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R8\u0010\b\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$Inception;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "noTop", "", "inputShape", "", "(Z[I)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "tensorflow"})
        public static final class Inception
        extends CV<Functional> {
            public Inception(boolean noTop, @Nullable int[] inputShape) {
                super("models/tensorflow/cv/inception", false, null, inputShape, noTop, 6, null);
            }

            public /* synthetic */ Inception(boolean bl, int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    nArray = null;
                }
                this(bl, nArray);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.TF, (boolean)false, (int)1, null);
            }

            public Inception() {
                this(false, null, 3, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R8\u0010\b\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$MobileNet;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "noTop", "", "inputShape", "", "(Z[I)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "tensorflow"})
        public static final class MobileNet
        extends CV<Functional> {
            public MobileNet(boolean noTop, @Nullable int[] inputShape) {
                super("models/tensorflow/cv/mobilenet", false, null, inputShape, noTop, 6, null);
            }

            public /* synthetic */ MobileNet(boolean bl, int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    nArray = null;
                }
                this(bl, nArray);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.TF, (boolean)false, (int)1, null);
            }

            public MobileNet() {
                this(false, null, 3, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R8\u0010\b\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$MobileNetV2;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "noTop", "", "inputShape", "", "(Z[I)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "tensorflow"})
        public static final class MobileNetV2
        extends CV<Functional> {
            public MobileNetV2(boolean noTop, @Nullable int[] inputShape) {
                super("models/tensorflow/cv/mobilenetv2", false, null, inputShape, noTop, 6, null);
            }

            public /* synthetic */ MobileNetV2(boolean bl, int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    nArray = null;
                }
                this(bl, nArray);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.TF, (boolean)false, (int)1, null);
            }

            public MobileNetV2() {
                this(false, null, 3, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R8\u0010\b\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$NASNetLarge;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "noTop", "", "inputShape", "", "(Z[I)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "tensorflow"})
        @SourceDebugExtension(value={"SMAP\nTFModels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TFModels.kt\norg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$NASNetLarge\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,565:1\n1#2:566\n*E\n"})
        public static final class NASNetLarge
        extends CV<Functional> {
            public NASNetLarge(boolean noTop, @Nullable int[] inputShape) {
                super("models/tensorflow/cv/nasnetlarge", false, null, inputShape, noTop, 6, null);
                Intrinsics.checkNotNull((Object)inputShape);
                if (!(inputShape[0] >= 331 && inputShape[1] >= 331)) {
                    boolean bl = false;
                    String string = "Width and height should be no smaller than 331 for the model " + JvmClassMappingKt.getKotlinClass(this.getClass()).getSimpleName() + '.';
                    throw new IllegalArgumentException(string.toString());
                }
            }

            public /* synthetic */ NASNetLarge(boolean bl, int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    int[] nArray2 = new int[]{331, 331, 3};
                    nArray = nArray2;
                }
                this(bl, nArray);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.TF, (boolean)false, (int)1, null);
            }

            public NASNetLarge() {
                this(false, null, 3, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R8\u0010\u0006\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$NASNetMobile;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "noTop", "", "(Z)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "tensorflow"})
        public static final class NASNetMobile
        extends CV<Functional> {
            public NASNetMobile(boolean noTop) {
                int[] nArray = new int[]{224, 224, 3};
                super("models/tensorflow/cv/nasnetmobile", false, null, nArray, noTop, 6, null);
            }

            public /* synthetic */ NASNetMobile(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                this(bl);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.TF, (boolean)false, (int)1, null);
            }

            public NASNetMobile() {
                this(false, 1, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R8\u0010\b\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$ResNet101;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "noTop", "", "inputShape", "", "(Z[I)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "tensorflow"})
        public static final class ResNet101
        extends CV<Functional> {
            public ResNet101(boolean noTop, @Nullable int[] inputShape) {
                ColorMode colorMode = ColorMode.BGR;
                super("models/tensorflow/cv/resnet101", false, colorMode, inputShape, noTop, 2, null);
            }

            public /* synthetic */ ResNet101(boolean bl, int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    nArray = null;
                }
                this(bl, nArray);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.CAFFE, (boolean)false, (int)1, null);
            }

            public ResNet101() {
                this(false, null, 3, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R8\u0010\b\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$ResNet101v2;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "noTop", "", "inputShape", "", "(Z[I)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "tensorflow"})
        public static final class ResNet101v2
        extends CV<Functional> {
            public ResNet101v2(boolean noTop, @Nullable int[] inputShape) {
                super("models/tensorflow/cv/resnet101v2", false, null, inputShape, noTop, 6, null);
            }

            public /* synthetic */ ResNet101v2(boolean bl, int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    nArray = null;
                }
                this(bl, nArray);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.TF, (boolean)false, (int)1, null);
            }

            public ResNet101v2() {
                this(false, null, 3, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R8\u0010\b\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$ResNet152;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "noTop", "", "inputShape", "", "(Z[I)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "tensorflow"})
        public static final class ResNet152
        extends CV<Functional> {
            public ResNet152(boolean noTop, @Nullable int[] inputShape) {
                ColorMode colorMode = ColorMode.BGR;
                super("models/tensorflow/cv/resnet152", false, colorMode, inputShape, noTop, 2, null);
            }

            public /* synthetic */ ResNet152(boolean bl, int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    nArray = null;
                }
                this(bl, nArray);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.CAFFE, (boolean)false, (int)1, null);
            }

            public ResNet152() {
                this(false, null, 3, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R8\u0010\b\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$ResNet152v2;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "noTop", "", "inputShape", "", "(Z[I)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "tensorflow"})
        public static final class ResNet152v2
        extends CV<Functional> {
            public ResNet152v2(boolean noTop, @Nullable int[] inputShape) {
                super("models/tensorflow/cv/resnet152v2", false, null, inputShape, noTop, 6, null);
            }

            public /* synthetic */ ResNet152v2(boolean bl, int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    nArray = null;
                }
                this(bl, nArray);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.TF, (boolean)false, (int)1, null);
            }

            public ResNet152v2() {
                this(false, null, 3, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005R8\u0010\u0006\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$ResNet18;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "inputShape", "", "([I)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "tensorflow"})
        public static final class ResNet18
        extends CV<Functional> {
            public ResNet18(@Nullable int[] inputShape) {
                super("models/tensorflow/cv/resnet18", false, null, inputShape, false, 22, null);
            }

            public /* synthetic */ ResNet18(int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    nArray = null;
                }
                this(nArray);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.CAFFE, (boolean)false, (int)1, null);
            }

            public ResNet18() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005R8\u0010\u0006\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$ResNet34;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "inputShape", "", "([I)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "tensorflow"})
        public static final class ResNet34
        extends CV<Functional> {
            public ResNet34(@Nullable int[] inputShape) {
                super("models/tensorflow/cv/resnet34", false, null, inputShape, false, 22, null);
            }

            public /* synthetic */ ResNet34(int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    nArray = null;
                }
                this(nArray);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.CAFFE, (boolean)false, (int)1, null);
            }

            public ResNet34() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R8\u0010\b\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$ResNet50;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "noTop", "", "inputShape", "", "(Z[I)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "tensorflow"})
        public static final class ResNet50
        extends CV<Functional> {
            public ResNet50(boolean noTop, @Nullable int[] inputShape) {
                ColorMode colorMode = ColorMode.BGR;
                super("models/tensorflow/cv/resnet50", false, colorMode, inputShape, noTop, 2, null);
            }

            public /* synthetic */ ResNet50(boolean bl, int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    nArray = null;
                }
                this(bl, nArray);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.CAFFE, (boolean)false, (int)1, null);
            }

            public ResNet50() {
                this(false, null, 3, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R8\u0010\b\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$ResNet50v2;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "noTop", "", "inputShape", "", "(Z[I)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "tensorflow"})
        public static final class ResNet50v2
        extends CV<Functional> {
            public ResNet50v2(boolean noTop, @Nullable int[] inputShape) {
                super("models/tensorflow/cv/resnet50v2", false, null, inputShape, noTop, 6, null);
            }

            public /* synthetic */ ResNet50v2(boolean bl, int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    nArray = null;
                }
                this(bl, nArray);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.TF, (boolean)false, (int)1, null);
            }

            public ResNet50v2() {
                this(false, null, 3, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R8\u0010\b\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$VGG16;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Sequential;", "noTop", "", "inputShape", "", "(Z[I)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "loadModelConfiguration", "jsonFile", "Ljava/io/File;", "tensorflow"})
        @SourceDebugExtension(value={"SMAP\nTFModels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TFModels.kt\norg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$VGG16\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,565:1\n1#2:566\n*E\n"})
        public static final class VGG16
        extends CV<Sequential> {
            public VGG16(boolean noTop, @Nullable int[] inputShape) {
                ColorMode colorMode = ColorMode.BGR;
                super("models/tensorflow/cv/vgg16", false, colorMode, inputShape, noTop, 2, null);
            }

            public /* synthetic */ VGG16(boolean bl, int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    nArray = null;
                }
                this(bl, nArray);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.CAFFE, (boolean)false, (int)1, null);
            }

            @Override
            @NotNull
            public Sequential loadModelConfiguration(@NotNull File jsonFile) {
                Sequential sequential2;
                Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
                Sequential $this$loadModelConfiguration_u24lambda_u240 = sequential2 = Sequential.Companion.loadModelConfiguration(jsonFile, this.getInputShape());
                boolean bl = false;
                GraphTrainableModelKt.freeze($this$loadModelConfiguration_u24lambda_u240);
                return sequential2;
            }

            public VGG16() {
                this(false, null, 3, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R8\u0010\b\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$VGG19;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Sequential;", "noTop", "", "inputShape", "", "(Z[I)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "loadModelConfiguration", "jsonFile", "Ljava/io/File;", "tensorflow"})
        @SourceDebugExtension(value={"SMAP\nTFModels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TFModels.kt\norg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$VGG19\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,565:1\n1#2:566\n*E\n"})
        public static final class VGG19
        extends CV<Sequential> {
            public VGG19(boolean noTop, @Nullable int[] inputShape) {
                ColorMode colorMode = ColorMode.BGR;
                super("models/tensorflow/cv/vgg19", false, colorMode, inputShape, noTop, 2, null);
            }

            public /* synthetic */ VGG19(boolean bl, int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    nArray = null;
                }
                this(bl, nArray);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.CAFFE, (boolean)false, (int)1, null);
            }

            @Override
            @NotNull
            public Sequential loadModelConfiguration(@NotNull File jsonFile) {
                Sequential sequential2;
                Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
                Sequential $this$loadModelConfiguration_u24lambda_u240 = sequential2 = Sequential.Companion.loadModelConfiguration(jsonFile, this.getInputShape());
                boolean bl = false;
                GraphTrainableModelKt.freeze($this$loadModelConfiguration_u24lambda_u240);
                return sequential2;
            }

            public VGG19() {
                this(false, null, 3, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R8\u0010\b\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV$Xception;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModels$CV;", "Lorg/jetbrains/kotlinx/dl/api/core/Functional;", "noTop", "", "inputShape", "", "(Z[I)V", "preprocessor", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "getPreprocessor", "()Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "tensorflow"})
        public static final class Xception
        extends CV<Functional> {
            public Xception(boolean noTop, @Nullable int[] inputShape) {
                super("models/tensorflow/cv/xception", false, null, inputShape, noTop, 6, null);
            }

            public /* synthetic */ Xception(boolean bl, int[] nArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    nArray = null;
                }
                this(bl, nArray);
            }

            @Override
            @NotNull
            public Operation<Pair<float[], TensorShape>, Pair<float[], TensorShape>> getPreprocessor() {
                return InputType.preprocessing$default((InputType)InputType.TF, (boolean)false, (int)1, null);
            }

            public Xception() {
                this(false, null, 3, null);
            }
        }
    }
}

