/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.inference.loaders;

import io.jhdf.HdfFile;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.inference.InferenceModel;
import org.jetbrains.kotlinx.dl.api.inference.loaders.LoadingMode;
import org.jetbrains.kotlinx.dl.api.inference.loaders.ModelHub;
import org.jetbrains.kotlinx.dl.api.inference.loaders.ModelType;
import org.jetbrains.kotlinx.dl.api.inference.loaders.TFModelHub;
import org.jetbrains.kotlinx.dl.api.inference.loaders.TFModelType;
import org.jetbrains.kotlinx.dl.impl.dataset.Imagenet;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\u00032\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fJ=\u0010\u0012\u001a\u0002H\u0013\"\b\b\u0000\u0010\u0013*\u00020\u0014\"\b\b\u0001\u0010\u0015*\u00020\u00142\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u00150\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0016J \u0010\u0017\u001a\u00020\u00182\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b2\b\b\u0002\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/loaders/TFModelHub;", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/ModelHub;", "cacheDirectory", "Ljava/io/File;", "(Ljava/io/File;)V", "getCacheDirectory", "()Ljava/io/File;", "logger", "Lmu/KLogger;", "getJSONConfigFile", "modelType", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/ModelType;", "loadingMode", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/LoadingMode;", "loadClassLabels", "", "", "", "loadModel", "T", "Lorg/jetbrains/kotlinx/dl/api/inference/InferenceModel;", "U", "(Lorg/jetbrains/kotlinx/dl/api/inference/loaders/ModelType;Lorg/jetbrains/kotlinx/dl/api/inference/loaders/LoadingMode;)Lorg/jetbrains/kotlinx/dl/api/inference/InferenceModel;", "loadWeights", "Lio/jhdf/HdfFile;", "tensorflow"})
public final class TFModelHub
extends ModelHub {
    @NotNull
    private final File cacheDirectory;
    @NotNull
    private final KLogger logger;

    public TFModelHub(@NotNull File cacheDirectory) {
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        this.cacheDirectory = cacheDirectory;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        if (!this.cacheDirectory.exists()) {
            Files.createDirectories(this.cacheDirectory.toPath(), new FileAttribute[0]);
        }
    }

    @NotNull
    public final File getCacheDirectory() {
        return this.cacheDirectory;
    }

    @NotNull
    public <T extends InferenceModel, U extends InferenceModel> T loadModel(@NotNull ModelType<T, U> modelType, @NotNull LoadingMode loadingMode) {
        Intrinsics.checkNotNullParameter(modelType, (String)"modelType");
        Intrinsics.checkNotNullParameter((Object)loadingMode, (String)"loadingMode");
        File jsonConfigFile = this.getJSONConfigFile(modelType, loadingMode);
        return (T)((InferenceModel)((TFModelType)modelType).loadModelConfiguration(jsonConfigFile));
    }

    @NotNull
    public final Map<Integer, String> loadClassLabels() {
        return Imagenet.labels$default((Imagenet)Imagenet.V1k, (boolean)false, (int)1, null);
    }

    @NotNull
    public final HdfFile loadWeights(@NotNull ModelType<?, ?> modelType, @NotNull LoadingMode loadingMode) {
        Intrinsics.checkNotNullParameter(modelType, (String)"modelType");
        Intrinsics.checkNotNullParameter((Object)loadingMode, (String)"loadingMode");
        String modelDirectory = '/' + modelType.getModelRelativePath();
        String relativeWeightsPath = modelDirectory + "/weights.h5";
        String weightsURL = this.getAwsS3Url() + modelDirectory + "/weights.h5";
        String fileName = this.cacheDirectory.getAbsolutePath() + relativeWeightsPath;
        File file = new File(fileName);
        if (!file.exists() || loadingMode == LoadingMode.OVERRIDE_IF_EXISTS) {
            InputStream inputStream = new URL(weightsURL).openStream();
            this.logger.info((Function0)loadWeights.1.INSTANCE);
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(inputStream, Paths.get(fileName, new String[0]), copyOptionArray);
            this.logger.info((Function0)loadWeights.2.INSTANCE);
        }
        return new HdfFile(new File(fileName));
    }

    public static /* synthetic */ HdfFile loadWeights$default(TFModelHub tFModelHub, ModelType modelType, LoadingMode loadingMode, int n, Object object) {
        if ((n & 2) != 0) {
            loadingMode = LoadingMode.SKIP_LOADING_IF_EXISTS;
        }
        return tFModelHub.loadWeights(modelType, loadingMode);
    }

    private final File getJSONConfigFile(ModelType<?, ?> modelType, LoadingMode loadingMode) {
        String fileName;
        File file;
        String modelDirectory = '/' + modelType.getModelRelativePath();
        String relativeConfigPath = modelDirectory + "/modelConfig.json";
        String configURL = this.getAwsS3Url() + modelDirectory + "/modelConfig.json";
        File dir = new File(this.cacheDirectory.getAbsolutePath() + modelDirectory);
        if (!dir.exists()) {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        }
        if (!(file = new File(fileName = this.cacheDirectory.getAbsolutePath() + relativeConfigPath)).exists() || loadingMode == LoadingMode.OVERRIDE_IF_EXISTS) {
            InputStream inputStream = new URL(configURL).openStream();
            this.logger.debug((Function0)getJSONConfigFile.1.INSTANCE);
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(inputStream, Paths.get(fileName, new String[0]), copyOptionArray);
            this.logger.debug((Function0)getJSONConfigFile.2.INSTANCE);
        }
        return new File(fileName);
    }
}

