/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.inference.keras;

import io.jhdf.HdfFile;
import io.jhdf.api.Attribute;
import io.jhdf.api.Group;
import io.jhdf.api.Node;
import io.jhdf.dataset.DatasetBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.GraphTrainableModel;
import org.jetbrains.kotlinx.dl.api.core.layer.KVariable;
import org.jetbrains.kotlinx.dl.api.core.layer.Layer;
import org.jetbrains.kotlinx.dl.api.core.layer.ParametrizedLayer;
import org.jetbrains.kotlinx.dl.api.core.layer.TrainableLayerKt;
import org.jetbrains.kotlinx.dl.api.core.shape.ShapeFunctionsKt;
import org.jetbrains.kotlinx.dl.api.inference.keras.LayerConvOrDensePaths;
import org.jetbrains.kotlinx.dl.api.inference.keras.LayerPaths;
import org.jetbrains.kotlinx.dl.api.inference.keras.MissedWeightsStrategy;
import org.jetbrains.kotlinx.dl.api.inference.keras.WeightLoaderKt;
import org.jetbrains.kotlinx.dl.api.inference.keras.WeightMappings;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a*\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a \u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\nH\u0002\u001a\u0012\u0010\u0015\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f\u001a \u0010\u0015\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u0017\u001a.\u0010\u0015\u001a\u00020\u0001*\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\u001bH\u0002\u001a&\u0010\u001c\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u001d\u001a\u00020\u00032\b\b\u0002\u0010\u001e\u001a\u00020\u0003\u001a4\u0010\u001c\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00172\b\b\u0002\u0010\u001d\u001a\u00020\u00032\b\b\u0002\u0010\u001e\u001a\u00020\u0003\u001a4\u0010\u001f\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00172\b\b\u0002\u0010\u001d\u001a\u00020\u00032\b\b\u0002\u0010\u001e\u001a\u00020\u0003\u001a4\u0010\u001f\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020$\u001a\u0012\u0010%\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f\u001a&\u0010&\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u001d\u001a\u00020\u00032\b\b\u0002\u0010\u001e\u001a\u00020\u0003\u00a8\u0006'"}, d2={"fillLayerVariablesFromKeras", "", "layerName", "", "variables", "", "Lorg/jetbrains/kotlinx/dl/api/core/layer/KVariable;", "model", "Lorg/jetbrains/kotlinx/dl/api/core/GraphTrainableModel;", "group", "Lio/jhdf/api/Group;", "fillLayerWeights", "layer", "Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;", "hdfFile", "Lio/jhdf/HdfFile;", "layerPaths", "Lorg/jetbrains/kotlinx/dl/api/inference/keras/LayerPaths;", "initLayerWeights", "getKerasVersion", "", "loadWeights", "layerList", "", "layersToLoad", "", "loadWeightsBlock", "Lkotlin/Function1;", "loadWeightsByPathTemplates", "kernelDataPathTemplate", "biasDataPathTemplate", "loadWeightsByPaths", "weightPaths", "missedWeights", "Lorg/jetbrains/kotlinx/dl/api/inference/keras/MissedWeightsStrategy;", "forFrozenLayersOnly", "", "loadWeightsForFrozenLayers", "loadWeightsForFrozenLayersByPathTemplates", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nWeightLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WeightLoader.kt\norg/jetbrains/kotlinx/dl/api/inference/keras/WeightLoaderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,290:1\n819#2:291\n847#2,2:292\n819#2:294\n847#2,2:295\n819#2:297\n847#2,2:298\n1603#2,9:300\n1855#2:309\n1856#2:312\n1612#2:313\n1855#2,2:314\n1549#2:316\n1620#2,3:317\n1549#2:320\n1620#2,3:321\n1549#2:324\n1620#2,3:325\n1855#2,2:328\n1855#2,2:332\n1#3:310\n1#3:311\n215#4,2:330\n*S KotlinDebug\n*F\n+ 1 WeightLoader.kt\norg/jetbrains/kotlinx/dl/api/inference/keras/WeightLoaderKt\n*L\n39#1:291\n39#1:292,2\n108#1:294\n108#1:295,2\n150#1:297\n150#1:298,2\n152#1:300,9\n152#1:309\n152#1:312\n152#1:313\n209#1:314,2\n241#1:316\n241#1:317,3\n242#1:320\n242#1:321,3\n251#1:324\n251#1:325,3\n251#1:328,2\n288#1:332,2\n152#1:311\n273#1:330,2\n*E\n"})
public final class WeightLoaderKt {
    public static final void loadWeights(@NotNull GraphTrainableModel $this$loadWeights, @NotNull HdfFile hdfFile) {
        Intrinsics.checkNotNullParameter((Object)$this$loadWeights, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hdfFile, (String)"hdfFile");
        WeightLoaderKt.loadWeights($this$loadWeights, hdfFile, $this$loadWeights.getLayers());
    }

    /*
     * WARNING - void declaration
     */
    public static final void loadWeightsForFrozenLayers(@NotNull GraphTrainableModel $this$loadWeightsForFrozenLayers, @NotNull HdfFile hdfFile) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Intrinsics.checkNotNullParameter((Object)$this$loadWeightsForFrozenLayers, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hdfFile, (String)"hdfFile");
        Iterable iterable = $this$loadWeightsForFrozenLayers.getLayers();
        HdfFile hdfFile2 = hdfFile;
        GraphTrainableModel graphTrainableModel = $this$loadWeightsForFrozenLayers;
        boolean $i$f$filterNot = false;
        void var4_6 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Layer p0 = (Layer)element$iv$iv;
            boolean bl = false;
            if (TrainableLayerKt.isTrainable(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        WeightLoaderKt.loadWeights(graphTrainableModel, hdfFile2, list);
    }

    public static final void loadWeights(@NotNull GraphTrainableModel $this$loadWeights, @NotNull HdfFile hdfFile, @NotNull List<? extends Layer> layerList) {
        Group group;
        Group group2;
        Intrinsics.checkNotNullParameter((Object)$this$loadWeights, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hdfFile, (String)"hdfFile");
        Intrinsics.checkNotNullParameter(layerList, (String)"layerList");
        if (hdfFile.getAttributes().containsKey("layer_names")) {
            group2 = (Group)hdfFile;
        } else if (hdfFile.getChildren().containsKey("model_weights")) {
            Node node = ((Group)hdfFile).getChild("model_weights");
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type io.jhdf.api.Group");
            group2 = (Group)node;
        } else {
            group2 = group = null;
        }
        if (group == null) {
            $this$loadWeights.getLogger().error((Function0)loadWeights.1.INSTANCE);
            return;
        }
        if (WeightLoaderKt.getKerasVersion(group) == 1) {
            throw new UnsupportedOperationException("The weights loading from Keras 1.x is not supported by default!\nUse loadWeightsViaPathTemplates() method to make custom loading!");
        }
        WeightLoaderKt.loadWeights($this$loadWeights, (Collection<? extends Layer>)layerList, (Function1<? super Layer, Unit>)((Function1)new Function1<Layer, Unit>(group, $this$loadWeights){
            final /* synthetic */ Group $group;
            final /* synthetic */ GraphTrainableModel $this_loadWeights;
            {
                this.$group = $group;
                this.$this_loadWeights = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Layer layer) {
                Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
                WeightLoaderKt.access$fillLayerWeights(layer, this.$group, this.$this_loadWeights);
            }
        }));
    }

    private static final int getKerasVersion(Group $this$getKerasVersion) {
        Attribute attribute = (Attribute)$this$getKerasVersion.getAttributes().get("keras_version");
        if (attribute == null) {
            return 1;
        }
        Attribute kerasVersionAttribute = attribute;
        Object object = kerasVersionAttribute.getData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        if (StringsKt.startsWith$default((String)((String)object), (String)"2", (boolean)false, (int)2, null)) {
            return 2;
        }
        return 1;
    }

    public static final void loadWeightsByPathTemplates(@NotNull GraphTrainableModel $this$loadWeightsByPathTemplates, @NotNull HdfFile hdfFile, @NotNull String kernelDataPathTemplate, @NotNull String biasDataPathTemplate) {
        Intrinsics.checkNotNullParameter((Object)$this$loadWeightsByPathTemplates, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hdfFile, (String)"hdfFile");
        Intrinsics.checkNotNullParameter((Object)kernelDataPathTemplate, (String)"kernelDataPathTemplate");
        Intrinsics.checkNotNullParameter((Object)biasDataPathTemplate, (String)"biasDataPathTemplate");
        WeightLoaderKt.loadWeightsByPathTemplates($this$loadWeightsByPathTemplates, hdfFile, $this$loadWeightsByPathTemplates.getLayers(), kernelDataPathTemplate, biasDataPathTemplate);
    }

    public static /* synthetic */ void loadWeightsByPathTemplates$default(GraphTrainableModel graphTrainableModel, HdfFile hdfFile, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = "/%s/%s/kernel:0";
        }
        if ((n & 4) != 0) {
            string2 = "/%s/%s/bias:0";
        }
        WeightLoaderKt.loadWeightsByPathTemplates(graphTrainableModel, hdfFile, string, string2);
    }

    /*
     * WARNING - void declaration
     */
    public static final void loadWeightsForFrozenLayersByPathTemplates(@NotNull GraphTrainableModel $this$loadWeightsForFrozenLayersByPathTemplates, @NotNull HdfFile hdfFile, @NotNull String kernelDataPathTemplate, @NotNull String biasDataPathTemplate) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Intrinsics.checkNotNullParameter((Object)$this$loadWeightsForFrozenLayersByPathTemplates, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hdfFile, (String)"hdfFile");
        Intrinsics.checkNotNullParameter((Object)kernelDataPathTemplate, (String)"kernelDataPathTemplate");
        Intrinsics.checkNotNullParameter((Object)biasDataPathTemplate, (String)"biasDataPathTemplate");
        Iterable iterable = $this$loadWeightsForFrozenLayersByPathTemplates.getLayers();
        HdfFile hdfFile2 = hdfFile;
        GraphTrainableModel graphTrainableModel = $this$loadWeightsForFrozenLayersByPathTemplates;
        boolean $i$f$filterNot = false;
        void var6_8 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Layer p0 = (Layer)element$iv$iv;
            boolean bl = false;
            if (TrainableLayerKt.isTrainable(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        WeightLoaderKt.loadWeightsByPathTemplates(graphTrainableModel, hdfFile2, list, kernelDataPathTemplate, biasDataPathTemplate);
    }

    public static /* synthetic */ void loadWeightsForFrozenLayersByPathTemplates$default(GraphTrainableModel graphTrainableModel, HdfFile hdfFile, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = "/%s/%s/kernel:0";
        }
        if ((n & 4) != 0) {
            string2 = "/%s/%s/bias:0";
        }
        WeightLoaderKt.loadWeightsForFrozenLayersByPathTemplates(graphTrainableModel, hdfFile, string, string2);
    }

    public static final void loadWeightsByPathTemplates(@NotNull GraphTrainableModel $this$loadWeightsByPathTemplates, @NotNull HdfFile hdfFile, @NotNull List<? extends Layer> layerList, @NotNull String kernelDataPathTemplate, @NotNull String biasDataPathTemplate) {
        Intrinsics.checkNotNullParameter((Object)$this$loadWeightsByPathTemplates, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hdfFile, (String)"hdfFile");
        Intrinsics.checkNotNullParameter(layerList, (String)"layerList");
        Intrinsics.checkNotNullParameter((Object)kernelDataPathTemplate, (String)"kernelDataPathTemplate");
        Intrinsics.checkNotNullParameter((Object)biasDataPathTemplate, (String)"biasDataPathTemplate");
        LayerConvOrDensePaths layerPaths = new LayerConvOrDensePaths("", kernelDataPathTemplate, biasDataPathTemplate);
        WeightLoaderKt.loadWeights($this$loadWeightsByPathTemplates, (Collection<? extends Layer>)layerList, (Function1<? super Layer, Unit>)((Function1)new Function1<Layer, Unit>(hdfFile, layerPaths, $this$loadWeightsByPathTemplates){
            final /* synthetic */ HdfFile $hdfFile;
            final /* synthetic */ LayerConvOrDensePaths $layerPaths;
            final /* synthetic */ GraphTrainableModel $this_loadWeightsByPathTemplates;
            {
                this.$hdfFile = $hdfFile;
                this.$layerPaths = $layerPaths;
                this.$this_loadWeightsByPathTemplates = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Layer layer) {
                Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
                WeightLoaderKt.access$fillLayerWeights(layer, this.$hdfFile, this.$layerPaths, this.$this_loadWeightsByPathTemplates);
            }
        }));
    }

    public static /* synthetic */ void loadWeightsByPathTemplates$default(GraphTrainableModel graphTrainableModel, HdfFile hdfFile, List list, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string = "/%s/%s/kernel:0";
        }
        if ((n & 8) != 0) {
            string2 = "/%s/%s/bias:0";
        }
        WeightLoaderKt.loadWeightsByPathTemplates(graphTrainableModel, hdfFile, list, string, string2);
    }

    /*
     * WARNING - void declaration
     */
    public static final void loadWeightsByPaths(@NotNull GraphTrainableModel $this$loadWeightsByPaths, @NotNull HdfFile hdfFile, @NotNull List<? extends LayerPaths> weightPaths, @NotNull MissedWeightsStrategy missedWeights, boolean forFrozenLayersOnly) {
        void $this$mapNotNullTo$iv$iv;
        List list;
        Iterable destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$loadWeightsByPaths, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hdfFile, (String)"hdfFile");
        Intrinsics.checkNotNullParameter(weightPaths, (String)"weightPaths");
        Intrinsics.checkNotNullParameter((Object)((Object)missedWeights), (String)"missedWeights");
        if (forFrozenLayersOnly) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = $this$loadWeightsByPaths.getLayers();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Layer p0 = (Layer)element$iv$iv;
                boolean bl = false;
                if (TrainableLayerKt.isTrainable(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = $this$loadWeightsByPaths.getLayers();
        }
        List layersToLoad = list;
        Iterable $this$mapNotNull$iv = layersToLoad;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object v1;
            Layer layer;
            block7: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                layer = (Layer)element$iv$iv;
                boolean bl2 = false;
                Iterable iterable = weightPaths;
                for (Object t : iterable) {
                    LayerPaths it = (LayerPaths)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)layer.getName(), (Object)it.getLayerName())) continue;
                    v1 = t;
                    break block7;
                }
                v1 = null;
            }
            LayerPaths layerPaths = v1;
            if (layerPaths == null && missedWeights == MissedWeightsStrategy.INITIALIZE) {
                $this$loadWeightsByPaths.getLogger().warn((Function0)new Function0<Object>(layer){
                    final /* synthetic */ Layer $layer;
                    {
                        this.$layer = $layer;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Layer weight paths for " + this.$layer.getName() + " are not found in 'weightPaths' object. Initialization is going to be done by default initializer.";
                    }
                });
                pair = null;
            } else {
                pair = TuplesKt.to((Object)layer, (Object)layerPaths);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Map layersToWeightPaths2 = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        WeightLoaderKt.loadWeights($this$loadWeightsByPaths, layersToWeightPaths2.keySet(), (Function1<? super Layer, Unit>)((Function1)new Function1<Layer, Unit>(hdfFile, (Map<Layer, ? extends LayerPaths>)layersToWeightPaths2, $this$loadWeightsByPaths){
            final /* synthetic */ HdfFile $hdfFile;
            final /* synthetic */ Map<Layer, LayerPaths> $layersToWeightPaths;
            final /* synthetic */ GraphTrainableModel $this_loadWeightsByPaths;
            {
                this.$hdfFile = $hdfFile;
                this.$layersToWeightPaths = $layersToWeightPaths;
                this.$this_loadWeightsByPaths = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Layer layer) {
                Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
                WeightLoaderKt.access$fillLayerWeights(layer, this.$hdfFile, this.$layersToWeightPaths.get(layer), this.$this_loadWeightsByPaths);
            }
        }));
    }

    public static /* synthetic */ void loadWeightsByPaths$default(GraphTrainableModel graphTrainableModel, HdfFile hdfFile, List list, MissedWeightsStrategy missedWeightsStrategy, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            missedWeightsStrategy = MissedWeightsStrategy.INITIALIZE;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        WeightLoaderKt.loadWeightsByPaths(graphTrainableModel, hdfFile, list, missedWeightsStrategy, bl);
    }

    public static final void loadWeightsByPaths(@NotNull GraphTrainableModel $this$loadWeightsByPaths, @NotNull HdfFile hdfFile, @NotNull List<? extends Layer> layerList, @NotNull String kernelDataPathTemplate, @NotNull String biasDataPathTemplate) {
        Intrinsics.checkNotNullParameter((Object)$this$loadWeightsByPaths, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hdfFile, (String)"hdfFile");
        Intrinsics.checkNotNullParameter(layerList, (String)"layerList");
        Intrinsics.checkNotNullParameter((Object)kernelDataPathTemplate, (String)"kernelDataPathTemplate");
        Intrinsics.checkNotNullParameter((Object)biasDataPathTemplate, (String)"biasDataPathTemplate");
        LayerConvOrDensePaths layerConvOrDensePaths = new LayerConvOrDensePaths("", kernelDataPathTemplate, biasDataPathTemplate);
        WeightLoaderKt.loadWeights($this$loadWeightsByPaths, (Collection<? extends Layer>)layerList, (Function1<? super Layer, Unit>)((Function1)new Function1<Layer, Unit>(hdfFile, layerConvOrDensePaths, $this$loadWeightsByPaths){
            final /* synthetic */ HdfFile $hdfFile;
            final /* synthetic */ LayerConvOrDensePaths $layerConvOrDensePaths;
            final /* synthetic */ GraphTrainableModel $this_loadWeightsByPaths;
            {
                this.$hdfFile = $hdfFile;
                this.$layerConvOrDensePaths = $layerConvOrDensePaths;
                this.$this_loadWeightsByPaths = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Layer layer) {
                Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
                WeightLoaderKt.access$fillLayerWeights(layer, this.$hdfFile, this.$layerConvOrDensePaths, this.$this_loadWeightsByPaths);
            }
        }));
    }

    public static /* synthetic */ void loadWeightsByPaths$default(GraphTrainableModel graphTrainableModel, HdfFile hdfFile, List list, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string = "/%s/%s/kernel:0";
        }
        if ((n & 8) != 0) {
            string2 = "/%s/%s/bias:0";
        }
        WeightLoaderKt.loadWeightsByPaths(graphTrainableModel, hdfFile, list, string, string2);
    }

    private static final void loadWeights(GraphTrainableModel $this$loadWeights, Collection<? extends Layer> layersToLoad, Function1<? super Layer, Unit> loadWeightsBlock) {
        if (!$this$loadWeights.isModelCompiled()) {
            boolean $i$a$-check-WeightLoaderKt$loadWeights$52 = false;
            String $i$a$-check-WeightLoaderKt$loadWeights$52 = "Model is not compiled yet. Compile the model before loading weights.";
            throw new IllegalStateException($i$a$-check-WeightLoaderKt$loadWeights$52.toString());
        }
        if (!(!$this$loadWeights.isModelInitialized())) {
            boolean $i$a$-check-WeightLoaderKt$loadWeights$62 = false;
            String $i$a$-check-WeightLoaderKt$loadWeights$62 = "Model is already initialized.";
            throw new IllegalStateException($i$a$-check-WeightLoaderKt$loadWeights$62.toString());
        }
        $this$loadWeights.getLogger().info((Function0)loadWeights.5.INSTANCE);
        Set layerSet = CollectionsKt.toSet((Iterable)layersToLoad);
        Iterable $this$forEach$iv = $this$loadWeights.getLayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Layer layer = (Layer)element$iv;
            boolean bl = false;
            if (layerSet.contains(layer)) {
                loadWeightsBlock.invoke((Object)layer);
                continue;
            }
            WeightLoaderKt.initLayerWeights(layer, $this$loadWeights);
        }
        $this$loadWeights.getLogger().info((Function0)loadWeights.7.INSTANCE);
        $this$loadWeights.setModelInitialized$tensorflow(true);
    }

    private static final void fillLayerWeights(Layer layer, Group group, GraphTrainableModel model) {
        if (!(layer instanceof ParametrizedLayer)) {
            return;
        }
        Map<String, KVariable> variables2 = WeightMappings.INSTANCE.getLayerVariables$tensorflow((ParametrizedLayer)((Object)layer));
        if (variables2 == null) {
            model.getLogger().warn((Function0)new Function0<Object>(layer){
                final /* synthetic */ Layer $layer;
                {
                    this.$layer = $layer;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Loading weights for the layer " + this.$layer.getName() + " is skipped as " + Reflection.getOrCreateKotlinClass(this.$layer.getClass()).getQualifiedName() + " layers are not supported.";
                }
            });
            return;
        }
        WeightLoaderKt.fillLayerVariablesFromKeras(layer.getName(), variables2, model, group);
        model.getLogger().debug((Function0)new Function0<Object>(layer){
            final /* synthetic */ Layer $layer;
            {
                this.$layer = $layer;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return ((ParametrizedLayer)((Object)this.$layer)).getParamCount() + " parameters loaded for the layer " + this.$layer.getName() + '.';
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final void fillLayerVariablesFromKeras(String layerName, Map<String, KVariable> variables2, GraphTrainableModel model, Group group) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Object v = group.getChildren().get(layerName);
        Group layerWeightsNode = v instanceof Group ? (Group)v : null;
        if (!(layerWeightsNode != null)) {
            void $this$mapTo$iv$iv2;
            Collection collection;
            void $this$mapTo$iv$iv3;
            boolean $i$a$-check-WeightLoaderKt$fillLayerVariablesFromKeras$22 = false;
            Iterable $this$map$iv = group.getChildren().values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void p0;
                Node node = (Node)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getName());
            }
            List availableLayerNames = (List)destination$iv$iv;
            Iterable $this$map$iv2 = model.getLayers();
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void p0;
                Layer bl = (Layer)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(p0.getName());
            }
            List modelLayerNames = (List)destination$iv$iv2;
            String $i$a$-check-WeightLoaderKt$fillLayerVariablesFromKeras$22 = "Weights for the loaded layer " + layerName + " are not found in .h5 file! \nh5 weight file contains weights for the following list of layers: " + availableLayerNames + "\nDouble-check your loaded configuration which contains layers with the following names: " + modelLayerNames + '.';
            throw new IllegalStateException($i$a$-check-WeightLoaderKt$fillLayerVariablesFromKeras$22.toString());
        }
        String nameOfWeightSubGroup = (String)CollectionsKt.first((Iterable)layerWeightsNode.getChildren().keySet());
        Object v2 = layerWeightsNode.getChildren().get(nameOfWeightSubGroup);
        Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type io.jhdf.api.Group");
        Map dataNodes = ((Group)v2).getChildren();
        Iterable $this$map$iv = dataNodes.values();
        boolean $i$f$map = false;
        Iterable $i$f$map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Node item$iv$iv2 = (Node)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type io.jhdf.dataset.DatasetBase");
            collection.add((DatasetBase)it);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KVariable variable;
            DatasetBase it = (DatasetBase)element$iv;
            boolean bl = false;
            if (variables2.get(it.getName()) == null) {
                throw new IllegalArgumentException("Parsing of h5 file for variable with name " + it.getName() + " in layer " + layerName + " is not supported!");
            }
            int[] dims = it.getDimensions();
            if (!Arrays.equals(ShapeFunctionsKt.toIntArray(variable.getShape()), dims)) {
                boolean bl3 = false;
                StringBuilder stringBuilder = new StringBuilder().append(variable.getName()).append(" variable shape in loaded data is ");
                String string = Arrays.toString(dims);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
                StringBuilder stringBuilder2 = stringBuilder.append(string).append(". Should be ");
                String string2 = Arrays.toString(ShapeFunctionsKt.toIntArray(variable.getShape()));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
                String string3 = stringBuilder2.append(string2).toString();
                throw new IllegalArgumentException(string3.toString());
            }
            Object object = it.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.data");
            model.fill$tensorflow(variable, object);
        }
    }

    private static final void fillLayerWeights(Layer layer, HdfFile hdfFile, LayerPaths layerPaths, GraphTrainableModel model) {
        if (!(layer instanceof ParametrizedLayer)) {
            return;
        }
        Map<KVariable, String> variables2 = WeightMappings.INSTANCE.getLayerVariablePathTemplates$tensorflow((ParametrizedLayer)((Object)layer), layerPaths);
        if (variables2 == null) {
            model.getLogger().warn((Function0)new Function0<Object>(layer){
                final /* synthetic */ Layer $layer;
                {
                    this.$layer = $layer;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Loading weights for the layer " + this.$layer.getName() + " is skipped as " + Reflection.getOrCreateKotlinClass(this.$layer.getClass()).getQualifiedName() + " layers are not supported.";
                }
            });
            return;
        }
        Map<KVariable, String> $this$forEach$iv = variables2;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<KVariable, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String variableDataPathTemplate;
            Map.Entry<KVariable, String> element$iv;
            Map.Entry<KVariable, String> entry = element$iv = iterator.next();
            boolean bl = false;
            KVariable variable = entry.getKey();
            String string = variableDataPathTemplate = entry.getValue();
            Object[] objectArray = new Object[]{layer.getName(), layer.getName()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            Object data = hdfFile.getDatasetByPath(string2).getData();
            Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
            model.fill$tensorflow(variable, data);
        }
        model.getLogger().debug((Function0)new Function0<Object>(layer){
            final /* synthetic */ Layer $layer;
            {
                this.$layer = $layer;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return ((ParametrizedLayer)((Object)this.$layer)).getParamCount() + " parameters loaded for the layer " + this.$layer.getName() + '.';
            }
        });
    }

    private static final void initLayerWeights(Layer layer, GraphTrainableModel model) {
        Collection<KVariable> variables2;
        if (!(layer instanceof ParametrizedLayer)) {
            return;
        }
        Map<String, KVariable> map = WeightMappings.INSTANCE.getLayerVariables$tensorflow((ParametrizedLayer)((Object)layer));
        Collection<KVariable> collection = variables2 = map != null ? map.values() : null;
        if (variables2 == null) {
            model.getLogger().warn((Function0)new Function0<Object>(layer){
                final /* synthetic */ Layer $layer;
                {
                    this.$layer = $layer;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Initializing weights for the layer " + this.$layer.getName() + " is skipped as " + Reflection.getOrCreateKotlinClass(this.$layer.getClass()).getQualifiedName() + " layers are not supported.";
                }
            });
            return;
        }
        Iterable $this$forEach$iv = variables2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KVariable p0 = (KVariable)element$iv;
            boolean bl = false;
            model.init$tensorflow(p0);
        }
        model.getLogger().debug((Function0)new Function0<Object>(layer){
            final /* synthetic */ Layer $layer;
            {
                this.$layer = $layer;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return ((ParametrizedLayer)((Object)this.$layer)).getParamCount() + " parameters initialized for the layer " + this.$layer.getName() + '.';
            }
        });
    }

    public static final /* synthetic */ void access$fillLayerWeights(Layer layer, Group group, GraphTrainableModel model) {
        WeightLoaderKt.fillLayerWeights(layer, group, model);
    }

    public static final /* synthetic */ void access$fillLayerWeights(Layer layer, HdfFile hdfFile, LayerPaths layerPaths, GraphTrainableModel model) {
        WeightLoaderKt.fillLayerWeights(layer, hdfFile, layerPaths, model);
    }
}

