/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.inference.keras;

import com.beust.klaxon.Converter;
import com.beust.klaxon.JsonArray;
import com.beust.klaxon.JsonValue;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.inference.keras.config.KerasPadding;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/keras/PaddingConverter;", "Lcom/beust/klaxon/Converter;", "()V", "canConvert", "", "cls", "Ljava/lang/Class;", "fromJson", "Lorg/jetbrains/kotlinx/dl/api/inference/keras/config/KerasPadding;", "jv", "Lcom/beust/klaxon/JsonValue;", "toJson", "", "value", "", "zeroPaddingToJsonString", "zeroPadding2D", "Lorg/jetbrains/kotlinx/dl/api/inference/keras/config/KerasPadding$ZeroPadding2D;", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nModelParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelParser.kt\norg/jetbrains/kotlinx/dl/api/inference/keras/PaddingConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class PaddingConverter
implements Converter {
    public boolean canConvert(@NotNull Class<?> cls) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        return Intrinsics.areEqual(cls, KerasPadding.class);
    }

    @NotNull
    public String toJson(@NotNull Object value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof KerasPadding.Full) {
            string = "\"full\"";
        } else if (object instanceof KerasPadding.Same) {
            string = "\"same\"";
        } else if (object instanceof KerasPadding.Valid) {
            string = "\"valid\"";
        } else if (object instanceof KerasPadding.ZeroPadding2D) {
            string = this.zeroPaddingToJsonString((KerasPadding.ZeroPadding2D)value);
        } else {
            System.out.println((Object)("[KerasPaddingConverter]: Converting unknown padding " + value + " to JSON"));
            return String.valueOf(value);
        }
        return string;
    }

    private final String zeroPaddingToJsonString(KerasPadding.ZeroPadding2D zeroPadding2D) {
        String string;
        KerasPadding.ZeroPadding2D $this$zeroPaddingToJsonString_u24lambda_u240 = zeroPadding2D;
        boolean bl = false;
        switch ($this$zeroPaddingToJsonString_u24lambda_u240.getPadding().length) {
            case 1: {
                string = String.valueOf($this$zeroPaddingToJsonString_u24lambda_u240.getPadding()[0]);
                break;
            }
            case 2: {
                string = "" + '[' + $this$zeroPaddingToJsonString_u24lambda_u240.getPadding()[0] + ", " + $this$zeroPaddingToJsonString_u24lambda_u240.getPadding()[1] + ']';
                break;
            }
            case 4: {
                string = "[[" + $this$zeroPaddingToJsonString_u24lambda_u240.getPadding()[0] + ", " + $this$zeroPaddingToJsonString_u24lambda_u240.getPadding()[1] + "], [" + $this$zeroPaddingToJsonString_u24lambda_u240.getPadding()[2] + ", " + $this$zeroPaddingToJsonString_u24lambda_u240.getPadding()[3] + "]]";
                break;
            }
            default: {
                throw new IllegalArgumentException("[KerasPaddingConverter]: expected padding array with size 1, 2 or 4, got array " + $this$zeroPaddingToJsonString_u24lambda_u240.getPadding());
            }
        }
        return string;
    }

    @NotNull
    public KerasPadding fromJson(@NotNull JsonValue jv) {
        block20: {
            KerasPadding kerasPadding;
            Intrinsics.checkNotNullParameter((Object)jv, (String)"jv");
            String stringValue = jv.getString();
            if (stringValue == null) break block20;
            switch (stringValue) {
                case "same": {
                    kerasPadding = KerasPadding.Same.INSTANCE;
                    break;
                }
                case "valid": {
                    kerasPadding = KerasPadding.Valid.INSTANCE;
                    break;
                }
                case "full": {
                    kerasPadding = KerasPadding.Full.INSTANCE;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("[KerasPaddingConverter]: Invalid padding " + jv + ": the " + stringValue + " padding is not supported!");
                }
            }
            return kerasPadding;
        }
        Integer intValue = jv.getInt();
        if (intValue != null) {
            return new KerasPadding.ZeroPadding2D(intValue);
        }
        JsonArray array = jv.getArray();
        if (array != null) {
            boolean bl;
            boolean bl2 = bl = array.size() == 2;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-PaddingConverter$fromJson$622 = false;
                String $i$a$-assert-PaddingConverter$fromJson$622 = "[KerasPaddingConverter]: invalid padding shape in " + jv + ", received " + array.size() + ", expected 2";
                throw new AssertionError((Object)$i$a$-assert-PaddingConverter$fromJson$622);
            }
            Object object = array.get(0);
            if (object instanceof Integer) {
                boolean $i$a$-assert-PaddingConverter$fromJson$622 = array.get(1) instanceof Integer;
                if (_Assertions.ENABLED && !$i$a$-assert-PaddingConverter$fromJson$622) {
                    boolean $i$a$-assert-PaddingConverter$fromJson$52 = false;
                    String $i$a$-assert-PaddingConverter$fromJson$52 = "[KerasPaddingConverter]: invalid padding " + jv + ", expected Integer at " + array.get(1);
                    throw new AssertionError((Object)$i$a$-assert-PaddingConverter$fromJson$52);
                }
                int[] $i$a$-assert-PaddingConverter$fromJson$622 = new int[2];
                Object object2 = array.get(0);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
                $i$a$-assert-PaddingConverter$fromJson$622[0] = (Integer)object2;
                Object object3 = array.get(1);
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Int");
                $i$a$-assert-PaddingConverter$fromJson$622[1] = (Integer)object3;
                return new KerasPadding.ZeroPadding2D($i$a$-assert-PaddingConverter$fromJson$622);
            }
            if (object instanceof JsonArray) {
                boolean $i$a$-assert-PaddingConverter$fromJson$622 = array.get(1) instanceof JsonArray;
                if (_Assertions.ENABLED && !$i$a$-assert-PaddingConverter$fromJson$622) {
                    boolean $i$a$-assert-PaddingConverter$fromJson$42 = false;
                    String $i$a$-assert-PaddingConverter$fromJson$42 = "[KerasPaddingConverter]: invalid padding " + jv + ", expected JsonArray at " + array.get(1);
                    throw new AssertionError((Object)$i$a$-assert-PaddingConverter$fromJson$42);
                }
                Object object4 = array.get(0);
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type com.beust.klaxon.JsonArray<kotlin.Int>");
                JsonArray firstArray = (JsonArray)object4;
                Object object5 = array.get(1);
                Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type com.beust.klaxon.JsonArray<kotlin.Int>");
                JsonArray secondArray = (JsonArray)object5;
                int[][] nArrayArray = new int[][]{CollectionsKt.toIntArray((Collection)((Collection)firstArray)), CollectionsKt.toIntArray((Collection)((Collection)secondArray))};
                return new KerasPadding.ZeroPadding2D(nArrayArray);
            }
        }
        throw new UnsupportedOperationException("[KerasPaddingConverter]: Unsupported padding " + jv);
    }
}

