/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.inference.keras;

import io.jhdf.HdfFile;
import io.jhdf.api.Attribute;
import io.jhdf.api.Dataset;
import io.jhdf.api.Group;
import io.jhdf.api.Node;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"recursivePrintGroupInHDF5File", "", "hdfFile", "Lio/jhdf/HdfFile;", "group", "Lio/jhdf/api/Group;", "tensorflow"})
public final class HDF5UtilKt {
    public static final void recursivePrintGroupInHDF5File(@NotNull HdfFile hdfFile, @NotNull Group group) {
        Intrinsics.checkNotNullParameter((Object)hdfFile, (String)"hdfFile");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        for (Node node : group) {
            System.out.println((Object)("[HDFUtil] Node: " + node.getName()));
            Map map = node.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"node.attributes");
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Attribute value = (Attribute)entry.getValue();
                System.out.println((Object)("[HDFUtil] attribute name: " + key));
                if (value.isScalar()) {
                    System.out.println((Object)("[HDFUtil] attribute data: " + value.getData()));
                    continue;
                }
                if (!(value.getData() instanceof Object[])) continue;
                int n = (int)value.getSize();
                for (int i = 0; i < n; ++i) {
                    StringBuilder stringBuilder = new StringBuilder().append("[HDFUtil] attribute #").append(i).append(" data: ");
                    Object object = value.getData();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<*>");
                    System.out.println((Object)stringBuilder.append(((Object[])object)[i]).toString());
                }
            }
            if (node instanceof Group) {
                HDF5UtilKt.recursivePrintGroupInHDF5File(hdfFile, (Group)node);
                continue;
            }
            System.out.println((Object)("[HDFUtil] Path to node: " + node.getPath()));
            Dataset dataset = hdfFile.getDatasetByPath(node.getPath());
            Object object = new int[][]{dataset.getDimensions()};
            int[][] dims = object;
            object = (Object[])dims;
            System.out.println((Object)("[HDFUtil] Shape: " + ArraysKt.contentDeepToString((Object[])object)));
        }
    }
}

