/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.inference;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.FloatBuffer;
import java.nio.file.NotDirectoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.KGraph;
import org.jetbrains.kotlinx.dl.api.core.shape.ShapeFunctionsKt;
import org.jetbrains.kotlinx.dl.api.core.shape.TensorShape;
import org.jetbrains.kotlinx.dl.api.core.util.ConvertersKt;
import org.jetbrains.kotlinx.dl.api.core.util.NameConventionsKt;
import org.jetbrains.kotlinx.dl.api.core.util.ScannerUtilKt;
import org.jetbrains.kotlinx.dl.api.extension.TensorExtensionFunctionsKt;
import org.jetbrains.kotlinx.dl.api.inference.InferenceModel;
import org.jetbrains.kotlinx.dl.api.inference.TensorFlowInferenceModel;
import org.jetbrains.kotlinx.dl.api.inference.savedmodel.Input;
import org.jetbrains.kotlinx.dl.api.inference.savedmodel.Output;
import org.jetbrains.kotlinx.dl.impl.util.AutoClosableExtensionsKt;
import org.tensorflow.ExecutionEnvironment;
import org.tensorflow.GraphOperation;
import org.tensorflow.Session;
import org.tensorflow.Shape;
import org.tensorflow.Tensor;
import org.tensorflow.op.Ops;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u000e\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\b\u0016\u0018\u0000 _2\u00020\u0001:\u0001_B\u0005\u00a2\u0006\u0002\u0010\u0002J \u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u001d2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0004J\b\u0010=\u001a\u000207H\u0016J\"\u0010>\u001a\u00020\u00002\b\u0010?\u001a\u0004\u0018\u00010\u001d2\u0006\u0010@\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020\u000eH\u0016J\u0006\u0010B\u001a\u00020\u001dJ\u0010\u0010C\u001a\u0002072\u0006\u0010D\u001a\u00020\u001dH\u0002J\u000e\u0010\u0003\u001a\u0002072\u0006\u0010E\u001a\u00020\u0004J\u0010\u0010F\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\u001dH\u0004J\u0018\u0010G\u001a\u0002072\u0006\u0010D\u001a\u00020\u001d2\u0006\u0010H\u001a\u00020\u000eH\u0002J0\u0010I\u001a\u0002072\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u001d0K2\u0018\u0010L\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020<0MH\u0014J$\u0010N\u001a\u0002072\u0006\u0010D\u001a\u00020\u001d2\u0012\u0010O\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u000e0PH\u0004J\u0018\u0010N\u001a\u0002072\u0006\u0010D\u001a\u00020\u001d2\u0006\u0010H\u001a\u00020\u000eH\u0004J\u000e\u0010\"\u001a\u0002072\u0006\u0010Q\u001a\u00020#J \u0010R\u001a\u0002072\u0006\u0010S\u001a\u00020\u001d2\u0006\u0010T\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020XH\u0016J\u0018\u0010Y\u001a\u00020X2\u0006\u0010W\u001a\u00020X2\u0006\u0010Z\u001a\u00020\u001dH\u0016J\u0014\u0010[\u001a\u0002072\n\u0010\\\u001a\u00020\n\"\u00020]H\u0016J\b\u0010^\u001a\u00020\u001dH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000e8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u0014@DX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001e\u0010.\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\fR\u001a\u00100\u001a\u000201X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105\u00a8\u0006`"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/TensorFlowInferenceModel;", "Lorg/jetbrains/kotlinx/dl/api/inference/InferenceModel;", "()V", "input", "Lorg/jetbrains/kotlinx/dl/api/inference/savedmodel/Input;", "getInput", "()Lorg/jetbrains/kotlinx/dl/api/inference/savedmodel/Input;", "setInput", "(Lorg/jetbrains/kotlinx/dl/api/inference/savedmodel/Input;)V", "inputDimensions", "", "getInputDimensions", "()[J", "<set-?>", "", "isModelInitialized", "()Z", "setModelInitialized$tensorflow", "(Z)V", "isShapeInitialized", "Lorg/jetbrains/kotlinx/dl/api/core/KGraph;", "kGraph", "getKGraph", "()Lorg/jetbrains/kotlinx/dl/api/core/KGraph;", "setKGraph", "(Lorg/jetbrains/kotlinx/dl/api/core/KGraph;)V", "logger", "Lmu/KLogger;", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "output", "Lorg/jetbrains/kotlinx/dl/api/inference/savedmodel/Output;", "getOutput", "()Lorg/jetbrains/kotlinx/dl/api/inference/savedmodel/Output;", "setOutput", "(Lorg/jetbrains/kotlinx/dl/api/inference/savedmodel/Output;)V", "session", "Lorg/tensorflow/Session;", "getSession$tensorflow", "()Lorg/tensorflow/Session;", "setSession$tensorflow", "(Lorg/tensorflow/Session;)V", "shape", "getShape", "tf", "Lorg/tensorflow/op/Ops;", "getTf", "()Lorg/tensorflow/op/Ops;", "setTf", "(Lorg/tensorflow/op/Ops;)V", "assignVariable", "", "variableName", "variableShape", "Lorg/tensorflow/Shape;", "data", "", "close", "copy", "copiedModelName", "saveOptimizerState", "copyWeights", "graphToString", "inferenceGraphInitialization", "pathToModelDirectory", "inputOp", "isOptimizerVariable", "loadModelFromSimpleFormat", "loadOptimizerState", "loadVariables", "variableNames", "", "getData", "Lkotlin/Function2;", "loadVariablesFromTxt", "predicate", "Lkotlin/Function1;", "outputOp", "populateVariable", "assignOpName", "initializerName", "predict", "", "inputData", "", "predictSoftly", "predictionTensorName", "reshape", "dims", "", "toString", "Companion", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nTensorFlowInferenceModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TensorFlowInferenceModel.kt\norg/jetbrains/kotlinx/dl/api/inference/TensorFlowInferenceModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,332:1\n1#2:333\n766#3:334\n857#3,2:335\n1855#3,2:337\n766#3:339\n857#3,2:340\n*S KotlinDebug\n*F\n+ 1 TensorFlowInferenceModel.kt\norg/jetbrains/kotlinx/dl/api/inference/TensorFlowInferenceModel\n*L\n170#1:334\n170#1:335,2\n173#1:337,2\n228#1:339\n228#1:340,2\n*E\n"})
public class TensorFlowInferenceModel
implements InferenceModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    protected Ops tf;
    public Session session;
    protected KGraph kGraph;
    @NotNull
    private Input input = Input.PLACEHOLDER;
    @NotNull
    private Output output = Output.ARGMAX;
    private long[] shape;
    private boolean isModelInitialized;
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @Nullable
    private String name;

    @NotNull
    protected final Ops getTf() {
        Ops ops = this.tf;
        if (ops != null) {
            return ops;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"tf");
        return null;
    }

    protected final void setTf(@NotNull Ops ops) {
        Intrinsics.checkNotNullParameter((Object)ops, (String)"<set-?>");
        this.tf = ops;
    }

    @NotNull
    public final Session getSession$tensorflow() {
        Session session = this.session;
        if (session != null) {
            return session;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        return null;
    }

    public final void setSession$tensorflow(@NotNull Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"<set-?>");
        this.session = session;
    }

    @NotNull
    public final KGraph getKGraph() {
        KGraph kGraph = this.kGraph;
        if (kGraph != null) {
            return kGraph;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"kGraph");
        return null;
    }

    protected final void setKGraph(@NotNull KGraph kGraph) {
        Intrinsics.checkNotNullParameter((Object)kGraph, (String)"<set-?>");
        this.kGraph = kGraph;
    }

    @NotNull
    protected final Input getInput() {
        return this.input;
    }

    protected final void setInput(@NotNull Input input) {
        Intrinsics.checkNotNullParameter((Object)((Object)input), (String)"<set-?>");
        this.input = input;
    }

    @NotNull
    protected final Output getOutput() {
        return this.output;
    }

    protected final void setOutput(@NotNull Output output) {
        Intrinsics.checkNotNullParameter((Object)((Object)output), (String)"<set-?>");
        this.output = output;
    }

    @NotNull
    public final long[] getShape() {
        if (this.shape != null) {
            return this.shape;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"shape");
        return null;
    }

    protected final boolean isShapeInitialized() {
        return this.shape != null;
    }

    public final boolean isModelInitialized() {
        return this.isModelInitialized;
    }

    public final void setModelInitialized$tensorflow(boolean bl) {
        this.isModelInitialized = bl;
    }

    @NotNull
    public long[] getInputDimensions() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final void setName(@Nullable String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int predict(@NotNull float[] inputData) {
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        if (!(this.shape != null)) {
            boolean $i$a$-require-TensorFlowInferenceModel$predict$32 = false;
            String $i$a$-require-TensorFlowInferenceModel$predict$32 = "Model input shape is not defined. Call reshape() to set input shape.";
            throw new IllegalArgumentException($i$a$-require-TensorFlowInferenceModel$predict$32.toString());
        }
        if (!this.isModelInitialized) {
            boolean $i$a$-check-TensorFlowInferenceModel$predict$42 = false;
            String $i$a$-check-TensorFlowInferenceModel$predict$42 = "The model is not initialized yet. Initialize the model weights with InferenceModel.load() method.";
            throw new IllegalStateException($i$a$-check-TensorFlowInferenceModel$predict$42.toString());
        }
        FloatBuffer preparedData = ConvertersKt.serializeToBuffer(inputData);
        Tensor tensor = Tensor.create((long[])this.getShape(), (FloatBuffer)preparedData);
        AutoCloseable autoCloseable = (AutoCloseable)tensor;
        Throwable throwable = null;
        try {
            Tensor it = (Tensor)autoCloseable;
            boolean bl = false;
            Session.Runner runner = this.getSession$tensorflow().runner();
            List list = runner.feed("default_data_placeholder", it).fetch(this.output.getTfName()).run();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"runner.feed(DATA_PLACEHO\u2026e)\n                .run()");
            int n = ((Number)AutoClosableExtensionsKt.use((List)list, (Function1)predict.4.1.INSTANCE)).intValue();
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public float[] predictSoftly(@NotNull float[] inputData, @NotNull String predictionTensorName) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        Intrinsics.checkNotNullParameter((Object)predictionTensorName, (String)"predictionTensorName");
        if (!(this.shape != null)) {
            boolean $i$a$-require-TensorFlowInferenceModel$predictSoftly$32 = false;
            String $i$a$-require-TensorFlowInferenceModel$predictSoftly$32 = "Model input shape is not defined. Call reshape() to set input shape.";
            throw new IllegalArgumentException($i$a$-require-TensorFlowInferenceModel$predictSoftly$32.toString());
        }
        if (!this.isModelInitialized) {
            boolean $i$a$-check-TensorFlowInferenceModel$predictSoftly$42 = false;
            String $i$a$-check-TensorFlowInferenceModel$predictSoftly$42 = "The model is not initialized yet. Initialize the model weights with InferenceModel.load() method.";
            throw new IllegalStateException($i$a$-check-TensorFlowInferenceModel$predictSoftly$42.toString());
        }
        CharSequence $i$a$-check-TensorFlowInferenceModel$predictSoftly$42 = predictionTensorName;
        if ($i$a$-check-TensorFlowInferenceModel$predictSoftly$42.length() == 0) {
            boolean bl = false;
            charSequence = "default_output";
        } else {
            charSequence = $i$a$-check-TensorFlowInferenceModel$predictSoftly$42;
        }
        String fetchTensorName = (String)charSequence;
        if (!(this.getKGraph().getTfGraph$tensorflow().operation(fetchTensorName) != null)) {
            boolean $i$a$-require-TensorFlowInferenceModel$predictSoftly$52 = false;
            String $i$a$-require-TensorFlowInferenceModel$predictSoftly$52 = "No such tensor output named [" + fetchTensorName + "] in the TensorFlow graph!";
            throw new IllegalArgumentException($i$a$-require-TensorFlowInferenceModel$predictSoftly$52.toString());
        }
        FloatBuffer preparedData = ConvertersKt.serializeToBuffer(inputData);
        Tensor tensor = Tensor.create((long[])this.getShape(), (FloatBuffer)preparedData);
        AutoCloseable autoCloseable = (AutoCloseable)tensor;
        Throwable throwable = null;
        try {
            Tensor it = (Tensor)autoCloseable;
            boolean bl = false;
            Session.Runner runner1 = this.getSession$tensorflow().runner();
            List list = runner1.feed("default_data_placeholder", it).fetch(fetchTensorName).run();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"runner1.feed(DATA_PLACEH\u2026e)\n                .run()");
            float[] fArray = (float[])AutoClosableExtensionsKt.use((List)list, (Function1)predictSoftly.5.1.INSTANCE);
            return fArray;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void input(@NotNull Input inputOp) {
        Intrinsics.checkNotNullParameter((Object)((Object)inputOp), (String)"inputOp");
        this.input = inputOp;
    }

    public final void output(@NotNull Output outputOp) {
        Intrinsics.checkNotNullParameter((Object)((Object)outputOp), (String)"outputOp");
        this.output = outputOp;
    }

    public void reshape(long ... dims) {
        Intrinsics.checkNotNullParameter((Object)dims, (String)"dims");
        this.shape = new TensorShape(1L, Arrays.copyOf(dims, dims.length)).dims();
    }

    @NotNull
    public final String graphToString() {
        return this.getKGraph().toString();
    }

    public void close() {
        if (this.session != null) {
            this.getSession$tensorflow().close();
        }
        if (this.kGraph != null) {
            this.getKGraph().close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public TensorFlowInferenceModel copy(@Nullable String copiedModelName, boolean saveOptimizerState, boolean copyWeights) {
        TensorFlowInferenceModel model = new TensorFlowInferenceModel();
        model.setKGraph(this.getKGraph().copy());
        Ops ops = Ops.create((ExecutionEnvironment)((ExecutionEnvironment)model.getKGraph().getTfGraph$tensorflow()));
        Intrinsics.checkNotNullExpressionValue((Object)ops, (String)"create(model.kGraph.tfGraph)");
        model.setTf(ops);
        model.setSession$tensorflow(new Session(model.getKGraph().getTfGraph$tensorflow()));
        model.shape = this.getShape();
        model.input = this.input;
        model.output = this.output;
        if (copiedModelName != null) {
            model.name = this.name;
        }
        if (copyWeights) {
            void $this$filterTo$iv$iv;
            Session.Runner modelWeightsExtractorRunner = this.getSession$tensorflow().runner();
            List<String> variableNames = this.getKGraph().variableNames();
            if (!(!((Collection)variableNames).isEmpty())) {
                boolean $i$a$-check-TensorFlowInferenceModel$copy$22 = false;
                String $i$a$-check-TensorFlowInferenceModel$copy$22 = "Found 0 variable names in TensorFlow graph " + this.getKGraph() + ". If copied model has no weights, set flag `copyWeights` to `false`.";
                throw new IllegalStateException($i$a$-check-TensorFlowInferenceModel$copy$22.toString());
            }
            Iterable $this$filter$iv = variableNames;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String variableName = (String)element$iv$iv;
                boolean bl = false;
                if (!(saveOptimizerState || !this.isOptimizerVariable(variableName))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List variableNamesToCopy = (List)destination$iv$iv;
            Iterable $this$forEach$iv = variableNamesToCopy;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String p0 = (String)element$iv;
                boolean bl = false;
                modelWeightsExtractorRunner.fetch(p0);
            }
            Iterable iterable2 = variableNamesToCopy;
            List list = modelWeightsExtractorRunner.run();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"modelWeightsExtractorRunner.run()");
            Map modelWeights = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)iterable2, (Iterable)list));
            model.loadVariables(modelWeights.keySet(), (Function2<? super String, ? super Shape, ? extends Object>)((Function2)new Function2<String, Shape, Object>(modelWeights){
                final /* synthetic */ Map<String, Tensor<?>> $modelWeights;
                {
                    this.$modelWeights = $modelWeights;
                    super(2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public final Object invoke(@NotNull String variableName, @NotNull Shape shape) {
                    Object[] objectArray;
                    Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
                    Intrinsics.checkNotNullParameter((Object)shape, (String)"<anonymous parameter 1>");
                    Tensor<?> tensor = this.$modelWeights.get(variableName);
                    Intrinsics.checkNotNull(tensor);
                    AutoCloseable autoCloseable = (AutoCloseable)tensor;
                    Throwable throwable = null;
                    try {
                        Tensor it = (Tensor)autoCloseable;
                        boolean bl = false;
                        objectArray = TensorExtensionFunctionsKt.convertTensorToMultiDimArray(it);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                    return objectArray;
                }
            }));
        }
        model.isModelInitialized = true;
        return model;
    }

    protected void loadVariables(@NotNull Collection<String> variableNames, @NotNull Function2<? super String, ? super Shape, ? extends Object> getData) {
        Intrinsics.checkNotNullParameter(variableNames, (String)"variableNames");
        Intrinsics.checkNotNullParameter(getData, (String)"getData");
        for (String variableName : variableNames) {
            GraphOperation variableOperation = this.getKGraph().getTfGraph$tensorflow().operation(variableName);
            if (!(variableOperation != null)) {
                boolean $i$a$-check-TensorFlowInferenceModel$loadVariables$22 = false;
                String $i$a$-check-TensorFlowInferenceModel$loadVariables$22 = "Operation " + variableName + " is not found in static graph.";
                throw new IllegalStateException($i$a$-check-TensorFlowInferenceModel$loadVariables$22.toString());
            }
            Shape variableShape = variableOperation.output(0).shape();
            Intrinsics.checkNotNullExpressionValue((Object)variableShape, (String)"variableShape");
            Object data = getData.invoke((Object)variableName, (Object)variableShape);
            this.assignVariable(variableName, variableShape, data);
        }
    }

    protected final boolean isOptimizerVariable(@NotNull String variableName) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        return StringsKt.startsWith$default((String)variableName, (String)"optimizer", (boolean)false, (int)2, null);
    }

    protected final void loadVariablesFromTxt(@NotNull String pathToModelDirectory, boolean loadOptimizerState) {
        Intrinsics.checkNotNullParameter((Object)pathToModelDirectory, (String)"pathToModelDirectory");
        this.loadVariablesFromTxt(pathToModelDirectory, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(loadOptimizerState, this){
            final /* synthetic */ boolean $loadOptimizerState;
            final /* synthetic */ TensorFlowInferenceModel this$0;
            {
                this.$loadOptimizerState = $loadOptimizerState;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String variableName) {
                Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
                return this.$loadOptimizerState || !this.this$0.isOptimizerVariable(variableName);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    protected final void loadVariablesFromTxt(@NotNull String pathToModelDirectory, @NotNull Function1<? super String, Boolean> predicate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pathToModelDirectory, (String)"pathToModelDirectory");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        File variableNamesFile = new File(pathToModelDirectory + "/variableNames.txt");
        if (!variableNamesFile.exists()) {
            throw new FileNotFoundException("File 'variableNames.txt' is not found. This file must be in the model directory. It is generated during Sequential model saving with SavingFormat.TF_GRAPH_CUSTOM_VARIABLES or SavingFormat.JSON_CONFIG_CUSTOM_VARIABLES.");
        }
        Iterable $this$filter$iv = FilesKt.readLines$default((File)variableNamesFile, null, (int)1, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List variableNamesToLoad = (List)destination$iv$iv;
        this.loadVariables(variableNamesToLoad, (Function2<? super String, ? super Shape, ? extends Object>)((Function2)new Function2<String, Shape, Object>(pathToModelDirectory){
            final /* synthetic */ String $pathToModelDirectory;
            {
                this.$pathToModelDirectory = $pathToModelDirectory;
                super(2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final Object invoke(@NotNull String variableName, @NotNull Shape variableShape) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
                Intrinsics.checkNotNullParameter((Object)variableShape, (String)"variableShape");
                File file = new File(this.$pathToModelDirectory + '/' + variableName + ".txt");
                if (!file.exists()) {
                    throw new FileNotFoundException("File '" + variableName + ".txt' is not found. This file must be in the model directory.It is generated when saving the model with SavingFormat.TF_GRAPH_CUSTOM_VARIABLES or SavingFormat.JSON_CONFIG_CUSTOM_VARIABLES.");
                }
                Closeable closeable = new Scanner(new FileInputStream(file));
                Throwable throwable = null;
                try {
                    Scanner scanner = (Scanner)closeable;
                    boolean bl = false;
                    scanner.useLocale(Locale.US);
                    object = ScannerUtilKt.createFloatArray(scanner, variableShape);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return object;
            }
        }));
    }

    protected final void assignVariable(@NotNull String variableName, @NotNull Shape variableShape, @NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Intrinsics.checkNotNullParameter((Object)variableShape, (String)"variableShape");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String initializerName = NameConventionsKt.defaultInitializerOpName(variableName);
        String assignOpName = NameConventionsKt.defaultAssignOpName(variableName);
        GraphOperation initOp = this.getKGraph().getTfGraph$tensorflow().operation(initializerName);
        if (!(initOp != null)) {
            boolean bl = false;
            String string = "Operation " + initializerName + " is not found in static graph.\nNOTE: Loading of Zeros, Ones, Constant initializers is not supported.";
            throw new IllegalStateException(string.toString());
        }
        GraphOperation assignOp = this.getKGraph().getTfGraph$tensorflow().operation(assignOpName);
        if (!(assignOp != null)) {
            boolean bl = false;
            String string = "Operation " + assignOp + " is not found in static graph.";
            throw new IllegalStateException(string.toString());
        }
        this.populateVariable(assignOpName, initializerName, data);
        this.logger.debug((Function0)new Function0<Object>(variableName){
            final /* synthetic */ String $variableName;
            {
                this.$variableName = $variableName;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Loading the variable " + this.$variableName + " data";
            }
        });
        this.logger.debug((Function0)new Function0<Object>(variableShape){
            final /* synthetic */ Shape $variableShape;
            {
                this.$variableShape = $variableShape;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Variable dimensions are: " + ShapeFunctionsKt.contentToString(this.$variableShape);
            }
        });
        this.logger.debug((Function0)new Function0<Object>(variableShape){
            final /* synthetic */ Shape $variableShape;
            {
                this.$variableShape = $variableShape;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Number of elements: " + ShapeFunctionsKt.numElements(this.$variableShape);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void populateVariable(String assignOpName, String initializerName, Object data) {
        Object tensorData = data;
        if (data instanceof Object[] && (Object[])data instanceof Float[]) {
            tensorData = ArraysKt.toFloatArray((Float[])((Float[])data));
        }
        AutoCloseable autoCloseable = (AutoCloseable)Tensor.create((Object)tensorData);
        Throwable throwable = null;
        try {
            Tensor tensor = (Tensor)autoCloseable;
            boolean bl = false;
            List list = this.getSession$tensorflow().runner().feed(initializerName, tensor).addTarget(assignOpName).run();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void loadModelFromSimpleFormat(String pathToModelDirectory, boolean loadOptimizerState) {
        this.inferenceGraphInitialization(pathToModelDirectory);
        this.loadVariablesFromTxt(pathToModelDirectory, loadOptimizerState);
    }

    private final void inferenceGraphInitialization(String pathToModelDirectory) {
        File file = new File(pathToModelDirectory + "/graph.pb");
        if (!file.exists()) {
            throw new FileNotFoundException("File 'graph.pb' is not found. This file must be in the model directory. It is generated during Sequential model saving with SavingFormat.TF_GRAPH_CUSTOM_VARIABLES or SavingFormat.TF_GRAPH.");
        }
        this.setKGraph(new KGraph(FilesKt.readBytes((File)file)));
        Ops ops = Ops.create((ExecutionEnvironment)((ExecutionEnvironment)this.getKGraph().getTfGraph$tensorflow()));
        Intrinsics.checkNotNullExpressionValue((Object)ops, (String)"create(kGraph.tfGraph)");
        this.setTf(ops);
        this.setSession$tensorflow(new Session(this.getKGraph().getTfGraph$tensorflow()));
    }

    @NotNull
    public String toString() {
        return "InferenceModel(name=" + this.name + ')';
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlinx/dl/api/inference/TensorFlowInferenceModel$Companion;", "", "()V", "load", "Lorg/jetbrains/kotlinx/dl/api/inference/TensorFlowInferenceModel;", "modelDirectory", "Ljava/io/File;", "loadOptimizerState", "", "tensorflow"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TensorFlowInferenceModel load(@NotNull File modelDirectory, boolean loadOptimizerState) {
            Intrinsics.checkNotNullParameter((Object)modelDirectory, (String)"modelDirectory");
            TensorFlowInferenceModel model = new TensorFlowInferenceModel();
            String pathToModelDirectory = modelDirectory.getAbsolutePath();
            if (!modelDirectory.exists()) {
                throw new NotDirectoryException(pathToModelDirectory);
            }
            model.logger.debug((Function0)load.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)pathToModelDirectory, (String)"pathToModelDirectory");
            model.loadModelFromSimpleFormat(pathToModelDirectory, loadOptimizerState);
            model.setModelInitialized$tensorflow(true);
            model.logger.debug((Function0)load.2.INSTANCE);
            return model;
        }

        public static /* synthetic */ TensorFlowInferenceModel load$default(Companion companion, File file, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.load(file, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

