/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.util.StackKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u001a[\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u0002H\u00022\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u0002H\u00020\u0005j\b\u0012\u0004\u0012\u0002H\u0002`\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\f\u001a;\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000e\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u000f\u001a\u0002H\u00022\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u000b0\nH\u0000\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"recursiveTopologicalSort", "", "T", "currentNode", "stack", "", "Lorg/jetbrains/kotlinx/dl/api/core/util/Stack;", "visited", "", "nextNodes", "Lkotlin/Function1;", "", "(Ljava/lang/Object;Ljava/util/List;Ljava/util/Set;Lkotlin/jvm/functions/Function1;)V", "sortTopologically", "", "start", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "tensorflow"})
public final class GraphUtilKt {
    @NotNull
    public static final <T> List<T> sortTopologically(T start, @NotNull Function1<? super T, ? extends Collection<? extends T>> nextNodes) {
        Intrinsics.checkNotNullParameter(nextNodes, (String)"nextNodes");
        Set visited = new LinkedHashSet();
        List grayStack = new ArrayList();
        GraphUtilKt.recursiveTopologicalSort(start, grayStack, visited, nextNodes);
        List sortedList = new ArrayList();
        while (!((Collection)grayStack).isEmpty()) {
            Object t = StackKt.pop(grayStack);
            Intrinsics.checkNotNull(t);
            sortedList.add(t);
        }
        return sortedList;
    }

    private static final <T> void recursiveTopologicalSort(T currentNode, List<T> stack, Set<T> visited, Function1<? super T, ? extends Collection<? extends T>> nextNodes) {
        visited.add(currentNode);
        Collection nextNodesList = (Collection)nextNodes.invoke(currentNode);
        for (Object nextNode : CollectionsKt.reversed((Iterable)nextNodesList)) {
            if (visited.contains(nextNode)) continue;
            GraphUtilKt.recursiveTopologicalSort(nextNode, stack, visited, nextNodes);
        }
        StackKt.push(stack, currentNode);
    }
}

