/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.util;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0019\u0010\u0006\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\b\u001a)\u0010\u0006\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\f\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\r"}, d2={"serializeLabelsToBuffer", "Ljava/nio/FloatBuffer;", "src", "", "amountOfClasses", "", "serializeToBuffer", "", "([[F)Ljava/nio/FloatBuffer;", "start", "", "length", "([[FII)Ljava/nio/FloatBuffer;", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nconverters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 converters.kt\norg/jetbrains/kotlinx/dl/api/core/util/ConvertersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class ConvertersKt {
    @NotNull
    public static final FloatBuffer serializeToBuffer(@NotNull float[][] src, int start, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        FloatBuffer buffer = FloatBuffer.allocate(length * src[0].length);
        int n = start + length;
        for (int i = start; i < n; ++i) {
            buffer.put(src[i]);
        }
        Intrinsics.checkNotNull((Object)buffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        Buffer buffer2 = ((Buffer)buffer).rewind();
        Intrinsics.checkNotNull((Object)buffer2, (String)"null cannot be cast to non-null type java.nio.FloatBuffer");
        return (FloatBuffer)buffer2;
    }

    @NotNull
    public static final FloatBuffer serializeToBuffer(@NotNull float[][] src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        FloatBuffer buffer = FloatBuffer.allocate(((Object[])src).length * src[0].length);
        int n = ((Object[])src).length;
        for (int i = 0; i < n; ++i) {
            float[] element = src[i];
            buffer.put(element);
        }
        Intrinsics.checkNotNull((Object)buffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        Buffer buffer2 = ((Buffer)buffer).rewind();
        Intrinsics.checkNotNull((Object)buffer2, (String)"null cannot be cast to non-null type java.nio.FloatBuffer");
        return (FloatBuffer)buffer2;
    }

    @NotNull
    public static final FloatBuffer serializeToBuffer(@NotNull float[] src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        FloatBuffer buffer = FloatBuffer.allocate(src.length);
        buffer.put(src);
        Intrinsics.checkNotNull((Object)buffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        Buffer buffer2 = ((Buffer)buffer).rewind();
        Intrinsics.checkNotNull((Object)buffer2, (String)"null cannot be cast to non-null type java.nio.FloatBuffer");
        return (FloatBuffer)buffer2;
    }

    @NotNull
    public static final FloatBuffer serializeLabelsToBuffer(@NotNull float[] src, long amountOfClasses) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        int n = src.length;
        float[][] fArrayArray = new float[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            int n3 = 0;
            int n4 = (int)amountOfClasses;
            float[] fArray = new float[n4];
            int n5 = n2;
            float[][] fArrayArray2 = fArrayArray;
            while (n3 < n4) {
                int n6 = n3++;
                fArray[n6] = 0.0f;
            }
            fArrayArray2[n5] = fArray;
        }
        float[][] oneHotEncodedLabels = fArrayArray;
        n = src.length;
        for (int i = 0; i < n; ++i) {
            float label = src[i];
            if (amountOfClasses == 1L) {
                oneHotEncodedLabels[i][0] = label;
            } else {
                if (!(0.0f <= label && label < (float)amountOfClasses)) {
                    boolean bl = false;
                    String string = "Label with index " + i + " has value " + label + " and is out of range [0.0, " + amountOfClasses + ") for classification task.";
                    throw new IllegalArgumentException(string.toString());
                }
                oneHotEncodedLabels[i][(int)label] = 1.0f;
            }
            Unit unit = Unit.INSTANCE;
        }
        FloatBuffer buffer = FloatBuffer.allocate(((Object[])oneHotEncodedLabels).length * oneHotEncodedLabels[0].length);
        int n7 = ((Object[])oneHotEncodedLabels).length;
        for (n = 0; n < n7; ++n) {
            float[] element = oneHotEncodedLabels[n];
            buffer.put(element);
        }
        Intrinsics.checkNotNull((Object)buffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        Buffer buffer2 = ((Buffer)buffer).rewind();
        Intrinsics.checkNotNull((Object)buffer2, (String)"null cannot be cast to non-null type java.nio.FloatBuffer");
        return (FloatBuffer)buffer2;
    }
}

