/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.shape;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.shape.TensorShape;
import org.jetbrains.kotlinx.dl.api.core.shape.TensorShapeKt;
import org.tensorflow.Operand;
import org.tensorflow.Shape;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Constant;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00020\u000b\"\u00020\u0007H\u0000\u001a\u0019\u0010\f\u001a\u00020\u00012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002\u00a2\u0006\u0002\u0010\u0004\u001a\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00020\u0010\"\u00020\u000eH\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0000\u001a\u00020\u0010H\u0000\u001a\u0014\u0010\u0012\u001a\u00020\u00012\n\u0010\u000f\u001a\u00020\u0010\"\u00020\u000eH\u0000\u001a\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0014\u001a\u00020\u00102\n\u0010\u000f\u001a\u00020\u0010\"\u00020\u000eH\u0000\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0001H\u0000\u001a\f\u0010\u0017\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u0001\u001a\f\u0010\u0018\u001a\u00020\u000e*\u00020\u0001H\u0000\u001a\n\u0010\u0014\u001a\u00020\u0010*\u00020\u0001\u001a\f\u0010\u0019\u001a\u00020\u000b*\u00020\u0001H\u0000\u001a\f\u0010\u001a\u001a\u00020\u0010*\u00020\u0001H\u0000\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u001c\u001a\n\u0010\u001d\u001a\u00020\u001c*\u00020\u0001\"\u001c\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001e"}, d2={"shape", "Lorg/tensorflow/Shape;", "", "getShape", "([Ljava/lang/Object;)Lorg/tensorflow/Shape;", "constArray", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "data", "", "getShapeOfArray", "head", "", "dims", "", "numElementsInShape", "shapeFromDims", "shapeOperand", "tail", "contentToString", "", "copy", "numElements", "toIntArray", "toLongArray", "toShape", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "toTensorShape", "tensorflow"})
public final class ShapeFunctionsKt {
    @NotNull
    public static final Operand<Integer> constArray(@NotNull Ops tf, int ... data) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Constant constant = tf.constant(data);
        Intrinsics.checkNotNullExpressionValue((Object)constant, (String)"tf.constant(data)");
        return (Operand)constant;
    }

    @NotNull
    public static final Operand<Integer> shapeOperand(@NotNull Ops tf, @NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Constant constant = tf.constant(ShapeFunctionsKt.toIntArray(shape));
        Intrinsics.checkNotNullExpressionValue((Object)constant, (String)"tf.constant(shape.toIntArray())");
        return (Operand)constant;
    }

    @NotNull
    public static final int[] toIntArray(@NotNull Shape $this$toIntArray) {
        Intrinsics.checkNotNullParameter((Object)$this$toIntArray, (String)"<this>");
        int n = 0;
        int n2 = $this$toIntArray.numDimensions();
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = (int)$this$toIntArray.size(n3);
        }
        return nArray;
    }

    @NotNull
    public static final long[] toLongArray(@NotNull Shape $this$toLongArray) {
        Intrinsics.checkNotNullParameter((Object)$this$toLongArray, (String)"<this>");
        int n = 0;
        int n2 = $this$toLongArray.numDimensions();
        long[] lArray = new long[n2];
        while (n < n2) {
            int n3 = n++;
            lArray[n3] = $this$toLongArray.size(n3);
        }
        return lArray;
    }

    @NotNull
    public static final String contentToString(@NotNull Shape $this$contentToString) {
        Intrinsics.checkNotNullParameter((Object)$this$contentToString, (String)"<this>");
        String string = Arrays.toString(ShapeFunctionsKt.toLongArray($this$contentToString));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
        return string;
    }

    public static final long head(@NotNull Shape $this$head) {
        Intrinsics.checkNotNullParameter((Object)$this$head, (String)"<this>");
        return $this$head.size(0);
    }

    @NotNull
    public static final long[] tail(@NotNull Shape $this$tail) {
        Intrinsics.checkNotNullParameter((Object)$this$tail, (String)"<this>");
        int n = 0;
        int n2 = $this$tail.numDimensions() - 1;
        long[] lArray = new long[n2];
        while (n < n2) {
            int n3 = n++;
            lArray[n3] = $this$tail.size(n3 + 1);
        }
        return lArray;
    }

    public static final long numElements(@NotNull Shape $this$numElements) {
        Intrinsics.checkNotNullParameter((Object)$this$numElements, (String)"<this>");
        return ShapeFunctionsKt.numElementsInShape(ShapeFunctionsKt.toLongArray($this$numElements));
    }

    @NotNull
    public static final Shape shapeFromDims(long ... dims) {
        Intrinsics.checkNotNullParameter((Object)dims, (String)"dims");
        long[] lArray = ShapeFunctionsKt.tail(Arrays.copyOf(dims, dims.length));
        Shape shape = Shape.make((long)ShapeFunctionsKt.head(Arrays.copyOf(dims, dims.length)), (long[])Arrays.copyOf(lArray, lArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"make(head(*dims), *tail(*dims))");
        return shape;
    }

    @NotNull
    public static final Shape toShape(@NotNull TensorShape $this$toShape) {
        Intrinsics.checkNotNullParameter((Object)$this$toShape, (String)"<this>");
        long[] d = $this$toShape.dims();
        long[] lArray = ShapeFunctionsKt.tail(Arrays.copyOf(d, d.length));
        Shape shape = Shape.make((long)ShapeFunctionsKt.head(Arrays.copyOf(d, d.length)), (long[])Arrays.copyOf(lArray, lArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"make(head(*d), *tail(*d))");
        return shape;
    }

    @NotNull
    public static final TensorShape toTensorShape(@NotNull Shape $this$toTensorShape) {
        Intrinsics.checkNotNullParameter((Object)$this$toTensorShape, (String)"<this>");
        return new TensorShape(ShapeFunctionsKt.toLongArray($this$toTensorShape));
    }

    @NotNull
    public static final Shape copy(@NotNull Shape $this$copy) {
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"<this>");
        long[] lArray = ShapeFunctionsKt.tail($this$copy);
        Shape shape = Shape.make((long)ShapeFunctionsKt.head($this$copy), (long[])Arrays.copyOf(lArray, lArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"make(head(), *tail())");
        return shape;
    }

    private static final Shape getShapeOfArray(Object[] data) {
        long[] lArray = TensorShapeKt.getDimsOfArray((Object[])data);
        return ShapeFunctionsKt.shapeFromDims(Arrays.copyOf(lArray, lArray.length));
    }

    @NotNull
    public static final Shape getShape(@NotNull Object[] $this$shape) {
        Intrinsics.checkNotNullParameter((Object)$this$shape, (String)"<this>");
        return ShapeFunctionsKt.getShapeOfArray($this$shape);
    }

    public static final long head(long ... dims) {
        Intrinsics.checkNotNullParameter((Object)dims, (String)"dims");
        return dims[0];
    }

    @NotNull
    public static final long[] tail(long ... dims) {
        Intrinsics.checkNotNullParameter((Object)dims, (String)"dims");
        long[] lArray = dims;
        int n = 1;
        int n2 = dims.length;
        return ArraysKt.copyOfRange((long[])lArray, (int)n, (int)n2);
    }

    public static final long numElementsInShape(@NotNull long[] shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        long prod = 1L;
        int n = shape.length;
        for (int i = 0; i < n; ++i) {
            prod *= Math.abs(shape[i]);
        }
        return prod;
    }
}

