/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.layer.convolutional.ConvPadding;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\u001aI\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\u0010\u000b\u001a.\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u001a6\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0000\u001a\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002\u00a8\u0006\u0010"}, d2={"convTransposeOutputLength", "", "inputLength", "filterSize", "", "padding", "Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvPadding;", "outputPaddingStart", "outputPaddingEnd", "stride", "dilation", "(JILorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvPadding;Ljava/lang/Integer;Ljava/lang/Integer;II)J", "convTransposePadding", "", "dilatedKernelSize", "dilatedFilterSize", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nConvUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvUtil.kt\norg/jetbrains/kotlinx/dl/api/core/shape/ConvUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1549#2:65\n1620#2,3:66\n*S KotlinDebug\n*F\n+ 1 ConvUtil.kt\norg/jetbrains/kotlinx/dl/api/core/shape/ConvUtilKt\n*L\n63#1:65\n63#1:66,3\n*E\n"})
public final class ConvUtilKt {
    private static final int dilatedFilterSize(int filterSize, int dilation) {
        return filterSize + (filterSize - 1) * (dilation - 1);
    }

    public static final long convTransposeOutputLength(long inputLength, int filterSize, @NotNull ConvPadding padding, @Nullable Integer outputPaddingStart, @Nullable Integer outputPaddingEnd, int stride, int dilation) {
        Intrinsics.checkNotNullParameter((Object)((Object)padding), (String)"padding");
        int dilatedFilterSize = ConvUtilKt.dilatedFilterSize(filterSize, dilation);
        if (outputPaddingEnd == null || outputPaddingStart == null) {
            long l;
            switch (WhenMappings.$EnumSwitchMapping$0[padding.ordinal()]) {
                case 1: {
                    l = inputLength * (long)stride + (long)Integer.max(dilatedFilterSize - stride, 0);
                    break;
                }
                case 2: {
                    l = inputLength * (long)stride;
                    break;
                }
                case 3: {
                    l = inputLength * (long)stride - (long)(stride + dilatedFilterSize - 2);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return l;
        }
        int totalPadding = CollectionsKt.sumOfInt((Iterable)ConvUtilKt.convTransposePadding(padding, outputPaddingStart, outputPaddingEnd, filterSize, dilation));
        return (inputLength - 1L) * (long)stride + (long)dilatedFilterSize + (long)totalPadding;
    }

    private static final List<Integer> convTransposePadding(ConvPadding padding, int outputPaddingStart, int outputPaddingEnd, int dilatedKernelSize) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[padding.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = dilatedKernelSize / 2;
                break;
            }
            case 3: {
                n = dilatedKernelSize - 1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int automaticPadding = n;
        Object[] objectArray = new Integer[]{outputPaddingStart - automaticPadding, outputPaddingEnd - automaticPadding};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Integer> convTransposePadding(@NotNull ConvPadding padding, int outputPaddingStart, int outputPaddingEnd, int filterSize, int dilation) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)padding), (String)"padding");
        int dilatedKernelSize = ConvUtilKt.dilatedFilterSize(filterSize, dilation);
        Iterable $this$map$iv = ConvUtilKt.convTransposePadding(padding, outputPaddingStart, outputPaddingEnd, dilatedKernelSize);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Integer.max(0, (int)it));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConvPadding.values().length];
            try {
                nArray[ConvPadding.VALID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConvPadding.SAME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConvPadding.FULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

