/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.regularizer;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.loss.LossesKt;
import org.jetbrains.kotlinx.dl.api.core.regularizer.Regularizer;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.ReduceSum;
import org.tensorflow.op.math.Add;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/regularizer/L2L1;", "Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;", "l1", "", "l2", "(FF)V", "getL1", "()F", "getL2", "apply", "Lorg/tensorflow/Operand;", "tf", "Lorg/tensorflow/op/Ops;", "input", "toString", "", "tensorflow"})
public class L2L1
extends Regularizer {
    private final float l1;
    private final float l2;

    public L2L1(float l1, float l2) {
        this.l1 = l1;
        this.l2 = l2;
    }

    public /* synthetic */ L2L1(float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0E-5f;
        }
        if ((n & 2) != 0) {
            f2 = 1.0E-5f;
        }
        this(f, f2);
    }

    public final float getL1() {
        return this.l1;
    }

    public final float getL2() {
        return this.l2;
    }

    @Override
    @NotNull
    public Operand<Float> apply(@NotNull Ops tf, @NotNull Operand<Float> input) {
        ReduceSum reduceSum;
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Constant constant = tf.constant(0.0f);
        Intrinsics.checkNotNullExpressionValue((Object)constant, (String)"tf.constant(0.0f)");
        Operand regularization = (Operand)constant;
        if (this.l1 == 0.0f && this.l2 == 0.0f) {
            return regularization;
        }
        if (!(this.l1 == 0.0f)) {
            reduceSum = tf.reduceSum((Operand)tf.math.abs(input), LossesKt.allAxes(tf, input), new ReduceSum.Options[0]);
            Add add = tf.math.add(regularization, (Operand)tf.math.mul((Operand)tf.constant(this.l1), (Operand)reduceSum));
            Intrinsics.checkNotNullExpressionValue((Object)add, (String)"tf.math.add(regularizati\u2026constant(l1), reduceSum))");
            regularization = (Operand)add;
        }
        if (!(this.l2 == 0.0f)) {
            reduceSum = tf.reduceSum((Operand)tf.math.mul(input, input), LossesKt.allAxes(tf, input), new ReduceSum.Options[0]);
            Add add = tf.math.add(regularization, (Operand)tf.math.mul((Operand)tf.constant(this.l2), (Operand)reduceSum));
            Intrinsics.checkNotNullExpressionValue((Object)add, (String)"tf.math.add(regularizati\u2026constant(l2), reduceSum))");
            regularization = (Operand)add;
        }
        return regularization;
    }

    @NotNull
    public String toString() {
        return "L2L1(l1=" + this.l1 + ", l2=" + this.l2 + ')';
    }

    public L2L1() {
        this(0.0f, 0.0f, 3, null);
    }
}

