/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.optimizer;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.KGraph;
import org.jetbrains.kotlinx.dl.api.core.optimizer.ClipGradientAction;
import org.jetbrains.kotlinx.dl.api.core.optimizer.NoClipGradient;
import org.jetbrains.kotlinx.dl.api.core.optimizer.Optimizer;
import org.jetbrains.kotlinx.dl.api.core.util.DtypeConversionUtilKt;
import org.jetbrains.kotlinx.dl.api.core.util.NameConventionsKt;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.op.Ops;
import org.tensorflow.op.TrainOps;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.Fill;
import org.tensorflow.op.core.Gradients;
import org.tensorflow.op.core.Variable;
import org.tensorflow.op.dtypes.Cast;
import org.tensorflow.op.train.ApplyCenteredRmsProp;
import org.tensorflow.op.train.ApplyRmsProp;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ@\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030 0\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0012\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030&0\u001f2\u0006\u0010'\u001a\u00020(H\u0014J&\u0010)\u001a\u00020*2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030,H\u0002J,\u0010-\u001a\u00020*2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0012\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030,0\u001fH\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\b8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000fR\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/optimizer/RMSProp;", "Lorg/jetbrains/kotlinx/dl/api/core/optimizer/Optimizer;", "learningRate", "", "decay", "momentum", "epsilon", "centered", "", "clipGradient", "Lorg/jetbrains/kotlinx/dl/api/core/optimizer/ClipGradientAction;", "(FFFFZLorg/jetbrains/kotlinx/dl/api/core/optimizer/ClipGradientAction;)V", "getCentered", "()Z", "getDecay", "()F", "decayConst", "Lorg/tensorflow/op/core/Constant;", "getEpsilon", "epsilonConstant", "isRunningOnGPU", "isRunningOnGPU$tensorflow", "getLearningRate", "learningRateConst", "getMomentum", "momentumConst", "optimizerName", "", "getOptimizerName", "()Ljava/lang/String;", "applyGradients", "", "Lorg/tensorflow/Operand;", "graph", "Lorg/jetbrains/kotlinx/dl/api/core/KGraph;", "tf", "Lorg/tensorflow/op/Ops;", "weights", "Lorg/tensorflow/op/core/Variable;", "gradients", "Lorg/tensorflow/op/core/Gradients;", "createRMSPropSlot", "", "v", "Lorg/tensorflow/Output;", "createSlots", "variables", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nRMSProp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RMSProp.kt\norg/jetbrains/kotlinx/dl/api/core/optimizer/RMSProp\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1#2:144\n*E\n"})
public final class RMSProp
extends Optimizer {
    private final float learningRate;
    private final float decay;
    private final float momentum;
    private final float epsilon;
    private final boolean centered;
    private Constant<Float> epsilonConstant;
    private Constant<Float> learningRateConst;
    private Constant<Float> decayConst;
    private Constant<Float> momentumConst;

    public RMSProp(float learningRate, float decay, float momentum, float epsilon, boolean centered, @NotNull ClipGradientAction clipGradient) {
        Intrinsics.checkNotNullParameter((Object)clipGradient, (String)"clipGradient");
        super(clipGradient);
        this.learningRate = learningRate;
        this.decay = decay;
        this.momentum = momentum;
        this.epsilon = epsilon;
        this.centered = centered;
        if (!(this.learningRate >= 0.0f)) {
            boolean $i$a$-require-RMSProp$52 = false;
            String $i$a$-require-RMSProp$52 = "Learning rate " + this.learningRate + " should be >= 0.0.";
            throw new IllegalArgumentException($i$a$-require-RMSProp$52.toString());
        }
        if (!(this.momentum >= 0.0f)) {
            boolean $i$a$-require-RMSProp$62 = false;
            String $i$a$-require-RMSProp$62 = "Momentum " + this.momentum + " should be >= 0.0.";
            throw new IllegalArgumentException($i$a$-require-RMSProp$62.toString());
        }
        if (!(this.decay >= 0.0f)) {
            boolean $i$a$-require-RMSProp$72 = false;
            String $i$a$-require-RMSProp$72 = "Decay " + this.decay + " should be >= 0.0.";
            throw new IllegalArgumentException($i$a$-require-RMSProp$72.toString());
        }
        if (!(this.epsilon >= 0.0f)) {
            boolean bl = false;
            String string = "Epsilon " + this.epsilon + " should be >= 0.0.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ RMSProp(float f, float f2, float f3, float f4, boolean bl, ClipGradientAction clipGradientAction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.001f;
        }
        if ((n & 2) != 0) {
            f2 = 0.9f;
        }
        if ((n & 4) != 0) {
            f3 = 0.0f;
        }
        if ((n & 8) != 0) {
            f4 = 1.0E-10f;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            clipGradientAction = new NoClipGradient();
        }
        this(f, f2, f3, f4, bl, clipGradientAction);
    }

    public final float getLearningRate() {
        return this.learningRate;
    }

    public final float getDecay() {
        return this.decay;
    }

    public final float getMomentum() {
        return this.momentum;
    }

    public final float getEpsilon() {
        return this.epsilon;
    }

    public final boolean getCentered() {
        return this.centered;
    }

    @Override
    @NotNull
    protected List<Operand<Float>> applyGradients(@NotNull KGraph graph, @NotNull Ops tf, @NotNull List<Variable<Float>> weights, @NotNull Gradients gradients) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(weights, (String)"weights");
        Intrinsics.checkNotNullParameter((Object)gradients, (String)"gradients");
        List targets = new ArrayList();
        Constant constant = tf.constant((Object)Float.valueOf(this.decay), DtypeConversionUtilKt.getDType());
        Intrinsics.checkNotNullExpressionValue((Object)constant, (String)"tf.constant(decay, getDType())");
        this.decayConst = constant;
        Constant constant2 = tf.constant((Object)Float.valueOf(this.momentum), DtypeConversionUtilKt.getDType());
        Intrinsics.checkNotNullExpressionValue((Object)constant2, (String)"tf.constant(momentum, getDType())");
        this.momentumConst = constant2;
        Constant constant3 = tf.constant((Object)Float.valueOf(this.learningRate), DtypeConversionUtilKt.getDType());
        Intrinsics.checkNotNullExpressionValue((Object)constant3, (String)"tf.constant(learningRate, getDType())");
        this.learningRateConst = constant3;
        Constant constant4 = tf.constant((Object)Float.valueOf(this.epsilon), DtypeConversionUtilKt.getDType());
        Intrinsics.checkNotNullExpressionValue((Object)constant4, (String)"tf.constant(epsilon, getDType())");
        this.epsilonConstant = constant4;
        int n = weights.size();
        for (int i = 0; i < n; ++i) {
            ApplyCenteredRmsProp applyCenteredRmsProp;
            Variable<Float> variable = weights.get(i);
            String varName = variable.ref().op().name();
            Intrinsics.checkNotNullExpressionValue((Object)varName, (String)"varName");
            Variable<Float> rmsSlot = this.getSlot(varName, "rms");
            Variable<Float> momentumSlot = this.getSlot(varName, "momentum");
            if (this.centered) {
                Variable<Float> mgSlot = this.getSlot(varName, "mg");
                TrainOps trainOps = tf.train;
                Operand operand = (Operand)variable;
                Operand operand2 = (Operand)mgSlot;
                Operand operand3 = (Operand)rmsSlot;
                Operand operand4 = (Operand)momentumSlot;
                Constant<Float> constant5 = this.learningRateConst;
                if (constant5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"learningRateConst");
                    constant5 = null;
                }
                Operand operand5 = (Operand)constant5;
                Constant<Float> constant6 = this.decayConst;
                if (constant6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"decayConst");
                    constant6 = null;
                }
                Operand operand6 = (Operand)constant6;
                Constant<Float> constant7 = this.momentumConst;
                if (constant7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"momentumConst");
                    constant7 = null;
                }
                Operand operand7 = (Operand)constant7;
                Constant<Float> constant8 = this.epsilonConstant;
                if (constant8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"epsilonConstant");
                    constant8 = null;
                }
                Operand operand8 = (Operand)constant8;
                ClipGradientAction clipGradientAction = this.getClipGradient();
                Output output = gradients.dy(i);
                Intrinsics.checkNotNullExpressionValue((Object)output, (String)"gradients.dy(i)");
                ApplyCenteredRmsProp.Options[] optionsArray = new ApplyCenteredRmsProp.Options[]{ApplyCenteredRmsProp.useLocking((Boolean)true)};
                applyCenteredRmsProp = trainOps.applyCenteredRmsProp(operand, operand2, operand3, operand4, operand5, operand6, operand7, operand8, clipGradientAction.clipGradient(tf, (Operand<Float>)((Operand)output)), optionsArray);
                Intrinsics.checkNotNullExpressionValue((Object)applyCenteredRmsProp, (String)"tf.train.applyCenteredRm\u2026ue)\n                    )");
                targets.add(applyCenteredRmsProp);
                continue;
            }
            TrainOps trainOps = tf.train;
            Operand operand = (Operand)variable;
            Operand operand9 = (Operand)rmsSlot;
            Operand operand10 = (Operand)momentumSlot;
            Constant<Float> constant9 = this.learningRateConst;
            if (constant9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"learningRateConst");
                constant9 = null;
            }
            Operand operand11 = (Operand)constant9;
            Constant<Float> constant10 = this.decayConst;
            if (constant10 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"decayConst");
                constant10 = null;
            }
            Operand operand12 = (Operand)constant10;
            Constant<Float> constant11 = this.momentumConst;
            if (constant11 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"momentumConst");
                constant11 = null;
            }
            Operand operand13 = (Operand)constant11;
            Constant<Float> constant12 = this.epsilonConstant;
            if (constant12 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"epsilonConstant");
                constant12 = null;
            }
            applyCenteredRmsProp = new ApplyCenteredRmsProp[]{ApplyRmsProp.useLocking((Boolean)true)};
            ApplyRmsProp applyRmsProp = trainOps.applyRmsProp(operand, operand9, operand10, operand11, operand12, operand13, (Operand)constant12, (Operand)gradients.dy(i), (ApplyRmsProp.Options[])applyCenteredRmsProp);
            Intrinsics.checkNotNullExpressionValue((Object)applyRmsProp, (String)"tf.train.applyRmsProp(\n \u2026ue)\n                    )");
            targets.add(applyRmsProp);
        }
        return targets;
    }

    private final void createRMSPropSlot(KGraph graph, Ops tf, Output<Float> v) {
        String rmsInitializerName = NameConventionsKt.defaultInitializerOpName(this.createName$tensorflow(v, "rms"));
        Fill fill = tf.withName(rmsInitializerName).fill((Operand)tf.shape((Operand)v), (Operand)tf.dtypes.cast((Operand)tf.constant(1.0f), DtypeConversionUtilKt.getDType(), new Cast.Options[0]));
        Intrinsics.checkNotNullExpressionValue((Object)fill, (String)"tf.withName(rmsInitializ\u2026stant(1.0f), getDType()))");
        Operand rmsInitializer = (Operand)fill;
        Output output = v.asOutput();
        Intrinsics.checkNotNullExpressionValue((Object)output, (String)"v.asOutput()");
        this.createSlot(graph, tf, (Output<Float>)output, "rms", (Operand<Float>)rmsInitializer);
        String momentumInitializerName = NameConventionsKt.defaultInitializerOpName(this.createName$tensorflow(v, "momentum"));
        Fill fill2 = tf.withName(momentumInitializerName).fill((Operand)tf.shape((Operand)v), (Operand)tf.dtypes.cast((Operand)tf.constant(0.0f), DtypeConversionUtilKt.getDType(), new Cast.Options[0]));
        Intrinsics.checkNotNullExpressionValue((Object)fill2, (String)"tf.withName(momentumInit\u2026stant(0.0f), getDType()))");
        Operand momentumInitializer = (Operand)fill2;
        Output output2 = v.asOutput();
        Intrinsics.checkNotNullExpressionValue((Object)output2, (String)"v.asOutput()");
        this.createSlot(graph, tf, (Output<Float>)output2, "momentum", (Operand<Float>)momentumInitializer);
        if (this.centered) {
            String mgInitializerName = NameConventionsKt.defaultInitializerOpName(this.createName$tensorflow(v, "mg"));
            Fill fill3 = tf.withName(mgInitializerName).fill((Operand)tf.shape((Operand)v), (Operand)tf.constant(0.0f));
            Intrinsics.checkNotNullExpressionValue((Object)fill3, (String)"tf.withName(mgInitialize\u2026t(0.0f)\n                )");
            Operand mgInitializer = (Operand)fill3;
            Output output3 = v.asOutput();
            Intrinsics.checkNotNullExpressionValue((Object)output3, (String)"v.asOutput()");
            this.createSlot(graph, tf, (Output<Float>)output3, "mg", (Operand<Float>)mgInitializer);
        }
    }

    @Override
    protected void createSlots(@NotNull KGraph graph, @NotNull Ops tf, @NotNull List<Output<Float>> variables2) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(variables2, (String)"variables");
        for (Output<Float> v : variables2) {
            Output output = v.asOutput();
            Intrinsics.checkNotNullExpressionValue((Object)output, (String)"v.asOutput()");
            this.createRMSPropSlot(graph, tf, (Output<Float>)output);
        }
    }

    @Override
    @NotNull
    public String getOptimizerName() {
        return "RMSProp";
    }

    @Override
    public boolean isRunningOnGPU$tensorflow() {
        return true;
    }

    public RMSProp() {
        this(0.0f, 0.0f, 0.0f, 0.0f, false, null, 63, null);
    }
}

