/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.optimizer;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.KGraph;
import org.jetbrains.kotlinx.dl.api.core.optimizer.ClipGradientAction;
import org.jetbrains.kotlinx.dl.api.core.optimizer.NoClipGradient;
import org.jetbrains.kotlinx.dl.api.core.optimizer.Optimizer;
import org.jetbrains.kotlinx.dl.api.core.util.NameConventionsKt;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.op.Ops;
import org.tensorflow.op.TrainOps;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.Fill;
import org.tensorflow.op.core.Gradients;
import org.tensorflow.op.core.Variable;
import org.tensorflow.op.train.ApplyMomentum;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ@\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030 0\u00192\u0006\u0010!\u001a\u00020\"H\u0014J&\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030&H\u0002J,\u0010'\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030&0\u0019H\u0014R\u0014\u0010\n\u001a\u00020\u00068PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\f\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/optimizer/Momentum;", "Lorg/jetbrains/kotlinx/dl/api/core/optimizer/Optimizer;", "learningRate", "", "momentum", "useNesterov", "", "clipGradient", "Lorg/jetbrains/kotlinx/dl/api/core/optimizer/ClipGradientAction;", "(FFZLorg/jetbrains/kotlinx/dl/api/core/optimizer/ClipGradientAction;)V", "isRunningOnGPU", "isRunningOnGPU$tensorflow", "()Z", "getLearningRate", "()F", "learningRateConst", "Lorg/tensorflow/op/core/Constant;", "getMomentum", "momentumConst", "optimizerName", "", "getOptimizerName", "()Ljava/lang/String;", "getUseNesterov", "applyGradients", "", "Lorg/tensorflow/Operand;", "graph", "Lorg/jetbrains/kotlinx/dl/api/core/KGraph;", "tf", "Lorg/tensorflow/op/Ops;", "weights", "Lorg/tensorflow/op/core/Variable;", "gradients", "Lorg/tensorflow/op/core/Gradients;", "createMomentumSlot", "", "v", "Lorg/tensorflow/Output;", "createSlots", "variables", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nMomentum.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Momentum.kt\norg/jetbrains/kotlinx/dl/api/core/optimizer/Momentum\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class Momentum
extends Optimizer {
    private final float learningRate;
    private final float momentum;
    private final boolean useNesterov;
    private Constant<Float> momentumConst;
    private Constant<Float> learningRateConst;

    public Momentum(float learningRate, float momentum, boolean useNesterov, @NotNull ClipGradientAction clipGradient) {
        Intrinsics.checkNotNullParameter((Object)clipGradient, (String)"clipGradient");
        super(clipGradient);
        this.learningRate = learningRate;
        this.momentum = momentum;
        this.useNesterov = useNesterov;
        if (!(this.learningRate >= 0.0f)) {
            boolean $i$a$-require-Momentum$32 = false;
            String $i$a$-require-Momentum$32 = "Learning rate " + this.learningRate + " should be >= 0.0.";
            throw new IllegalArgumentException($i$a$-require-Momentum$32.toString());
        }
        if (!(this.momentum >= 0.0f)) {
            boolean bl = false;
            String string = "Momentum " + this.momentum + " should be >= 0.0.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Momentum(float f, float f2, boolean bl, ClipGradientAction clipGradientAction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.001f;
        }
        if ((n & 2) != 0) {
            f2 = 0.99f;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            clipGradientAction = new NoClipGradient();
        }
        this(f, f2, bl, clipGradientAction);
    }

    public final float getLearningRate() {
        return this.learningRate;
    }

    public final float getMomentum() {
        return this.momentum;
    }

    public final boolean getUseNesterov() {
        return this.useNesterov;
    }

    @Override
    @NotNull
    protected List<Operand<Float>> applyGradients(@NotNull KGraph graph, @NotNull Ops tf, @NotNull List<Variable<Float>> weights, @NotNull Gradients gradients) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(weights, (String)"weights");
        Intrinsics.checkNotNullParameter((Object)gradients, (String)"gradients");
        List targets = new ArrayList();
        Constant constant = tf.constant(this.learningRate);
        Intrinsics.checkNotNullExpressionValue((Object)constant, (String)"tf.constant(learningRate)");
        this.learningRateConst = constant;
        Constant constant2 = tf.constant(this.momentum);
        Intrinsics.checkNotNullExpressionValue((Object)constant2, (String)"tf.constant(momentum)");
        this.momentumConst = constant2;
        int n = weights.size();
        for (int i = 0; i < n; ++i) {
            Variable<Float> variable = weights.get(i);
            String string = variable.ref().op().name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variable.ref().op().name()");
            Variable<Float> slot = this.getSlot(string, "momentum");
            TrainOps trainOps = tf.train;
            Operand operand = (Operand)variable;
            Operand operand2 = (Operand)slot;
            Constant<Float> constant3 = this.learningRateConst;
            if (constant3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"learningRateConst");
                constant3 = null;
            }
            Operand operand3 = (Operand)constant3;
            ClipGradientAction clipGradientAction = this.getClipGradient();
            Output output = gradients.dy(i);
            Intrinsics.checkNotNullExpressionValue((Object)output, (String)"gradients.dy(i)");
            Operand<Float> operand4 = clipGradientAction.clipGradient(tf, (Operand<Float>)((Operand)output));
            Constant<Float> constant4 = this.momentumConst;
            if (constant4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"momentumConst");
                constant4 = null;
            }
            ApplyMomentum.Options[] optionsArray = new ApplyMomentum.Options[]{ApplyMomentum.useNesterov((Boolean)this.useNesterov), ApplyMomentum.useLocking((Boolean)true)};
            ApplyMomentum applyMomentum = trainOps.applyMomentum(operand, operand2, operand3, operand4, (Operand)constant4, optionsArray);
            Intrinsics.checkNotNullExpressionValue((Object)applyMomentum, (String)"tf.train.applyMomentum(\n\u2026g(true)\n                )");
            targets.add(applyMomentum);
        }
        return targets;
    }

    private final void createMomentumSlot(KGraph graph, Ops tf, Output<Float> v) {
        String momentumInitializerName = NameConventionsKt.defaultInitializerOpName(this.createName$tensorflow(v, "momentum"));
        Fill fill = tf.withName(momentumInitializerName).fill((Operand)tf.shape((Operand)v), (Operand)tf.constant(0.0f));
        Intrinsics.checkNotNullExpressionValue((Object)fill, (String)"tf.withName(momentumInit\u2026pe(v), tf.constant(0.0f))");
        Operand initializer = (Operand)fill;
        Output output = v.asOutput();
        Intrinsics.checkNotNullExpressionValue((Object)output, (String)"v.asOutput()");
        this.createSlot(graph, tf, (Output<Float>)output, "momentum", (Operand<Float>)initializer);
    }

    @Override
    protected void createSlots(@NotNull KGraph graph, @NotNull Ops tf, @NotNull List<Output<Float>> variables2) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(variables2, (String)"variables");
        for (Output<Float> v : variables2) {
            Output output = v.asOutput();
            Intrinsics.checkNotNullExpressionValue((Object)output, (String)"v.asOutput()");
            this.createMomentumSlot(graph, tf, (Output<Float>)output);
        }
    }

    @Override
    @NotNull
    public String getOptimizerName() {
        return "Momentum";
    }

    @Override
    public boolean isRunningOnGPU$tensorflow() {
        return true;
    }

    public Momentum() {
        this(0.0f, 0.0f, false, null, 15, null);
    }
}

