/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.optimizer;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.KGraph;
import org.jetbrains.kotlinx.dl.api.core.optimizer.ClipGradientAction;
import org.jetbrains.kotlinx.dl.api.core.optimizer.NoClipGradient;
import org.jetbrains.kotlinx.dl.api.core.optimizer.Optimizer;
import org.jetbrains.kotlinx.dl.api.core.util.DtypeConversionUtilKt;
import org.jetbrains.kotlinx.dl.api.core.util.NameConventionsKt;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.op.Ops;
import org.tensorflow.op.TrainOps;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.Fill;
import org.tensorflow.op.core.Gradients;
import org.tensorflow.op.core.Variable;
import org.tensorflow.op.train.ApplyFtrl;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BK\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ@\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030%0$2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0012\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030+0$2\u0006\u0010,\u001a\u00020-H\u0014J&\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000301H\u0002J,\u00102\u001a\u00020/2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0012\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0003010$H\u0014R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\rR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\rR\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/optimizer/Ftrl;", "Lorg/jetbrains/kotlinx/dl/api/core/optimizer/Optimizer;", "learningRate", "", "l1RegularizationStrength", "l2RegularizationStrength", "learningRatePower", "l2ShrinkageRegularizationStrength", "initialAccumulatorValue", "clipGradient", "Lorg/jetbrains/kotlinx/dl/api/core/optimizer/ClipGradientAction;", "(FFFFFFLorg/jetbrains/kotlinx/dl/api/core/optimizer/ClipGradientAction;)V", "getInitialAccumulatorValue", "()F", "setInitialAccumulatorValue", "(F)V", "isRunningOnGPU", "", "isRunningOnGPU$tensorflow", "()Z", "getL1RegularizationStrength", "l1RegularizationStrengthConst", "Lorg/tensorflow/op/core/Constant;", "getL2RegularizationStrength", "l2RegularizationStrengthConst", "getL2ShrinkageRegularizationStrength", "l2ShrinkageRegularizationStrengthConst", "getLearningRate", "learningRateConst", "getLearningRatePower", "learningRatePowerConst", "optimizerName", "", "getOptimizerName", "()Ljava/lang/String;", "applyGradients", "", "Lorg/tensorflow/Operand;", "graph", "Lorg/jetbrains/kotlinx/dl/api/core/KGraph;", "tf", "Lorg/tensorflow/op/Ops;", "weights", "Lorg/tensorflow/op/core/Variable;", "gradients", "Lorg/tensorflow/op/core/Gradients;", "createFtrlSlot", "", "v", "Lorg/tensorflow/Output;", "createSlots", "variables", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nFtrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ftrl.kt\norg/jetbrains/kotlinx/dl/api/core/optimizer/Ftrl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1#2:145\n*E\n"})
public final class Ftrl
extends Optimizer {
    private final float learningRate;
    private final float l1RegularizationStrength;
    private final float l2RegularizationStrength;
    private final float learningRatePower;
    private final float l2ShrinkageRegularizationStrength;
    private float initialAccumulatorValue;
    private Constant<Float> learningRatePowerConst;
    private Constant<Float> learningRateConst;
    private Constant<Float> l1RegularizationStrengthConst;
    private Constant<Float> l2RegularizationStrengthConst;
    private Constant<Float> l2ShrinkageRegularizationStrengthConst;

    public Ftrl(float learningRate, float l1RegularizationStrength, float l2RegularizationStrength, float learningRatePower, float l2ShrinkageRegularizationStrength, float initialAccumulatorValue, @NotNull ClipGradientAction clipGradient) {
        Intrinsics.checkNotNullParameter((Object)clipGradient, (String)"clipGradient");
        super(clipGradient);
        this.learningRate = learningRate;
        this.l1RegularizationStrength = l1RegularizationStrength;
        this.l2RegularizationStrength = l2RegularizationStrength;
        this.learningRatePower = learningRatePower;
        this.l2ShrinkageRegularizationStrength = l2ShrinkageRegularizationStrength;
        this.initialAccumulatorValue = initialAccumulatorValue;
        if (!(this.learningRate >= 0.0f)) {
            boolean $i$a$-require-Ftrl$72 = false;
            String $i$a$-require-Ftrl$72 = "Learning rate " + this.learningRate + " should be >= 0.0.";
            throw new IllegalArgumentException($i$a$-require-Ftrl$72.toString());
        }
        if (!(this.initialAccumulatorValue >= 0.0f)) {
            boolean $i$a$-require-Ftrl$82 = false;
            String $i$a$-require-Ftrl$82 = "Initial accumulator value " + this.initialAccumulatorValue + " should be >= 0.0.";
            throw new IllegalArgumentException($i$a$-require-Ftrl$82.toString());
        }
        if (!(this.l1RegularizationStrength >= 0.0f)) {
            boolean $i$a$-require-Ftrl$92 = false;
            String $i$a$-require-Ftrl$92 = "L1 Regularization Strength " + this.l1RegularizationStrength + " should be >= 0.0.";
            throw new IllegalArgumentException($i$a$-require-Ftrl$92.toString());
        }
        if (!(this.l2RegularizationStrength >= 0.0f)) {
            boolean $i$a$-require-Ftrl$102 = false;
            String $i$a$-require-Ftrl$102 = "L2 Regularization Strength " + this.l2RegularizationStrength + " should be >= 0.0.";
            throw new IllegalArgumentException($i$a$-require-Ftrl$102.toString());
        }
        if (!(this.learningRatePower <= 0.0f)) {
            boolean $i$a$-require-Ftrl$112 = false;
            String $i$a$-require-Ftrl$112 = "Learning rate power " + this.learningRatePower + " should be <= 0.0.";
            throw new IllegalArgumentException($i$a$-require-Ftrl$112.toString());
        }
        if (!(this.l2ShrinkageRegularizationStrength >= 0.0f)) {
            boolean bl = false;
            String string = "L2 Shrinkage Regularization Strength " + this.l2ShrinkageRegularizationStrength + " should be >= 0.0.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Ftrl(float f, float f2, float f3, float f4, float f5, float f6, ClipGradientAction clipGradientAction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.001f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.0f;
        }
        if ((n & 8) != 0) {
            f4 = -0.5f;
        }
        if ((n & 0x10) != 0) {
            f5 = 0.0f;
        }
        if ((n & 0x20) != 0) {
            f6 = 0.0f;
        }
        if ((n & 0x40) != 0) {
            clipGradientAction = new NoClipGradient();
        }
        this(f, f2, f3, f4, f5, f6, clipGradientAction);
    }

    public final float getLearningRate() {
        return this.learningRate;
    }

    public final float getL1RegularizationStrength() {
        return this.l1RegularizationStrength;
    }

    public final float getL2RegularizationStrength() {
        return this.l2RegularizationStrength;
    }

    public final float getLearningRatePower() {
        return this.learningRatePower;
    }

    public final float getL2ShrinkageRegularizationStrength() {
        return this.l2ShrinkageRegularizationStrength;
    }

    public final float getInitialAccumulatorValue() {
        return this.initialAccumulatorValue;
    }

    public final void setInitialAccumulatorValue(float f) {
        this.initialAccumulatorValue = f;
    }

    @Override
    @NotNull
    protected List<Operand<Float>> applyGradients(@NotNull KGraph graph, @NotNull Ops tf, @NotNull List<Variable<Float>> weights, @NotNull Gradients gradients) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(weights, (String)"weights");
        Intrinsics.checkNotNullParameter((Object)gradients, (String)"gradients");
        List targets = new ArrayList();
        Constant constant = tf.constant((Object)Float.valueOf(this.l1RegularizationStrength), DtypeConversionUtilKt.getDType());
        Intrinsics.checkNotNullExpressionValue((Object)constant, (String)"tf.constant(l1RegularizationStrength, getDType())");
        this.l1RegularizationStrengthConst = constant;
        Constant constant2 = tf.constant((Object)Float.valueOf(this.l2RegularizationStrength), DtypeConversionUtilKt.getDType());
        Intrinsics.checkNotNullExpressionValue((Object)constant2, (String)"tf.constant(l2RegularizationStrength, getDType())");
        this.l2RegularizationStrengthConst = constant2;
        Constant constant3 = tf.constant((Object)Float.valueOf(this.learningRate), DtypeConversionUtilKt.getDType());
        Intrinsics.checkNotNullExpressionValue((Object)constant3, (String)"tf.constant(learningRate, getDType())");
        this.learningRateConst = constant3;
        Constant constant4 = tf.constant((Object)Float.valueOf(this.l2ShrinkageRegularizationStrength), DtypeConversionUtilKt.getDType());
        Intrinsics.checkNotNullExpressionValue((Object)constant4, (String)"tf.constant(l2ShrinkageR\u2026tionStrength, getDType())");
        this.l2ShrinkageRegularizationStrengthConst = constant4;
        Constant constant5 = tf.constant((Object)Float.valueOf(this.learningRatePower), DtypeConversionUtilKt.getDType());
        Intrinsics.checkNotNullExpressionValue((Object)constant5, (String)"tf.constant(learningRatePower, getDType())");
        this.learningRatePowerConst = constant5;
        int n = weights.size();
        for (int i = 0; i < n; ++i) {
            Variable<Float> variable = weights.get(i);
            String varName = variable.ref().op().name();
            Intrinsics.checkNotNullExpressionValue((Object)varName, (String)"varName");
            Variable<Float> accumSlot = this.getSlot(varName, "gradient_accumulator");
            Variable<Float> linearSlot = this.getSlot(varName, "linear_accumulator");
            ApplyFtrl.Options options = ApplyFtrl.useLocking((Boolean)true);
            TrainOps trainOps = tf.train;
            Operand operand = (Operand)variable;
            Operand operand2 = (Operand)accumSlot;
            Operand operand3 = (Operand)linearSlot;
            ClipGradientAction clipGradientAction = this.getClipGradient();
            Output output = gradients.dy(i);
            Intrinsics.checkNotNullExpressionValue((Object)output, (String)"gradients.dy(i)");
            Operand<Float> operand4 = clipGradientAction.clipGradient(tf, (Operand<Float>)((Operand)output));
            Constant<Float> constant6 = this.learningRateConst;
            if (constant6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"learningRateConst");
                constant6 = null;
            }
            Operand operand5 = (Operand)constant6;
            Constant<Float> constant7 = this.l1RegularizationStrengthConst;
            if (constant7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"l1RegularizationStrengthConst");
                constant7 = null;
            }
            Operand operand6 = (Operand)constant7;
            Constant<Float> constant8 = this.l2RegularizationStrengthConst;
            if (constant8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"l2RegularizationStrengthConst");
                constant8 = null;
            }
            Operand operand7 = (Operand)constant8;
            Constant<Float> constant9 = this.l2ShrinkageRegularizationStrengthConst;
            if (constant9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"l2ShrinkageRegularizationStrengthConst");
                constant9 = null;
            }
            Operand operand8 = (Operand)constant9;
            Constant<Float> constant10 = this.learningRatePowerConst;
            if (constant10 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"learningRatePowerConst");
                constant10 = null;
            }
            ApplyFtrl.Options[] optionsArray = new ApplyFtrl.Options[]{options};
            ApplyFtrl applyFtrl = trainOps.applyFtrl(operand, operand2, operand3, operand4, operand5, operand6, operand7, operand8, (Operand)constant10, optionsArray);
            Intrinsics.checkNotNullExpressionValue((Object)applyFtrl, (String)"tf.train.applyFtrl(\n    \u2026options\n                )");
            targets.add(applyFtrl);
        }
        return targets;
    }

    private final void createFtrlSlot(KGraph graph, Ops tf, Output<Float> v) {
        String accumInitializerName = NameConventionsKt.defaultInitializerOpName(this.createName$tensorflow(v, "gradient_accumulator"));
        Fill accumInitializer = tf.withName(accumInitializerName).fill((Operand)tf.shape((Operand)v), (Operand)tf.constant(this.initialAccumulatorValue));
        Output output = v.asOutput();
        Intrinsics.checkNotNullExpressionValue((Object)output, (String)"v.asOutput()");
        Intrinsics.checkNotNullExpressionValue((Object)accumInitializer, (String)"accumInitializer");
        this.createSlot(graph, tf, (Output<Float>)output, "gradient_accumulator", (Operand<Float>)((Operand)accumInitializer));
        String linearAccumInitializerName = NameConventionsKt.defaultInitializerOpName(this.createName$tensorflow(v, "linear_accumulator"));
        Fill linearAccumInitializer = tf.withName(linearAccumInitializerName).fill((Operand)tf.shape((Operand)v), (Operand)tf.constant(0.0f));
        Output output2 = v.asOutput();
        Intrinsics.checkNotNullExpressionValue((Object)output2, (String)"v.asOutput()");
        Intrinsics.checkNotNullExpressionValue((Object)linearAccumInitializer, (String)"linearAccumInitializer");
        this.createSlot(graph, tf, (Output<Float>)output2, "linear_accumulator", (Operand<Float>)((Operand)linearAccumInitializer));
    }

    @Override
    protected void createSlots(@NotNull KGraph graph, @NotNull Ops tf, @NotNull List<Output<Float>> variables2) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(variables2, (String)"variables");
        for (Output<Float> v : variables2) {
            Output output = v.asOutput();
            Intrinsics.checkNotNullExpressionValue((Object)output, (String)"v.asOutput()");
            this.createFtrlSlot(graph, tf, (Output<Float>)output);
        }
    }

    @Override
    @NotNull
    public String getOptimizerName() {
        return "Ftrl";
    }

    @Override
    public boolean isRunningOnGPU$tensorflow() {
        return false;
    }

    public Ftrl() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, null, 127, null);
    }
}

