/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.optimizer;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.optimizer.ClipGradientAction;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.ClipByValue;
import org.tensorflow.op.core.Constant;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/optimizer/ClipGradientByValue;", "Lorg/jetbrains/kotlinx/dl/api/core/optimizer/ClipGradientAction;", "clipValue", "", "(F)V", "clipGradient", "Lorg/tensorflow/Operand;", "tf", "Lorg/tensorflow/op/Ops;", "gradient", "tensorflow"})
public final class ClipGradientByValue
extends ClipGradientAction {
    private final float clipValue;

    public ClipGradientByValue(float clipValue) {
        this.clipValue = clipValue;
    }

    @Override
    @NotNull
    public Operand<Float> clipGradient(@NotNull Ops tf, @NotNull Operand<Float> gradient) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(gradient, (String)"gradient");
        Constant constant = tf.constant(-this.clipValue);
        Intrinsics.checkNotNull((Object)constant, (String)"null cannot be cast to non-null type org.tensorflow.Operand<kotlin.Float>");
        ClipByValue clipByValue = tf.clipByValue(gradient, (Operand)constant, (Operand)tf.constant(this.clipValue));
        Intrinsics.checkNotNullExpressionValue((Object)clipByValue, (String)"tf.clipByValue(gradient,\u2026, tf.constant(clipValue))");
        return (Operand)clipByValue;
    }
}

