/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.optimizer;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.KGraph;
import org.jetbrains.kotlinx.dl.api.core.optimizer.AdaGradDAKt;
import org.jetbrains.kotlinx.dl.api.core.optimizer.ClipGradientAction;
import org.jetbrains.kotlinx.dl.api.core.optimizer.NoClipGradient;
import org.jetbrains.kotlinx.dl.api.core.optimizer.Optimizer;
import org.jetbrains.kotlinx.dl.api.core.util.DtypeConversionUtilKt;
import org.jetbrains.kotlinx.dl.api.core.util.NameConventionsKt;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.DtypesOps;
import org.tensorflow.op.Ops;
import org.tensorflow.op.TrainOps;
import org.tensorflow.op.core.Assign;
import org.tensorflow.op.core.AssignAdd;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.Fill;
import org.tensorflow.op.core.Gradients;
import org.tensorflow.op.core.Variable;
import org.tensorflow.op.dtypes.Cast;
import org.tensorflow.op.train.ApplyAdagradDa;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ@\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b0\u001e2\u0006\u0010%\u001a\u00020&H\u0014J&\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030*H\u0002J,\u0010+\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0012\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030*0\u001eH\u0014R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/optimizer/AdaGradDA;", "Lorg/jetbrains/kotlinx/dl/api/core/optimizer/Optimizer;", "learningRate", "", "initialAccumulatorValue", "l1Strength", "l2Strength", "clipGradient", "Lorg/jetbrains/kotlinx/dl/api/core/optimizer/ClipGradientAction;", "(FFFFLorg/jetbrains/kotlinx/dl/api/core/optimizer/ClipGradientAction;)V", "globalStep", "Lorg/tensorflow/op/core/Variable;", "getInitialAccumulatorValue", "()F", "isRunningOnGPU", "", "isRunningOnGPU$tensorflow", "()Z", "getL1Strength", "l1StrengthConst", "Lorg/tensorflow/op/core/Constant;", "getL2Strength", "l2StrengthConst", "getLearningRate", "learningRateConst", "optimizerName", "", "getOptimizerName", "()Ljava/lang/String;", "applyGradients", "", "Lorg/tensorflow/Operand;", "graph", "Lorg/jetbrains/kotlinx/dl/api/core/KGraph;", "tf", "Lorg/tensorflow/op/Ops;", "weights", "gradients", "Lorg/tensorflow/op/core/Gradients;", "createAdaGradDASlot", "", "v", "Lorg/tensorflow/Output;", "createSlots", "variables", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nAdaGradDA.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdaGradDA.kt\norg/jetbrains/kotlinx/dl/api/core/optimizer/AdaGradDA\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class AdaGradDA
extends Optimizer {
    private final float learningRate;
    private final float initialAccumulatorValue;
    private final float l1Strength;
    private final float l2Strength;
    private Constant<Float> learningRateConst;
    private Constant<Float> l1StrengthConst;
    private Constant<Float> l2StrengthConst;
    private Variable<Float> globalStep;

    public AdaGradDA(float learningRate, float initialAccumulatorValue, float l1Strength, float l2Strength, @NotNull ClipGradientAction clipGradient) {
        Intrinsics.checkNotNullParameter((Object)clipGradient, (String)"clipGradient");
        super(clipGradient);
        this.learningRate = learningRate;
        this.initialAccumulatorValue = initialAccumulatorValue;
        this.l1Strength = l1Strength;
        this.l2Strength = l2Strength;
        if (!(this.learningRate >= 0.0f)) {
            boolean $i$a$-require-AdaGradDA$52 = false;
            String $i$a$-require-AdaGradDA$52 = "Learning rate " + this.learningRate + " should be >= 0.0.";
            throw new IllegalArgumentException($i$a$-require-AdaGradDA$52.toString());
        }
        if (!(this.initialAccumulatorValue >= 0.0f)) {
            boolean $i$a$-require-AdaGradDA$62 = false;
            String $i$a$-require-AdaGradDA$62 = "Initial accumulator value " + this.initialAccumulatorValue + " should be >= 0.0.";
            throw new IllegalArgumentException($i$a$-require-AdaGradDA$62.toString());
        }
        if (!(this.l1Strength >= 0.0f)) {
            boolean $i$a$-require-AdaGradDA$72 = false;
            String $i$a$-require-AdaGradDA$72 = "L1Strength " + this.l1Strength + " should be >= 0.0.";
            throw new IllegalArgumentException($i$a$-require-AdaGradDA$72.toString());
        }
        if (!(this.l2Strength >= 0.0f)) {
            boolean bl = false;
            String string = "L2Strength " + this.l2Strength + " should be >= 0.0.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ AdaGradDA(float f, float f2, float f3, float f4, ClipGradientAction clipGradientAction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.1f;
        }
        if ((n & 2) != 0) {
            f2 = 0.01f;
        }
        if ((n & 4) != 0) {
            f3 = 0.01f;
        }
        if ((n & 8) != 0) {
            f4 = 0.01f;
        }
        if ((n & 0x10) != 0) {
            clipGradientAction = new NoClipGradient();
        }
        this(f, f2, f3, f4, clipGradientAction);
    }

    public final float getLearningRate() {
        return this.learningRate;
    }

    public final float getInitialAccumulatorValue() {
        return this.initialAccumulatorValue;
    }

    public final float getL1Strength() {
        return this.l1Strength;
    }

    public final float getL2Strength() {
        return this.l2Strength;
    }

    @Override
    @NotNull
    protected List<Operand<Float>> applyGradients(@NotNull KGraph graph, @NotNull Ops tf, @NotNull List<Variable<Float>> weights, @NotNull Gradients gradients) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(weights, (String)"weights");
        Intrinsics.checkNotNullParameter((Object)gradients, (String)"gradients");
        List targets = new ArrayList();
        Constant constant = tf.constant((Object)Float.valueOf(this.learningRate), DtypeConversionUtilKt.getDType());
        Intrinsics.checkNotNullExpressionValue((Object)constant, (String)"tf.constant(learningRate, getDType())");
        this.learningRateConst = constant;
        Constant constant2 = tf.constant((Object)Float.valueOf(this.l1Strength), DtypeConversionUtilKt.getDType());
        Intrinsics.checkNotNullExpressionValue((Object)constant2, (String)"tf.constant(l1Strength, getDType())");
        this.l1StrengthConst = constant2;
        Constant constant3 = tf.constant((Object)Float.valueOf(this.l2Strength), DtypeConversionUtilKt.getDType());
        Intrinsics.checkNotNullExpressionValue((Object)constant3, (String)"tf.constant(l2Strength, getDType())");
        this.l2StrengthConst = constant3;
        int n = weights.size();
        for (int i = 0; i < n; ++i) {
            Variable<Float> variable = weights.get(i);
            String varName = variable.ref().op().name();
            Intrinsics.checkNotNullExpressionValue((Object)varName, (String)"varName");
            Variable<Float> gradSlot = this.getSlot(varName, "gradient_accumulator");
            Variable<Float> gradSquaredSlot = this.getSlot(varName, "gradient_squared_accumulator");
            TrainOps trainOps = tf.train;
            Operand operand = (Operand)variable;
            Operand operand2 = (Operand)gradSlot;
            Operand operand3 = (Operand)gradSquaredSlot;
            ClipGradientAction clipGradientAction = this.getClipGradient();
            Output output = gradients.dy(i);
            Intrinsics.checkNotNullExpressionValue((Object)output, (String)"gradients.dy(i)");
            Operand<Float> operand4 = clipGradientAction.clipGradient(tf, (Operand<Float>)((Operand)output));
            Constant<Float> constant4 = this.learningRateConst;
            if (constant4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"learningRateConst");
                constant4 = null;
            }
            Operand operand5 = (Operand)constant4;
            Constant<Float> constant5 = this.l1StrengthConst;
            if (constant5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"l1StrengthConst");
                constant5 = null;
            }
            Operand operand6 = (Operand)constant5;
            Constant<Float> constant6 = this.l2StrengthConst;
            if (constant6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"l2StrengthConst");
                constant6 = null;
            }
            Operand operand7 = (Operand)constant6;
            DtypesOps dtypesOps = tf.dtypes;
            Variable<Float> variable2 = this.globalStep;
            if (variable2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"globalStep");
                variable2 = null;
            }
            ApplyAdagradDa.Options[] optionsArray = new ApplyAdagradDa.Options[]{ApplyAdagradDa.useLocking((Boolean)true)};
            ApplyAdagradDa applyAdagradDa = trainOps.applyAdagradDa(operand, operand2, operand3, operand4, operand5, operand6, operand7, (Operand)dtypesOps.cast((Operand)variable2, Long.class, new Cast.Options[0]), optionsArray);
            Intrinsics.checkNotNullExpressionValue((Object)applyAdagradDa, (String)"tf.train.applyAdagradDa(\u2026g(true)\n                )");
            targets.add(applyAdagradDa);
        }
        Variable<Float> variable = this.globalStep;
        if (variable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"globalStep");
            variable = null;
        }
        AssignAdd globalStepInitFinish = tf.assignAdd((Operand)variable, (Operand)tf.constant(1.0f), new AssignAdd.Options[0]);
        Intrinsics.checkNotNullExpressionValue((Object)globalStepInitFinish, (String)"globalStepInitFinish");
        graph.addOptimizerVariableAssignAddInitializer((AssignAdd<Float>)globalStepInitFinish);
        Variable<Float> variable3 = this.globalStep;
        if (variable3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"globalStep");
            variable3 = null;
        }
        graph.addOptimizerVariable(variable3);
        return targets;
    }

    private final void createAdaGradDASlot(KGraph graph, Ops tf, Output<Float> v) {
        String accumulatorInitializerName = NameConventionsKt.defaultInitializerOpName(this.createName$tensorflow(v, "gradient_accumulator"));
        Fill fill = tf.withName(accumulatorInitializerName).fill((Operand)tf.shape((Operand)v), (Operand)tf.constant(0.0f));
        Intrinsics.checkNotNullExpressionValue((Object)fill, (String)"tf.withName(accumulatorI\u2026pe(v), tf.constant(0.0f))");
        Operand accumInitializer = (Operand)fill;
        Output output = v.asOutput();
        Intrinsics.checkNotNullExpressionValue((Object)output, (String)"v.asOutput()");
        this.createSlot(graph, tf, (Output<Float>)output, "gradient_accumulator", (Operand<Float>)accumInitializer);
        String squareAccumInitializerName = NameConventionsKt.defaultInitializerOpName(this.createName$tensorflow(v, "gradient_squared_accumulator"));
        Fill fill2 = tf.withName(squareAccumInitializerName).fill((Operand)tf.shape((Operand)v), (Operand)tf.constant(this.initialAccumulatorValue));
        Intrinsics.checkNotNullExpressionValue((Object)fill2, (String)"tf.withName(squareAccumI\u2026initialAccumulatorValue))");
        Operand sqInitializer = (Operand)fill2;
        Output output2 = v.asOutput();
        Intrinsics.checkNotNullExpressionValue((Object)output2, (String)"v.asOutput()");
        this.createSlot(graph, tf, (Output<Float>)output2, "gradient_squared_accumulator", (Operand<Float>)sqInitializer);
    }

    @Override
    protected void createSlots(@NotNull KGraph graph, @NotNull Ops tf, @NotNull List<Output<Float>> variables2) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(variables2, (String)"variables");
        for (Output<Float> v : variables2) {
            Output output = v.asOutput();
            Intrinsics.checkNotNullExpressionValue((Object)output, (String)"v.asOutput()");
            this.createAdaGradDASlot(graph, tf, (Output<Float>)output);
        }
        Variable variable = tf.withName(AdaGradDAKt.access$getGLOBAL_STEP$p()).variable(Shape.scalar(), DtypeConversionUtilKt.getDType(), new Variable.Options[0]);
        Intrinsics.checkNotNullExpressionValue((Object)variable, (String)"tf.withName(GLOBAL_STEP)\u2026ape.scalar(), getDType())");
        this.globalStep = variable;
        String globalStepAssignName = NameConventionsKt.defaultAssignOpName(AdaGradDAKt.access$getGLOBAL_STEP$p());
        Ops ops = tf.withName(globalStepAssignName);
        Variable<Float> variable2 = this.globalStep;
        if (variable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"globalStep");
            variable2 = null;
        }
        Assign assign = ops.assign((Operand)variable2, (Operand)tf.withName(NameConventionsKt.defaultInitializerOpName(AdaGradDAKt.access$getGLOBAL_STEP$p())).constant(0.0f), new Assign.Options[0]);
        Intrinsics.checkNotNullExpressionValue((Object)assign, (String)"tf.withName(globalStepAs\u2026AL_STEP)).constant(0.0f))");
        Assign globalStepInit = assign;
        graph.addOptimizerVariableInitializer(globalStepInit);
    }

    @Override
    @NotNull
    public String getOptimizerName() {
        return "AdaGradDA";
    }

    @Override
    public boolean isRunningOnGPU$tensorflow() {
        return true;
    }

    public AdaGradDA() {
        this(0.0f, 0.0f, 0.0f, 0.0f, null, 31, null);
    }
}

