/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.optimizer;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.KGraph;
import org.jetbrains.kotlinx.dl.api.core.optimizer.ClipGradientAction;
import org.jetbrains.kotlinx.dl.api.core.optimizer.NoClipGradient;
import org.jetbrains.kotlinx.dl.api.core.optimizer.Optimizer;
import org.jetbrains.kotlinx.dl.api.core.util.DtypeConversionUtilKt;
import org.jetbrains.kotlinx.dl.api.core.util.NameConventionsKt;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.op.Ops;
import org.tensorflow.op.TrainOps;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.Fill;
import org.tensorflow.op.core.Gradients;
import org.tensorflow.op.core.Variable;
import org.tensorflow.op.train.ApplyAdagrad;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J@\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001e0\u00172\u0006\u0010\u001f\u001a\u00020 H\u0014J&\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$H\u0002J,\u0010%\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030$0\u0017H\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/optimizer/AdaGrad;", "Lorg/jetbrains/kotlinx/dl/api/core/optimizer/Optimizer;", "learningRate", "", "initialAccumulatorValue", "clipGradient", "Lorg/jetbrains/kotlinx/dl/api/core/optimizer/ClipGradientAction;", "(FFLorg/jetbrains/kotlinx/dl/api/core/optimizer/ClipGradientAction;)V", "getInitialAccumulatorValue", "()F", "initialAccumulatorValueConstant", "Lorg/tensorflow/op/core/Constant;", "isRunningOnGPU", "", "isRunningOnGPU$tensorflow", "()Z", "getLearningRate", "learningRateConst", "optimizerName", "", "getOptimizerName", "()Ljava/lang/String;", "applyGradients", "", "Lorg/tensorflow/Operand;", "graph", "Lorg/jetbrains/kotlinx/dl/api/core/KGraph;", "tf", "Lorg/tensorflow/op/Ops;", "weights", "Lorg/tensorflow/op/core/Variable;", "gradients", "Lorg/tensorflow/op/core/Gradients;", "createAdaGradSlot", "", "v", "Lorg/tensorflow/Output;", "createSlots", "variables", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nAdaGrad.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdaGrad.kt\norg/jetbrains/kotlinx/dl/api/core/optimizer/AdaGrad\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public final class AdaGrad
extends Optimizer {
    private final float learningRate;
    private final float initialAccumulatorValue;
    private Constant<Float> initialAccumulatorValueConstant;
    private Constant<Float> learningRateConst;

    public AdaGrad(float learningRate, float initialAccumulatorValue, @NotNull ClipGradientAction clipGradient) {
        Intrinsics.checkNotNullParameter((Object)clipGradient, (String)"clipGradient");
        super(clipGradient);
        this.learningRate = learningRate;
        this.initialAccumulatorValue = initialAccumulatorValue;
        if (!(this.learningRate >= 0.0f)) {
            boolean $i$a$-require-AdaGrad$32 = false;
            String $i$a$-require-AdaGrad$32 = "Learning rate " + this.learningRate + " should be >= 0.0.";
            throw new IllegalArgumentException($i$a$-require-AdaGrad$32.toString());
        }
        if (!(this.initialAccumulatorValue >= 0.0f)) {
            boolean bl = false;
            String string = "Rho " + this.initialAccumulatorValue + " should be >= 0.0.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ AdaGrad(float f, float f2, ClipGradientAction clipGradientAction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.1f;
        }
        if ((n & 2) != 0) {
            f2 = 0.01f;
        }
        if ((n & 4) != 0) {
            clipGradientAction = new NoClipGradient();
        }
        this(f, f2, clipGradientAction);
    }

    public final float getLearningRate() {
        return this.learningRate;
    }

    public final float getInitialAccumulatorValue() {
        return this.initialAccumulatorValue;
    }

    @Override
    @NotNull
    protected List<Operand<Float>> applyGradients(@NotNull KGraph graph, @NotNull Ops tf, @NotNull List<Variable<Float>> weights, @NotNull Gradients gradients) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(weights, (String)"weights");
        Intrinsics.checkNotNullParameter((Object)gradients, (String)"gradients");
        List targets = new ArrayList();
        Constant constant = tf.constant((Object)Float.valueOf(this.initialAccumulatorValue), DtypeConversionUtilKt.getDType());
        Intrinsics.checkNotNullExpressionValue((Object)constant, (String)"tf.constant(initialAccumulatorValue, getDType())");
        this.initialAccumulatorValueConstant = constant;
        Constant constant2 = tf.constant((Object)Float.valueOf(this.learningRate), DtypeConversionUtilKt.getDType());
        Intrinsics.checkNotNullExpressionValue((Object)constant2, (String)"tf.constant(learningRate, getDType())");
        this.learningRateConst = constant2;
        int n = weights.size();
        for (int i = 0; i < n; ++i) {
            Variable<Float> variable = weights.get(i);
            String varName = variable.ref().op().name();
            Intrinsics.checkNotNullExpressionValue((Object)varName, (String)"varName");
            Variable<Float> slot = this.getSlot(varName, "accumulator");
            TrainOps trainOps = tf.train;
            Operand operand = (Operand)variable;
            Operand operand2 = (Operand)slot;
            Constant<Float> constant3 = this.learningRateConst;
            if (constant3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"learningRateConst");
                constant3 = null;
            }
            Operand operand3 = (Operand)constant3;
            ClipGradientAction clipGradientAction = this.getClipGradient();
            Output output = gradients.dy(i);
            Intrinsics.checkNotNullExpressionValue((Object)output, (String)"gradients.dy(i)");
            ApplyAdagrad.Options[] optionsArray = new ApplyAdagrad.Options[]{ApplyAdagrad.useLocking((Boolean)true), ApplyAdagrad.updateSlots((Boolean)true)};
            ApplyAdagrad applyAdagrad = trainOps.applyAdagrad(operand, operand2, operand3, clipGradientAction.clipGradient(tf, (Operand<Float>)((Operand)output)), optionsArray);
            Intrinsics.checkNotNullExpressionValue((Object)applyAdagrad, (String)"tf.train.applyAdagrad(\n \u2026s(true)\n                )");
            targets.add(applyAdagrad);
        }
        return targets;
    }

    private final void createAdaGradSlot(KGraph graph, Ops tf, Output<Float> v) {
        String accumInitializerName = NameConventionsKt.defaultInitializerOpName(this.createName$tensorflow(v, "accumulator"));
        Fill fill = tf.withName(accumInitializerName).fill((Operand)tf.shape((Operand)v), (Operand)tf.constant(this.initialAccumulatorValue));
        Intrinsics.checkNotNullExpressionValue((Object)fill, (String)"tf.withName(accumInitial\u2026initialAccumulatorValue))");
        Operand initializer = (Operand)fill;
        Output output = v.asOutput();
        Intrinsics.checkNotNullExpressionValue((Object)output, (String)"v.asOutput()");
        this.createSlot(graph, tf, (Output<Float>)output, "accumulator", (Operand<Float>)initializer);
    }

    @Override
    protected void createSlots(@NotNull KGraph graph, @NotNull Ops tf, @NotNull List<Output<Float>> variables2) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(variables2, (String)"variables");
        for (Output<Float> v : variables2) {
            Output output = v.asOutput();
            Intrinsics.checkNotNullExpressionValue((Object)output, (String)"v.asOutput()");
            this.createAdaGradSlot(graph, tf, (Output<Float>)output);
        }
    }

    @Override
    @NotNull
    public String getOptimizerName() {
        return "Adagrad";
    }

    @Override
    public boolean isRunningOnGPU$tensorflow() {
        return true;
    }

    public AdaGrad() {
        this(0.0f, 0.0f, null, 7, null);
    }
}

