/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.optimizer;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.KGraph;
import org.jetbrains.kotlinx.dl.api.core.optimizer.ClipGradientAction;
import org.jetbrains.kotlinx.dl.api.core.optimizer.NoClipGradient;
import org.jetbrains.kotlinx.dl.api.core.optimizer.Optimizer;
import org.jetbrains.kotlinx.dl.api.core.util.DtypeConversionUtilKt;
import org.jetbrains.kotlinx.dl.api.core.util.NameConventionsKt;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.op.Ops;
import org.tensorflow.op.TrainOps;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.Fill;
import org.tensorflow.op.core.Gradients;
import org.tensorflow.op.core.Variable;
import org.tensorflow.op.dtypes.Cast;
import org.tensorflow.op.train.ApplyAdadelta;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ@\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030!0\u001a2\u0006\u0010\"\u001a\u00020#H\u0014J&\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'H\u0002J,\u0010(\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030'0\u001aH\u0014R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\nR\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/optimizer/AdaDelta;", "Lorg/jetbrains/kotlinx/dl/api/core/optimizer/Optimizer;", "learningRate", "", "rho", "epsilon", "clipGradient", "Lorg/jetbrains/kotlinx/dl/api/core/optimizer/ClipGradientAction;", "(FFFLorg/jetbrains/kotlinx/dl/api/core/optimizer/ClipGradientAction;)V", "getEpsilon", "()F", "epsilonConstant", "Lorg/tensorflow/op/core/Constant;", "isRunningOnGPU", "", "isRunningOnGPU$tensorflow", "()Z", "getLearningRate", "learningRateConst", "optimizerName", "", "getOptimizerName", "()Ljava/lang/String;", "getRho", "rhoConst", "applyGradients", "", "Lorg/tensorflow/Operand;", "graph", "Lorg/jetbrains/kotlinx/dl/api/core/KGraph;", "tf", "Lorg/tensorflow/op/Ops;", "weights", "Lorg/tensorflow/op/core/Variable;", "gradients", "Lorg/tensorflow/op/core/Gradients;", "createAdaDeltaSlot", "", "v", "Lorg/tensorflow/Output;", "createSlots", "variables", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nAdaDelta.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdaDelta.kt\norg/jetbrains/kotlinx/dl/api/core/optimizer/AdaDelta\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
public final class AdaDelta
extends Optimizer {
    private final float learningRate;
    private final float rho;
    private final float epsilon;
    private Constant<Float> epsilonConstant;
    private Constant<Float> learningRateConst;
    private Constant<Float> rhoConst;

    public AdaDelta(float learningRate, float rho, float epsilon, @NotNull ClipGradientAction clipGradient) {
        Intrinsics.checkNotNullParameter((Object)clipGradient, (String)"clipGradient");
        super(clipGradient);
        this.learningRate = learningRate;
        this.rho = rho;
        this.epsilon = epsilon;
        if (!(this.learningRate >= 0.0f)) {
            boolean $i$a$-require-AdaDelta$42 = false;
            String $i$a$-require-AdaDelta$42 = "Learning rate " + this.learningRate + " should be >= 0.0.";
            throw new IllegalArgumentException($i$a$-require-AdaDelta$42.toString());
        }
        if (!(this.rho >= 0.0f)) {
            boolean $i$a$-require-AdaDelta$52 = false;
            String $i$a$-require-AdaDelta$52 = "Rho " + this.rho + " should be >= 0.0.";
            throw new IllegalArgumentException($i$a$-require-AdaDelta$52.toString());
        }
        if (!(this.epsilon >= 0.0f)) {
            boolean bl = false;
            String string = "Epsilon " + this.epsilon + " should be >= 0.0.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ AdaDelta(float f, float f2, float f3, ClipGradientAction clipGradientAction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.1f;
        }
        if ((n & 2) != 0) {
            f2 = 0.95f;
        }
        if ((n & 4) != 0) {
            f3 = 1.0E-8f;
        }
        if ((n & 8) != 0) {
            clipGradientAction = new NoClipGradient();
        }
        this(f, f2, f3, clipGradientAction);
    }

    public final float getLearningRate() {
        return this.learningRate;
    }

    public final float getRho() {
        return this.rho;
    }

    public final float getEpsilon() {
        return this.epsilon;
    }

    @Override
    @NotNull
    protected List<Operand<Float>> applyGradients(@NotNull KGraph graph, @NotNull Ops tf, @NotNull List<Variable<Float>> weights, @NotNull Gradients gradients) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(weights, (String)"weights");
        Intrinsics.checkNotNullParameter((Object)gradients, (String)"gradients");
        List targets = new ArrayList();
        Constant constant = tf.constant((Object)Float.valueOf(this.rho), DtypeConversionUtilKt.getDType());
        Intrinsics.checkNotNullExpressionValue((Object)constant, (String)"tf.constant(rho, getDType())");
        this.rhoConst = constant;
        Constant constant2 = tf.constant((Object)Float.valueOf(this.learningRate), DtypeConversionUtilKt.getDType());
        Intrinsics.checkNotNullExpressionValue((Object)constant2, (String)"tf.constant(learningRate, getDType())");
        this.learningRateConst = constant2;
        Constant constant3 = tf.constant((Object)Float.valueOf(this.epsilon), DtypeConversionUtilKt.getDType());
        Intrinsics.checkNotNullExpressionValue((Object)constant3, (String)"tf.constant(epsilon, getDType())");
        this.epsilonConstant = constant3;
        int n = weights.size();
        for (int i = 0; i < n; ++i) {
            Variable<Float> variable = weights.get(i);
            String varName = variable.ref().op().name();
            Intrinsics.checkNotNullExpressionValue((Object)varName, (String)"varName");
            Variable<Float> accumSlot = this.getSlot(varName, "accum");
            Variable<Float> accumUpdateSlot = this.getSlot(varName, "accum_update");
            TrainOps trainOps = tf.train;
            Operand operand = (Operand)variable;
            Operand operand2 = (Operand)accumSlot;
            Operand operand3 = (Operand)accumUpdateSlot;
            Constant<Float> constant4 = this.learningRateConst;
            if (constant4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"learningRateConst");
                constant4 = null;
            }
            Operand operand4 = (Operand)constant4;
            Constant<Float> constant5 = this.rhoConst;
            if (constant5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rhoConst");
                constant5 = null;
            }
            Operand operand5 = (Operand)constant5;
            Constant<Float> constant6 = this.epsilonConstant;
            if (constant6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"epsilonConstant");
                constant6 = null;
            }
            Operand operand6 = (Operand)constant6;
            ClipGradientAction clipGradientAction = this.getClipGradient();
            Output output = gradients.dy(i);
            Intrinsics.checkNotNullExpressionValue((Object)output, (String)"gradients.dy(i)");
            ApplyAdadelta.Options[] optionsArray = new ApplyAdadelta.Options[]{ApplyAdadelta.useLocking((Boolean)true)};
            ApplyAdadelta applyAdadelta = trainOps.applyAdadelta(operand, operand2, operand3, operand4, operand5, operand6, clipGradientAction.clipGradient(tf, (Operand<Float>)((Operand)output)), optionsArray);
            Intrinsics.checkNotNullExpressionValue((Object)applyAdadelta, (String)"tf.train.applyAdadelta(\n\u2026g(true)\n                )");
            targets.add(applyAdadelta);
        }
        return targets;
    }

    private final void createAdaDeltaSlot(KGraph graph, Ops tf, Output<Float> v) {
        String accumInitializerName = NameConventionsKt.defaultInitializerOpName(this.createName$tensorflow(v, "accum"));
        Fill accumulatorInitializer = tf.withName(accumInitializerName).fill((Operand)tf.shape((Operand)v), (Operand)tf.dtypes.cast((Operand)tf.constant(0.0f), DtypeConversionUtilKt.getDType(), new Cast.Options[0]));
        Output output = v.asOutput();
        Intrinsics.checkNotNullExpressionValue((Object)output, (String)"v.asOutput()");
        Intrinsics.checkNotNullExpressionValue((Object)accumulatorInitializer, (String)"accumulatorInitializer");
        this.createSlot(graph, tf, (Output<Float>)output, "accum", (Operand<Float>)((Operand)accumulatorInitializer));
        String accumUpdateInitializerName = NameConventionsKt.defaultInitializerOpName(this.createName$tensorflow(v, "accum_update"));
        Fill fill = tf.withName(accumUpdateInitializerName).fill((Operand)tf.shape((Operand)v), (Operand)tf.dtypes.cast((Operand)tf.constant(0.0f), DtypeConversionUtilKt.getDType(), new Cast.Options[0]));
        Intrinsics.checkNotNullExpressionValue((Object)fill, (String)"tf.withName(accumUpdateI\u2026stant(0.0f), getDType()))");
        Operand updateInitializer = (Operand)fill;
        Output output2 = v.asOutput();
        Intrinsics.checkNotNullExpressionValue((Object)output2, (String)"v.asOutput()");
        this.createSlot(graph, tf, (Output<Float>)output2, "accum_update", (Operand<Float>)updateInitializer);
    }

    @Override
    protected void createSlots(@NotNull KGraph graph, @NotNull Ops tf, @NotNull List<Output<Float>> variables2) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(variables2, (String)"variables");
        for (Output<Float> v : variables2) {
            Output output = v.asOutput();
            Intrinsics.checkNotNullExpressionValue((Object)output, (String)"v.asOutput()");
            this.createAdaDeltaSlot(graph, tf, (Output<Float>)output);
        }
    }

    @Override
    @NotNull
    public String getOptimizerName() {
        return "Adadelta";
    }

    @Override
    public boolean isRunningOnGPU$tensorflow() {
        return true;
    }

    public AdaDelta() {
        this(0.0f, 0.0f, 0.0f, null, 15, null);
    }
}

