/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.metric;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.loss.LossesKt;
import org.jetbrains.kotlinx.dl.api.core.loss.ReductionType;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Identity;
import org.tensorflow.op.core.ReduceSum;
import org.tensorflow.op.math.Mean;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u001aD\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\u000b"}, d2={"meanOfMetrics", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "reductionType", "Lorg/jetbrains/kotlinx/dl/api/core/loss/ReductionType;", "metric", "numberOfLabels", "metricName", "", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nMetric.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Metric.kt\norg/jetbrains/kotlinx/dl/api/core/metric/MetricKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public final class MetricKt {
    @NotNull
    public static final Operand<Float> meanOfMetrics(@NotNull Ops tf, @NotNull ReductionType reductionType, @NotNull Operand<Float> metric, @Nullable Operand<Float> numberOfLabels, @NotNull String metricName) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter((Object)((Object)reductionType), (String)"reductionType");
        Intrinsics.checkNotNullParameter(metric, (String)"metric");
        Intrinsics.checkNotNullParameter((Object)metricName, (String)"metricName");
        Mean.Options[] optionsArray = new Mean.Options[]{Mean.keepDims((Boolean)false)};
        Mean meanMetric = tf.math.mean(metric, (Operand)tf.constant(-1), optionsArray);
        Operand operand = (Operand)meanMetric;
        Intrinsics.checkNotNullExpressionValue((Object)meanMetric, (String)"meanMetric");
        ReduceSum.Options[] optionsArray2 = new ReduceSum.Options[]{ReduceSum.keepDims((Boolean)false)};
        ReduceSum reduceSum = tf.reduceSum(operand, LossesKt.allAxes(tf, (Operand<Float>)((Operand)meanMetric)), optionsArray2);
        Intrinsics.checkNotNullExpressionValue((Object)reduceSum, (String)"tf.reduceSum(\n        me\u2026Sum.keepDims(false)\n    )");
        Operand<Float> totalMetric = (Operand<Float>)reduceSum;
        if (reductionType == ReductionType.SUM_OVER_BATCH_SIZE) {
            if (!(numberOfLabels != null)) {
                boolean bl = false;
                String string = "Operand numberOfLosses must be not null.";
                throw new IllegalStateException(string.toString());
            }
            totalMetric = LossesKt.safeMean(tf, metric, numberOfLabels);
        }
        Identity identity = tf.withName(metricName).identity((Operand)totalMetric);
        Intrinsics.checkNotNullExpressionValue((Object)identity, (String)"tf.withName(metricName).identity(totalMetric)");
        return (Operand)identity;
    }
}

