/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.metric;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.loss.ReductionType;
import org.jetbrains.kotlinx.dl.api.core.metric.Accuracy;
import org.jetbrains.kotlinx.dl.api.core.metric.MAE;
import org.jetbrains.kotlinx.dl.api.core.metric.MSE;
import org.jetbrains.kotlinx.dl.api.core.metric.MSLE;
import org.jetbrains.kotlinx.dl.api.core.metric.Metrics;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/metric/Metric;", "", "reductionType", "Lorg/jetbrains/kotlinx/dl/api/core/loss/ReductionType;", "(Lorg/jetbrains/kotlinx/dl/api/core/loss/ReductionType;)V", "getReductionType", "()Lorg/jetbrains/kotlinx/dl/api/core/loss/ReductionType;", "apply", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "yPred", "yTrue", "numberOfLabels", "Companion", "tensorflow"})
public abstract class Metric {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReductionType reductionType;

    public Metric(@NotNull ReductionType reductionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)reductionType), (String)"reductionType");
        this.reductionType = reductionType;
    }

    @NotNull
    public final ReductionType getReductionType() {
        return this.reductionType;
    }

    @NotNull
    public abstract Operand<Float> apply(@NotNull Ops var1, @NotNull Operand<Float> var2, @NotNull Operand<Float> var3, @Nullable Operand<Float> var4);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/metric/Metric$Companion;", "", "()V", "convert", "Lorg/jetbrains/kotlinx/dl/api/core/metric/Metric;", "metricType", "Lorg/jetbrains/kotlinx/dl/api/core/metric/Metrics;", "convertBack", "metric", "tensorflow"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Metric convert(@NotNull Metrics metricType) {
            Metric metric;
            Intrinsics.checkNotNullParameter((Object)metricType, (String)"metricType");
            switch (WhenMappings.$EnumSwitchMapping$0[metricType.ordinal()]) {
                case 1: {
                    metric = new Accuracy();
                    break;
                }
                case 2: {
                    metric = new MAE(null, 1, null);
                    break;
                }
                case 3: {
                    metric = new MSE(null, 1, null);
                    break;
                }
                case 4: {
                    metric = new MSLE(null, 1, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return metric;
        }

        @NotNull
        public final Metrics convertBack(@NotNull Metric metric) {
            Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
            Metric metric2 = metric;
            return metric2 instanceof Accuracy ? Metrics.ACCURACY : (metric2 instanceof MAE ? Metrics.MAE : (metric2 instanceof MSE ? Metrics.MSE : (metric2 instanceof MSLE ? Metrics.MSLE : Metrics.ACCURACY)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Metrics.values().length];
                try {
                    nArray[Metrics.ACCURACY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Metrics.MAE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Metrics.MSE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Metrics.MSLE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

