/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.loss;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.loss.LossFunction;
import org.jetbrains.kotlinx.dl.api.core.loss.LossesKt;
import org.jetbrains.kotlinx.dl.api.core.loss.ReductionType;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.math.SquaredDifference;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/loss/MSE;", "Lorg/jetbrains/kotlinx/dl/api/core/loss/LossFunction;", "reductionType", "Lorg/jetbrains/kotlinx/dl/api/core/loss/ReductionType;", "(Lorg/jetbrains/kotlinx/dl/api/core/loss/ReductionType;)V", "apply", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "yPred", "yTrue", "numberOfLosses", "tensorflow"})
public final class MSE
extends LossFunction {
    public MSE(@NotNull ReductionType reductionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)reductionType), (String)"reductionType");
        super(reductionType);
    }

    public /* synthetic */ MSE(ReductionType reductionType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            reductionType = ReductionType.SUM_OVER_BATCH_SIZE;
        }
        this(reductionType);
    }

    @Override
    @NotNull
    public Operand<Float> apply(@NotNull Ops tf, @NotNull Operand<Float> yPred, @NotNull Operand<Float> yTrue, @Nullable Operand<Float> numberOfLosses) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(yPred, (String)"yPred");
        Intrinsics.checkNotNullParameter(yTrue, (String)"yTrue");
        SquaredDifference squaredError = tf.math.squaredDifference(yPred, yTrue);
        ReductionType reductionType = this.getReductionType();
        Intrinsics.checkNotNullExpressionValue((Object)squaredError, (String)"squaredError");
        return LossesKt.meanOfLosses(tf, reductionType, (Operand<Float>)((Operand)squaredError), numberOfLosses);
    }

    public MSE() {
        this(null, 1, null);
    }
}

