/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.reshaping;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.layer.reshaping.AbstractZeroPadding;
import org.tensorflow.Shape;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B/\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\n\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a2\u0006\u0002\u0010\u0012J+\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/reshaping/ZeroPadding2D;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/reshaping/AbstractZeroPadding;", "padding", "", "dataFormat", "", "name", "(ILjava/lang/String;Ljava/lang/String;)V", "Lkotlin/Pair;", "(Lkotlin/Pair;Ljava/lang/String;Ljava/lang/String;)V", "", "([ILjava/lang/String;Ljava/lang/String;)V", "getPadding", "()[I", "paddingArrayToTfFormat", "", "inputShape", "Lorg/tensorflow/Shape;", "(Lorg/tensorflow/Shape;)[[I", "paddingArraysToInputShape", "paddingFirstDim", "paddingSecondDim", "(Lorg/tensorflow/Shape;[I[I)[[I", "toString", "tensorflow"})
public final class ZeroPadding2D
extends AbstractZeroPadding {
    @NotNull
    private final int[] padding;
    @NotNull
    private final String dataFormat;

    @NotNull
    public final int[] getPadding() {
        return this.padding;
    }

    public ZeroPadding2D(int padding, @Nullable String dataFormat, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int n = 0;
        int[] nArray = new int[4];
        ZeroPadding2D zeroPadding2D = this;
        while (n < 4) {
            int n2 = n++;
            nArray[n2] = padding;
        }
        zeroPadding2D(nArray, dataFormat, name);
    }

    public /* synthetic */ ZeroPadding2D(int n, String string, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        this(n, string, string2);
    }

    public ZeroPadding2D(@NotNull Pair<Integer, Integer> padding, @Nullable String dataFormat, @NotNull String name) {
        Intrinsics.checkNotNullParameter(padding, (String)"padding");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int[] nArray = new int[]{((Number)padding.getFirst()).intValue(), ((Number)padding.getFirst()).intValue(), ((Number)padding.getSecond()).intValue(), ((Number)padding.getSecond()).intValue()};
        this(nArray, dataFormat, name);
    }

    public /* synthetic */ ZeroPadding2D(Pair pair, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        this((Pair<Integer, Integer>)pair, string, string2);
    }

    public ZeroPadding2D(@NotNull int[] padding, @Nullable String dataFormat, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        if (!(padding.length == 4)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.padding = padding;
        String string = dataFormat;
        if (string == null) {
            string = "channels_last";
        }
        this.dataFormat = string;
    }

    public /* synthetic */ ZeroPadding2D(int[] nArray, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        this(nArray, string, string2);
    }

    @Override
    @NotNull
    protected int[][] paddingArrayToTfFormat(@NotNull Shape inputShape) {
        Intrinsics.checkNotNullParameter((Object)inputShape, (String)"inputShape");
        int[] paddingFirstDim = null;
        int[] paddingSecondDim = null;
        switch (this.padding.length) {
            case 4: {
                int[] nArray = new int[]{this.padding[0], this.padding[1]};
                paddingFirstDim = nArray;
                nArray = new int[]{this.padding[2], this.padding[3]};
                paddingSecondDim = nArray;
                break;
            }
            case 2: {
                int[] nArray = new int[]{this.padding[0], this.padding[0]};
                paddingFirstDim = nArray;
                nArray = new int[]{this.padding[1], this.padding[1]};
                paddingSecondDim = nArray;
                break;
            }
            case 1: {
                int[] nArray = new int[]{this.padding[0], this.padding[0]};
                paddingFirstDim = nArray;
                nArray = new int[]{this.padding[0], this.padding[0]};
                paddingSecondDim = nArray;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid padding argument at layer " + this.getName() + '.');
            }
        }
        return this.paddingArraysToInputShape(inputShape, paddingFirstDim, paddingSecondDim);
    }

    private final int[][] paddingArraysToInputShape(Shape inputShape, int[] paddingFirstDim, int[] paddingSecondDim) {
        int[][] nArrayArray;
        switch (inputShape.numDimensions()) {
            case 4: {
                if (Intrinsics.areEqual((Object)this.dataFormat, (Object)"channels_first")) {
                    int[][] nArrayArray2 = new int[4][];
                    int[] nArray = new int[]{0, 0};
                    nArrayArray2[0] = nArray;
                    nArray = new int[]{0, 0};
                    nArrayArray2[1] = nArray;
                    nArrayArray2[2] = paddingFirstDim;
                    nArrayArray2[3] = paddingSecondDim;
                    nArrayArray = nArrayArray2;
                    break;
                }
                int[][] nArrayArray3 = new int[4][];
                int[] nArray = new int[]{0, 0};
                nArrayArray3[0] = nArray;
                nArrayArray3[1] = paddingFirstDim;
                nArrayArray3[2] = paddingSecondDim;
                nArray = new int[]{0, 0};
                nArrayArray3[3] = nArray;
                nArrayArray = nArrayArray3;
                break;
            }
            case 3: {
                if (Intrinsics.areEqual((Object)this.dataFormat, (Object)"channels_first")) {
                    int[][] nArrayArray4 = new int[3][];
                    int[] nArray = new int[]{0, 0};
                    nArrayArray4[0] = nArray;
                    nArrayArray4[1] = paddingFirstDim;
                    nArrayArray4[2] = paddingSecondDim;
                    nArrayArray = nArrayArray4;
                    break;
                }
                int[][] nArrayArray5 = new int[3][];
                nArrayArray5[0] = paddingFirstDim;
                nArrayArray5[1] = paddingSecondDim;
                int[] nArray = new int[]{0, 0};
                nArrayArray5[2] = nArray;
                nArrayArray = nArrayArray5;
                break;
            }
            case 2: {
                int[][] nArrayArray6 = new int[][]{paddingFirstDim, paddingSecondDim};
                nArrayArray = nArrayArray6;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid input shape " + inputShape + '.');
            }
        }
        return nArrayArray;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("ZeroPadding2D(name = ").append(this.getName()).append(", padding=");
        String string = Arrays.toString(this.padding);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
        return stringBuilder.append(string).append(", hasActivation=").append(this.getHasActivation()).append(')').toString();
    }
}

