/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.reshaping;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.layer.reshaping.AbstractUpSampling;
import org.jetbrains.kotlinx.dl.api.core.layer.reshaping.AbstractUpSamplingKt;
import org.jetbrains.kotlinx.dl.api.core.layer.reshaping.InterpolationMethod;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0005H\u0016J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/reshaping/UpSampling3D;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/reshaping/AbstractUpSampling;", "size", "", "name", "", "([ILjava/lang/String;)V", "getSize", "()[I", "toString", "upSample", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "input", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nUpSampling3D.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpSampling3D.kt\norg/jetbrains/kotlinx/dl/api/core/layer/reshaping/UpSampling3D\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,58:1\n12583#2,2:59\n*S KotlinDebug\n*F\n+ 1 UpSampling3D.kt\norg/jetbrains/kotlinx/dl/api/core/layer/reshaping/UpSampling3D\n*L\n38#1:59,2\n*E\n"})
public final class UpSampling3D
extends AbstractUpSampling {
    @NotNull
    private final int[] size;

    public UpSampling3D(@NotNull int[] size, @NotNull String name) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(size, InterpolationMethod.NEAREST, name);
            this.size = size;
            if (!(this.size.length == 3)) {
                boolean $i$a$-require-UpSampling3D$22 = false;
                String $i$a$-require-UpSampling3D$22 = "The upsampling size should be an array of three elements.";
                throw new IllegalArgumentException($i$a$-require-UpSampling3D$22.toString());
            }
            int[] $this$all$iv = this.size;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                int element$iv;
                int it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (it > 0) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "All the upsampling size factors should be positive integers.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ UpSampling3D(int[] nArray, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            int[] nArray2 = new int[]{2, 2, 2};
            nArray = nArray2;
        }
        if ((n & 2) != 0) {
            string = "";
        }
        this(nArray, string);
    }

    @NotNull
    public final int[] getSize() {
        return this.size;
    }

    @Override
    @NotNull
    protected Operand<Float> upSample(@NotNull Ops tf, @NotNull Operand<Float> input) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Operand<Float> upSampled = null;
        upSampled = input;
        int n = 3;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            if (this.size[it] <= 1) continue;
            upSampled = AbstractUpSamplingKt.repeat(tf, upSampled, this.size[it], it + 1);
        }
        return upSampled;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("UpSampling3D(name = ").append(this.getName()).append(", size=");
        String string = Arrays.toString(this.size);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
        return stringBuilder.append(string).append(", hasActivation=").append(this.getHasActivation()).append(')').toString();
    }

    public UpSampling3D() {
        this(null, null, 3, null);
    }
}

