/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.reshaping;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.layer.reshaping.AbstractUpSampling;
import org.jetbrains.kotlinx.dl.api.core.layer.reshaping.InterpolationMethod;
import org.tensorflow.Operand;
import org.tensorflow.Shape;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.image.ResizeBilinear;
import org.tensorflow.op.image.ResizeNearestNeighbor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u0007H\u0016J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/reshaping/UpSampling2D;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/reshaping/AbstractUpSampling;", "size", "", "interpolation", "Lorg/jetbrains/kotlinx/dl/api/core/layer/reshaping/InterpolationMethod;", "name", "", "([ILorg/jetbrains/kotlinx/dl/api/core/layer/reshaping/InterpolationMethod;Ljava/lang/String;)V", "getInterpolation", "()Lorg/jetbrains/kotlinx/dl/api/core/layer/reshaping/InterpolationMethod;", "getSize", "()[I", "toString", "upSample", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "input", "tensorflow"})
public final class UpSampling2D
extends AbstractUpSampling {
    @NotNull
    private final int[] size;
    @NotNull
    private final InterpolationMethod interpolation;

    public UpSampling2D(@NotNull int[] size, @NotNull InterpolationMethod interpolation, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)((Object)interpolation), (String)"interpolation");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(size, interpolation, name);
        this.size = size;
        this.interpolation = interpolation;
        if (!(this.size.length == 2)) {
            boolean $i$a$-require-UpSampling2D$42 = false;
            String $i$a$-require-UpSampling2D$42 = "The upsampling size factor should be an array of two elements.";
            throw new IllegalArgumentException($i$a$-require-UpSampling2D$42.toString());
        }
        if (!(this.size[0] > 0 && this.size[1] > 0)) {
            boolean $i$a$-require-UpSampling2D$52 = false;
            String $i$a$-require-UpSampling2D$52 = "All the upsampling size factors should be positive integers.";
            throw new IllegalArgumentException($i$a$-require-UpSampling2D$52.toString());
        }
        if (!(this.interpolation == InterpolationMethod.NEAREST || this.interpolation == InterpolationMethod.BILINEAR)) {
            boolean bl = false;
            String string = "The interpolation method should be either of `InterpolationMethod.NEAREST` or `InterpolationMethod.BILINEAR`.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ UpSampling2D(int[] nArray, InterpolationMethod interpolationMethod, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            int[] nArray2 = new int[]{2, 2};
            nArray = nArray2;
        }
        if ((n & 2) != 0) {
            interpolationMethod = InterpolationMethod.NEAREST;
        }
        if ((n & 4) != 0) {
            string = "";
        }
        this(nArray, interpolationMethod, string);
    }

    @NotNull
    public final int[] getSize() {
        return this.size;
    }

    @NotNull
    public final InterpolationMethod getInterpolation() {
        return this.interpolation;
    }

    @Override
    @NotNull
    protected Operand<Float> upSample(@NotNull Ops tf, @NotNull Operand<Float> input) {
        Operand operand;
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Shape inputShape = input.asOutput().shape();
        int[] nArray = new int[]{(int)inputShape.size(1) * this.size[0], (int)inputShape.size(2) * this.size[1]};
        Constant newSize = tf.constant(nArray);
        switch (WhenMappings.$EnumSwitchMapping$0[this.interpolation.ordinal()]) {
            case 1: {
                ResizeNearestNeighbor resizeNearestNeighbor = tf.image.resizeNearestNeighbor(input, (Operand)newSize, new ResizeNearestNeighbor.Options[0]);
                Intrinsics.checkNotNullExpressionValue((Object)resizeNearestNeighbor, (String)"tf.image.resizeNearestNeighbor(input, newSize)");
                operand = (Operand)resizeNearestNeighbor;
                break;
            }
            case 2: {
                ResizeBilinear.Options[] optionsArray = new ResizeBilinear.Options[]{ResizeBilinear.halfPixelCenters((Boolean)true)};
                ResizeBilinear resizeBilinear = tf.image.resizeBilinear(input, (Operand)newSize, optionsArray);
                Intrinsics.checkNotNullExpressionValue((Object)resizeBilinear, (String)"tf.image.resizeBilinear(\u2026nters(true)\n            )");
                operand = (Operand)resizeBilinear;
                break;
            }
            default: {
                throw new IllegalArgumentException("The interpolation type interpolation is not supported.");
            }
        }
        return operand;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("UpSampling2D(name = ").append(this.getName()).append(", size=");
        String string = Arrays.toString(this.size);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
        return stringBuilder.append(string).append(", interpolation=").append((Object)this.interpolation).append(", hasActivation=").append(this.getHasActivation()).append(')').toString();
    }

    public UpSampling2D() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InterpolationMethod.values().length];
            try {
                nArray[InterpolationMethod.NEAREST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InterpolationMethod.BILINEAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

