/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.reshaping;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.layer.reshaping.AbstractUpSampling;
import org.jetbrains.kotlinx.dl.api.core.layer.reshaping.AbstractUpSamplingKt;
import org.jetbrains.kotlinx.dl.api.core.layer.reshaping.InterpolationMethod;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0005H\u0016J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/reshaping/UpSampling1D;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/reshaping/AbstractUpSampling;", "size", "", "name", "", "(ILjava/lang/String;)V", "getSize", "()I", "toString", "upSample", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "input", "tensorflow"})
public final class UpSampling1D
extends AbstractUpSampling {
    private final int size;

    public UpSampling1D(int size, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int[] nArray = new int[]{size};
        super(nArray, InterpolationMethod.NEAREST, name);
        this.size = size;
        if (!(this.size > 0)) {
            boolean bl = false;
            String string = "The upsampling size should be a positive integer.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ UpSampling1D(int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        if ((n2 & 2) != 0) {
            string = "";
        }
        this(n, string);
    }

    public final int getSize() {
        return this.size;
    }

    @Override
    @NotNull
    protected Operand<Float> upSample(@NotNull Ops tf, @NotNull Operand<Float> input) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        return AbstractUpSamplingKt.repeat(tf, input, this.size, 1);
    }

    @NotNull
    public String toString() {
        return "UpSampling1D(name = " + this.getName() + ", size=" + this.size + ", hasActivation=" + this.getHasActivation() + ')';
    }

    public UpSampling1D() {
        this(0, null, 3, null);
    }
}

