/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.reshaping;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.layer.Layer;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.ExpandDims;
import org.tensorflow.op.core.Stack;
import org.tensorflow.op.core.Tile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JB\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/reshaping/RepeatVector;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;", "n", "", "name", "", "(ILjava/lang/String;)V", "hasActivation", "", "getHasActivation", "()Z", "getN", "()I", "build", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "input", "isTraining", "numberOfLosses", "toString", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nRepeatVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepeatVector.kt\norg/jetbrains/kotlinx/dl/api/core/layer/reshaping/RepeatVector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class RepeatVector
extends Layer {
    private final int n;

    public RepeatVector(int n, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.n = n;
        if (!(this.n >= 1)) {
            boolean bl = false;
            String string = "Number of repetitions (n) in RepeatVector should be positive but got " + this.n;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ RepeatVector(int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = "";
        }
        this(n, string);
    }

    public final int getN() {
        return this.n;
    }

    @Override
    @NotNull
    public Operand<Float> build(@NotNull Ops tf, @NotNull Operand<Float> input, @NotNull Operand<Boolean> isTraining, @Nullable Operand<Float> numberOfLosses) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter(isTraining, (String)"isTraining");
        ExpandDims x = tf.expandDims(input, (Operand)tf.constant(1));
        Object[] objectArray = new Constant[]{tf.constant(1), tf.constant(this.n), tf.constant(1)};
        Stack pattern = tf.stack((Iterable)CollectionsKt.listOf((Object[])objectArray), new Stack.Options[0]);
        Tile tile = tf.tile((Operand)x, (Operand)pattern);
        Intrinsics.checkNotNullExpressionValue((Object)tile, (String)"tf.tile(x, pattern)");
        return (Operand)tile;
    }

    @NotNull
    public String toString() {
        return "RepeatVector(name = " + this.getName() + ", n=" + this.n + ", hasActivation=" + this.getHasActivation() + ')';
    }

    @Override
    public boolean getHasActivation() {
        return false;
    }
}

