/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.reshaping;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.layer.Layer;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.linalg.Transpose;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JB\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/reshaping/Permute;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;", "dims", "", "name", "", "([ILjava/lang/String;)V", "getDims", "()[I", "hasActivation", "", "getHasActivation", "()Z", "build", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "input", "isTraining", "numberOfLosses", "toString", "tensorflow"})
public final class Permute
extends Layer {
    @NotNull
    private final int[] dims;

    public Permute(@NotNull int[] dims, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)dims, (String)"dims");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.dims = dims;
        if (!Intrinsics.areEqual((Object)ArraysKt.sorted((int[])this.dims), (Object)CollectionsKt.toList((Iterable)((Iterable)new IntRange(1, this.dims.length))))) {
            boolean bl = false;
            String string = "The values in dims should be consecutive and start from 1.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Permute(int[] nArray, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(nArray, string);
    }

    @NotNull
    public final int[] getDims() {
        return this.dims;
    }

    @Override
    @NotNull
    public Operand<Float> build(@NotNull Ops tf, @NotNull Operand<Float> input, @NotNull Operand<Boolean> isTraining, @Nullable Operand<Float> numberOfLosses) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter(isTraining, (String)"isTraining");
        int[] nArray = new int[]{0};
        int[] permArray = ArraysKt.plus((int[])nArray, (int[])this.dims);
        Constant perm = tf.constant(permArray);
        Transpose transpose = tf.linalg.transpose(input, (Operand)perm);
        Intrinsics.checkNotNullExpressionValue((Object)transpose, (String)"tf.linalg.transpose(input, perm)");
        return (Operand)transpose;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Permute(name = ").append(this.getName()).append(", dims=");
        String string = Arrays.toString(this.dims);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
        return stringBuilder.append(string).append(", hasActivation=").append(this.getHasActivation()).append(')').toString();
    }

    @Override
    public boolean getHasActivation() {
        return false;
    }
}

