/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.reshaping;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.layer.reshaping.AbstractCropping;
import org.tensorflow.Operand;
import org.tensorflow.Shape;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Slice;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J\b\u0010\u0011\u001a\u00020\u0006H\u0016R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/reshaping/Cropping3D;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/reshaping/AbstractCropping;", "cropping", "", "", "name", "", "([[ILjava/lang/String;)V", "getCropping", "()[[I", "[[I", "crop", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "input", "toString", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nCropping3D.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cropping3D.kt\norg/jetbrains/kotlinx/dl/api/core/layer/reshaping/Cropping3D\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,67:1\n12541#2,2:68\n*S KotlinDebug\n*F\n+ 1 Cropping3D.kt\norg/jetbrains/kotlinx/dl/api/core/layer/reshaping/Cropping3D\n*L\n36#1:68,2\n*E\n"})
public final class Cropping3D
extends AbstractCropping {
    @NotNull
    private final int[][] cropping;

    public Cropping3D(@NotNull int[][] cropping, @NotNull String name) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)cropping, (String)"cropping");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(cropping, name);
            this.cropping = cropping;
            if (!(((Object[])this.cropping).length == 3)) {
                boolean $i$a$-require-Cropping3D$22 = false;
                String $i$a$-require-Cropping3D$22 = "The cropping should be an array of size 3.";
                throw new IllegalArgumentException($i$a$-require-Cropping3D$22.toString());
            }
            Object[] $this$all$iv = (Object[])this.cropping;
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                int[] it = (int[])element$iv;
                boolean bl2 = false;
                if (it.length == 2) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "All elements of cropping should be arrays of size 2.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Cropping3D(int[][] nArray, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(nArray, string);
    }

    @NotNull
    public final int[][] getCropping() {
        return this.cropping;
    }

    @Override
    @NotNull
    protected Operand<Float> crop(@NotNull Ops tf, @NotNull Operand<Float> input) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Shape inputShape = input.asOutput().shape();
        int[] nArray = new int[]{(int)inputShape.size(1) - this.cropping[0][0] - this.cropping[0][1], (int)inputShape.size(2) - this.cropping[1][0] - this.cropping[1][1], (int)inputShape.size(3) - this.cropping[2][0] - this.cropping[2][1]};
        int[] cropSize = nArray;
        int[] nArray2 = new int[]{0, this.cropping[0][0], this.cropping[1][0], this.cropping[2][0], 0};
        Operand operand = (Operand)tf.constant(nArray2);
        nArray2 = new int[]{(int)inputShape.size(0), cropSize[0], cropSize[1], cropSize[2], (int)inputShape.size(4)};
        Slice slice = tf.slice(input, operand, (Operand)tf.constant(nArray2));
        Intrinsics.checkNotNullExpressionValue((Object)slice, (String)"tf.slice(\n            in\u2026)\n            )\n        )");
        return (Operand)slice;
    }

    @NotNull
    public String toString() {
        Object[] objectArray = (Object[])this.cropping;
        return "Cropping3D(name = " + this.getName() + ", cropping=" + ArraysKt.contentDeepToString((Object[])objectArray) + ", hasActivation=" + this.getHasActivation() + ')';
    }
}

