/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.reshaping;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.layer.reshaping.AbstractCropping;
import org.tensorflow.Operand;
import org.tensorflow.Shape;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Slice;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014J\b\u0010\u000f\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/reshaping/Cropping1D;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/reshaping/AbstractCropping;", "cropping", "", "name", "", "([ILjava/lang/String;)V", "getCropping", "()[I", "crop", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "input", "toString", "tensorflow"})
public final class Cropping1D
extends AbstractCropping {
    @NotNull
    private final int[] cropping;

    public Cropping1D(@NotNull int[] cropping, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)cropping, (String)"cropping");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int n = 0;
        int[][] nArrayArray = new int[1][];
        Cropping1D cropping1D = this;
        while (n < 1) {
            int n2 = n++;
            nArrayArray[n2] = cropping;
        }
        super(nArrayArray, name);
        this.cropping = cropping;
        if (!(this.cropping.length == 2)) {
            boolean bl = false;
            String string = "The cropping should be an array of size 2.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Cropping1D(int[] nArray, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(nArray, string);
    }

    @NotNull
    public final int[] getCropping() {
        return this.cropping;
    }

    @Override
    @NotNull
    protected Operand<Float> crop(@NotNull Ops tf, @NotNull Operand<Float> input) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Shape inputShape = input.asOutput().shape();
        long cropSize = inputShape.size(1) - (long)this.cropping[0] - (long)this.cropping[1];
        int[] nArray = new int[]{0, this.cropping[0], 0};
        Operand operand = (Operand)tf.constant(nArray);
        nArray = new int[]{(int)inputShape.size(0), (int)cropSize, (int)inputShape.size(2)};
        Slice slice = tf.slice(input, operand, (Operand)tf.constant(nArray));
        Intrinsics.checkNotNullExpressionValue((Object)slice, (String)"tf.slice(\n            in\u2026)\n            )\n        )");
        return (Operand)slice;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Cropping1D(name = ").append(this.getName()).append(", cropping=");
        String string = Arrays.toString(this.cropping);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
        return stringBuilder.append(string).append(", hasActivation=").append(this.getHasActivation()).append(')').toString();
    }
}

