/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.reshaping;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.layer.Layer;
import org.tensorflow.Operand;
import org.tensorflow.Shape;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.Pad;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0016J\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H$\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/reshaping/AbstractZeroPadding;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;", "name", "", "(Ljava/lang/String;)V", "hasActivation", "", "getHasActivation", "()Z", "build", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "input", "isTraining", "numberOfLosses", "paddingArrayToTfFormat", "", "", "inputShape", "Lorg/tensorflow/Shape;", "(Lorg/tensorflow/Shape;)[[I", "tensorflow"})
public abstract class AbstractZeroPadding
extends Layer {
    public AbstractZeroPadding(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
    }

    @Override
    public boolean getHasActivation() {
        return false;
    }

    @Override
    @NotNull
    public Operand<Float> build(@NotNull Ops tf, @NotNull Operand<Float> input, @NotNull Operand<Boolean> isTraining, @Nullable Operand<Float> numberOfLosses) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter(isTraining, (String)"isTraining");
        Shape inputShape = input.asOutput().shape();
        Intrinsics.checkNotNullExpressionValue((Object)inputShape, (String)"inputShape");
        Constant paddingOperand = tf.constant(this.paddingArrayToTfFormat(inputShape));
        Constant constantValue = tf.constant(0.0f);
        Pad pad = tf.pad(input, (Operand)paddingOperand, (Operand)constantValue);
        Intrinsics.checkNotNullExpressionValue((Object)pad, (String)"tf.pad(input, paddingOperand, constantValue)");
        return (Operand)pad;
    }

    @NotNull
    protected abstract int[][] paddingArrayToTfFormat(@NotNull Shape var1);
}

