/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.pooling;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.layer.Layer;
import org.jetbrains.kotlinx.dl.api.core.layer.convolutional.ConvPadding;
import org.tensorflow.Operand;
import org.tensorflow.op.NnOps;
import org.tensorflow.op.Ops;
import org.tensorflow.op.nn.MaxPool3d;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B/\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\n\u0012\b\b\u0002\u0010\u0004\u001a\u00020\n\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJB\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u00192\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019H\u0016J\b\u0010 \u001a\u00020\bH\u0016R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0002\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0004\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0015\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/pooling/MaxPool3D;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;", "poolSize", "", "strides", "padding", "Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvPadding;", "name", "", "(IILorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvPadding;Ljava/lang/String;)V", "", "([I[ILorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvPadding;Ljava/lang/String;)V", "hasActivation", "", "getHasActivation", "()Z", "getPadding", "()Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvPadding;", "getPoolSize", "()[I", "setPoolSize", "([I)V", "getStrides", "setStrides", "build", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "input", "isTraining", "numberOfLosses", "toString", "tensorflow"})
public final class MaxPool3D
extends Layer {
    @NotNull
    private int[] poolSize;
    @NotNull
    private int[] strides;
    @NotNull
    private final ConvPadding padding;

    public MaxPool3D(@NotNull int[] poolSize, @NotNull int[] strides, @NotNull ConvPadding padding, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)poolSize, (String)"poolSize");
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        Intrinsics.checkNotNullParameter((Object)((Object)padding), (String)"padding");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.poolSize = poolSize;
        this.strides = strides;
        this.padding = padding;
    }

    public /* synthetic */ MaxPool3D(int[] nArray, int[] nArray2, ConvPadding convPadding, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        int[] nArray3;
        if ((n & 1) != 0) {
            nArray3 = new int[]{1, 2, 2, 2, 1};
            nArray = nArray3;
        }
        if ((n & 2) != 0) {
            nArray3 = new int[]{1, 2, 2, 2, 1};
            nArray2 = nArray3;
        }
        if ((n & 4) != 0) {
            convPadding = ConvPadding.VALID;
        }
        if ((n & 8) != 0) {
            string = "";
        }
        this(nArray, nArray2, convPadding, string);
    }

    @NotNull
    public final int[] getPoolSize() {
        return this.poolSize;
    }

    public final void setPoolSize(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.poolSize = nArray;
    }

    @NotNull
    public final int[] getStrides() {
        return this.strides;
    }

    public final void setStrides(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.strides = nArray;
    }

    @NotNull
    public final ConvPadding getPadding() {
        return this.padding;
    }

    public MaxPool3D(int poolSize, int strides, @NotNull ConvPadding padding, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)((Object)padding), (String)"padding");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int[] nArray = new int[]{1, poolSize, poolSize, poolSize, 1};
        int[] nArray2 = nArray;
        nArray = new int[]{1, strides, strides, strides, 1};
        this(nArray2, nArray, padding, name);
    }

    public /* synthetic */ MaxPool3D(int n, int n2, ConvPadding convPadding, String string, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 2;
        }
        if ((n3 & 2) != 0) {
            n2 = 2;
        }
        if ((n3 & 4) != 0) {
            convPadding = ConvPadding.VALID;
        }
        if ((n3 & 8) != 0) {
            string = "";
        }
        this(n, n2, convPadding, string);
    }

    @Override
    @NotNull
    public Operand<Float> build(@NotNull Ops tf, @NotNull Operand<Float> input, @NotNull Operand<Boolean> isTraining, @Nullable Operand<Float> numberOfLosses) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter(isTraining, (String)"isTraining");
        String paddingName = this.padding.getPaddingName$tensorflow();
        long[] tfPoolSize = Arrays.stream(this.poolSize).asLongStream().toArray();
        long[] tfStrides = Arrays.stream(this.strides).asLongStream().toArray();
        Operand<Float> tfInput = input;
        NnOps nnOps = tf.nn;
        Intrinsics.checkNotNullExpressionValue((Object)tfPoolSize, (String)"tfPoolSize");
        List list = ArraysKt.toList((long[])tfPoolSize);
        Intrinsics.checkNotNullExpressionValue((Object)tfStrides, (String)"tfStrides");
        MaxPool3d maxPool3d = nnOps.maxPool3d(tfInput, list, ArraysKt.toList((long[])tfStrides), paddingName, new MaxPool3d.Options[0]);
        Intrinsics.checkNotNullExpressionValue((Object)maxPool3d, (String)"tf.nn.maxPool3d(tfInput,\u2026es.toList(), paddingName)");
        return (Operand)maxPool3d;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("MaxPool3D(name = ").append(this.getName()).append(", poolSize=");
        String string = Arrays.toString(this.poolSize);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
        StringBuilder stringBuilder2 = stringBuilder.append(string).append(", strides=");
        String string2 = Arrays.toString(this.strides);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
        return stringBuilder2.append(string2).append(", padding=").append((Object)this.padding).append(", hasActivation=").append(this.getHasActivation()).append(')').toString();
    }

    @Override
    public boolean getHasActivation() {
        return false;
    }

    public MaxPool3D() {
        this(null, null, null, null, 15, null);
    }
}

