/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.merge;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.layer.NoGradients;
import org.jetbrains.kotlinx.dl.api.core.layer.merge.AbstractMerge;
import org.jetbrains.kotlinx.dl.api.core.shape.ShapeFunctionsKt;
import org.jetbrains.kotlinx.dl.api.core.shape.TensorShape;
import org.tensorflow.Operand;
import org.tensorflow.Shape;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Concat;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0006H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/merge/Concatenate;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/merge/AbstractMerge;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/NoGradients;", "axis", "", "name", "", "(ILjava/lang/String;)V", "getAxis", "()I", "setAxis", "(I)V", "checkInputShapes", "", "inputShapes", "", "Lorg/tensorflow/Shape;", "mergeFunction", "Lorg/tensorflow/Operand;", "", "input", "tf", "Lorg/tensorflow/op/Ops;", "toString", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nConcatenate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Concatenate.kt\norg/jetbrains/kotlinx/dl/api/core/layer/merge/Concatenate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
public final class Concatenate
extends AbstractMerge
implements NoGradients {
    private int axis;

    public Concatenate(int axis, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super("ConcatenateLayer", name);
        this.axis = axis;
    }

    public /* synthetic */ Concatenate(int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        if ((n2 & 2) != 0) {
            string = "";
        }
        this(n, string);
    }

    public final int getAxis() {
        return this.axis;
    }

    public final void setAxis(int n) {
        this.axis = n;
    }

    @Override
    protected void checkInputShapes(@NotNull List<Shape> inputShapes) {
        Intrinsics.checkNotNullParameter(inputShapes, (String)"inputShapes");
        if (!(inputShapes.size() > 1)) {
            boolean bl = false;
            String string = "The number of input layers should be more than 1.";
            throw new IllegalArgumentException(string.toString());
        }
        TensorShape firstInputShape = ShapeFunctionsKt.toTensorShape((Shape)CollectionsKt.first(inputShapes));
        Iterator<Shape> iterator = inputShapes.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            Shape inputShape = iterator.next();
            TensorShape currentInputShape = ShapeFunctionsKt.toTensorShape(inputShape);
            if (firstInputShape.almostEqual(currentInputShape, this.axis)) continue;
            boolean bl = false;
            String string = "A Concatenate layer requires inputs with matching shapes except for the concat axis " + this.axis + ". But shapes are the following: shape of first input is " + firstInputShape + " and shape at index " + index + " is " + currentInputShape + '.';
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    protected Operand<Float> mergeFunction(@NotNull List<? extends Operand<Float>> input, @NotNull Ops tf) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Concat concat = tf.concat((Iterable)input, (Operand)tf.constant(this.axis));
        Intrinsics.checkNotNullExpressionValue((Object)concat, (String)"tf.concat(input, tf.constant(axis))");
        return (Operand)concat;
    }

    @NotNull
    public String toString() {
        return "Concatenate(name = " + this.getName() + ", axis=" + this.axis + ')';
    }

    public Concatenate() {
        this(0, null, 3, null);
    }
}

