/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.core;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.layer.Layer;
import org.jetbrains.kotlinx.dl.api.core.util.DtypeConversionUtilKt;
import org.tensorflow.Operand;
import org.tensorflow.Shape;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Placeholder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00020\u0003\"\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0019\u001a\u00020\u001aJB\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001b2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001b2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u001bH\u0016J\b\u0010\u001e\u001a\u00020\u0006H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/core/Input;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;", "dims", "", "", "name", "", "([JLjava/lang/String;)V", "hasActivation", "", "getHasActivation", "()Z", "input", "Lorg/tensorflow/op/core/Placeholder;", "", "getInput", "()Lorg/tensorflow/op/core/Placeholder;", "setInput", "(Lorg/tensorflow/op/core/Placeholder;)V", "packedDims", "getPackedDims", "()[J", "setPackedDims", "([J)V", "build", "tf", "Lorg/tensorflow/op/Ops;", "Lorg/tensorflow/Operand;", "isTraining", "numberOfLosses", "toString", "tensorflow"})
public final class Input
extends Layer {
    public Placeholder<Float> input;
    @NotNull
    private long[] packedDims;

    public Input(@NotNull long[] dims, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)dims, (String)"dims");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.packedDims = dims;
    }

    public /* synthetic */ Input(long[] lArray, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(lArray, string);
    }

    @NotNull
    public final Placeholder<Float> getInput() {
        Placeholder<Float> placeholder = this.input;
        if (placeholder != null) {
            return placeholder;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"input");
        return null;
    }

    public final void setInput(@NotNull Placeholder<Float> placeholder) {
        Intrinsics.checkNotNullParameter(placeholder, (String)"<set-?>");
        this.input = placeholder;
    }

    @NotNull
    public final long[] getPackedDims() {
        return this.packedDims;
    }

    public final void setPackedDims(@NotNull long[] lArray) {
        Intrinsics.checkNotNullParameter((Object)lArray, (String)"<set-?>");
        this.packedDims = lArray;
    }

    @Override
    @NotNull
    public Operand<Float> build(@NotNull Ops tf, @NotNull Operand<Float> input, @NotNull Operand<Boolean> isTraining, @Nullable Operand<Float> numberOfLosses) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter(isTraining, (String)"isTraining");
        return (Operand)this.build(tf);
    }

    @NotNull
    public final Placeholder<Float> build(@NotNull Ops tf) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Placeholder.Options[] optionsArray = new Placeholder.Options[1];
        long[] lArray = this.packedDims;
        optionsArray[0] = Placeholder.shape((Shape)Shape.make((long)-1L, (long[])Arrays.copyOf(lArray, lArray.length)));
        Placeholder placeholder = tf.withName("default_data_placeholder").placeholder(DtypeConversionUtilKt.getDType(), optionsArray);
        Intrinsics.checkNotNullExpressionValue((Object)placeholder, (String)"tf.withName(DATA_PLACEHO\u2026, *packedDims))\n        )");
        this.setInput((Placeholder<Float>)placeholder);
        return this.getInput();
    }

    @Override
    public boolean getHasActivation() {
        return false;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Input(name = ").append(this.getName()).append(", shape=");
        String string = Arrays.toString(this.packedDims);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
        return stringBuilder.append(string).append(')').toString();
    }
}

