/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.core;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.activation.Activation;
import org.jetbrains.kotlinx.dl.api.core.activation.Activations;
import org.jetbrains.kotlinx.dl.api.core.initializer.HeNormal;
import org.jetbrains.kotlinx.dl.api.core.initializer.HeUniform;
import org.jetbrains.kotlinx.dl.api.core.initializer.Initializer;
import org.jetbrains.kotlinx.dl.api.core.layer.KVariable;
import org.jetbrains.kotlinx.dl.api.core.layer.KVariableKt;
import org.jetbrains.kotlinx.dl.api.core.layer.Layer;
import org.jetbrains.kotlinx.dl.api.core.layer.TrainableLayer;
import org.jetbrains.kotlinx.dl.api.core.regularizer.Regularizer;
import org.jetbrains.kotlinx.dl.api.core.util.NameConventionsKt;
import org.tensorflow.Operand;
import org.tensorflow.Shape;
import org.tensorflow.op.Ops;
import org.tensorflow.op.linalg.MatMul;
import org.tensorflow.op.math.Add;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002Be\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012JB\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u000204032\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000f032\u000e\u00109\u001a\n\u0012\u0004\u0012\u000204\u0018\u000103H\u0016J\b\u0010:\u001a\u00020\u0011H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0014\u0010 \u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\"\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u0018X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001a\"\u0004\b(\u0010\u001cR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001eR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\"R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00180/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/core/Dense;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/TrainableLayer;", "outputSize", "", "activation", "Lorg/jetbrains/kotlinx/dl/api/core/activation/Activations;", "kernelInitializer", "Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;", "biasInitializer", "kernelRegularizer", "Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;", "biasRegularizer", "activityRegularizer", "useBias", "", "name", "", "(ILorg/jetbrains/kotlinx/dl/api/core/activation/Activations;Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;ZLjava/lang/String;)V", "getActivation", "()Lorg/jetbrains/kotlinx/dl/api/core/activation/Activations;", "getActivityRegularizer", "()Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;", "bias", "Lorg/jetbrains/kotlinx/dl/api/core/layer/KVariable;", "getBias$tensorflow", "()Lorg/jetbrains/kotlinx/dl/api/core/layer/KVariable;", "setBias$tensorflow", "(Lorg/jetbrains/kotlinx/dl/api/core/layer/KVariable;)V", "getBiasInitializer", "()Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;", "getBiasRegularizer", "hasActivation", "getHasActivation", "()Z", "isTrainable", "setTrainable", "(Z)V", "kernel", "getKernel$tensorflow", "setKernel$tensorflow", "getKernelInitializer", "getKernelRegularizer", "getOutputSize", "()I", "getUseBias", "variables", "", "getVariables", "()Ljava/util/List;", "build", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "input", "isTraining", "numberOfLosses", "toString", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nDense.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Dense.kt\norg/jetbrains/kotlinx/dl/api/core/layer/core/Dense\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class Dense
extends Layer
implements TrainableLayer {
    private final int outputSize;
    @NotNull
    private final Activations activation;
    @NotNull
    private final Initializer kernelInitializer;
    @NotNull
    private final Initializer biasInitializer;
    @Nullable
    private final Regularizer kernelRegularizer;
    @Nullable
    private final Regularizer biasRegularizer;
    @Nullable
    private final Regularizer activityRegularizer;
    private final boolean useBias;
    public KVariable kernel;
    @Nullable
    private KVariable bias;
    private boolean isTrainable;

    public Dense(int outputSize, @NotNull Activations activation, @NotNull Initializer kernelInitializer, @NotNull Initializer biasInitializer, @Nullable Regularizer kernelRegularizer, @Nullable Regularizer biasRegularizer, @Nullable Regularizer activityRegularizer, boolean useBias, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)((Object)activation), (String)"activation");
        Intrinsics.checkNotNullParameter((Object)kernelInitializer, (String)"kernelInitializer");
        Intrinsics.checkNotNullParameter((Object)biasInitializer, (String)"biasInitializer");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.outputSize = outputSize;
        this.activation = activation;
        this.kernelInitializer = kernelInitializer;
        this.biasInitializer = biasInitializer;
        this.kernelRegularizer = kernelRegularizer;
        this.biasRegularizer = biasRegularizer;
        this.activityRegularizer = activityRegularizer;
        this.useBias = useBias;
        this.isTrainable = true;
    }

    public /* synthetic */ Dense(int n, Activations activations, Initializer initializer, Initializer initializer2, Regularizer regularizer, Regularizer regularizer2, Regularizer regularizer3, boolean bl, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 128;
        }
        if ((n2 & 2) != 0) {
            activations = Activations.Relu;
        }
        if ((n2 & 4) != 0) {
            initializer = new HeNormal(0L, 1, null);
        }
        if ((n2 & 8) != 0) {
            initializer2 = new HeUniform(0L, 1, null);
        }
        if ((n2 & 0x10) != 0) {
            regularizer = null;
        }
        if ((n2 & 0x20) != 0) {
            regularizer2 = null;
        }
        if ((n2 & 0x40) != 0) {
            regularizer3 = null;
        }
        if ((n2 & 0x80) != 0) {
            bl = true;
        }
        if ((n2 & 0x100) != 0) {
            string = "";
        }
        this(n, activations, initializer, initializer2, regularizer, regularizer2, regularizer3, bl, string);
    }

    public final int getOutputSize() {
        return this.outputSize;
    }

    @NotNull
    public final Activations getActivation() {
        return this.activation;
    }

    @NotNull
    public final Initializer getKernelInitializer() {
        return this.kernelInitializer;
    }

    @NotNull
    public final Initializer getBiasInitializer() {
        return this.biasInitializer;
    }

    @Nullable
    public final Regularizer getKernelRegularizer() {
        return this.kernelRegularizer;
    }

    @Nullable
    public final Regularizer getBiasRegularizer() {
        return this.biasRegularizer;
    }

    @Nullable
    public final Regularizer getActivityRegularizer() {
        return this.activityRegularizer;
    }

    public final boolean getUseBias() {
        return this.useBias;
    }

    @NotNull
    public final KVariable getKernel$tensorflow() {
        KVariable kVariable = this.kernel;
        if (kVariable != null) {
            return kVariable;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"kernel");
        return null;
    }

    public final void setKernel$tensorflow(@NotNull KVariable kVariable) {
        Intrinsics.checkNotNullParameter((Object)kVariable, (String)"<set-?>");
        this.kernel = kVariable;
    }

    @Nullable
    public final KVariable getBias$tensorflow() {
        return this.bias;
    }

    public final void setBias$tensorflow(@Nullable KVariable kVariable) {
        this.bias = kVariable;
    }

    @Override
    @NotNull
    public List<KVariable> getVariables() {
        Object[] objectArray = new KVariable[]{this.getKernel$tensorflow(), this.bias};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @Override
    public boolean isTrainable() {
        return this.isTrainable;
    }

    @Override
    public void setTrainable(boolean bl) {
        this.isTrainable = bl;
    }

    @Override
    @NotNull
    public Operand<Float> build(@NotNull Ops tf, @NotNull Operand<Float> input, @NotNull Operand<Boolean> isTraining, @Nullable Operand<Float> numberOfLosses) {
        KVariable kVariable;
        block5: {
            MatMul matMul;
            block4: {
                Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
                Intrinsics.checkNotNullParameter(input, (String)"input");
                Intrinsics.checkNotNullParameter(isTraining, (String)"isTraining");
                Shape inputShape = input.asOutput().shape();
                int fanIn = (int)inputShape.size(inputShape.numDimensions() - 1);
                int fanOut = this.outputSize;
                long[] lArray = new long[]{this.outputSize};
                Shape kernelShape = Shape.make((long)inputShape.size(inputShape.numDimensions() - 1), (long[])lArray);
                String string = NameConventionsKt.denseKernelVarName(this.getName());
                Intrinsics.checkNotNullExpressionValue((Object)kernelShape, (String)"kernelShape");
                this.setKernel$tensorflow(KVariableKt.createVariable(tf, string, kernelShape, fanIn, fanOut, this.kernelInitializer, this.kernelRegularizer));
                if (this.useBias) {
                    Shape biasShape = Shape.make((long)this.outputSize, (long[])new long[0]);
                    String string2 = NameConventionsKt.denseBiasVarName(this.getName());
                    Intrinsics.checkNotNullExpressionValue((Object)biasShape, (String)"biasShape");
                    this.bias = KVariableKt.createVariable(tf, string2, biasShape, fanIn, fanOut, this.biasInitializer, this.biasRegularizer);
                }
                matMul = tf.linalg.matMul(input, (Operand)this.getKernel$tensorflow().getVariable(), new MatMul.Options[0]);
                kVariable = this.bias;
                if (kVariable == null) break block4;
                KVariable it = kVariable;
                boolean bl = false;
                Add add = tf.math.add((Operand)matMul, (Operand)it.getVariable());
                kVariable = add;
                if (add != null) break block5;
            }
            kVariable = matMul;
        }
        KVariable signal = kVariable;
        Activation activation = Activations.Companion.convert(this.activation);
        Intrinsics.checkNotNullExpressionValue((Object)signal, (String)"signal");
        return activation.apply(tf, (Operand<Float>)((Operand)signal), this.getName());
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Dense(name = ").append(this.getName()).append(", isTrainable=").append(this.isTrainable()).append(", outputSize=").append(this.outputSize).append(", activation=").append((Object)this.activation).append(", kernelInitializer=").append(this.kernelInitializer).append(", biasInitializer=").append(this.biasInitializer).append(", kernelRegularizer=").append(this.kernelRegularizer).append(", biasRegularizer=").append(this.biasRegularizer).append(", activityRegularizer=").append(this.activityRegularizer).append(", useBias=").append(this.useBias).append(", hasActivation=").append(this.getHasActivation()).append(", kernelShapeArray=");
        KVariable kVariable = this.bias;
        stringBuilder.append(this.getKernel$tensorflow().getShape()).append(", biasShapeArray=").append(kVariable != null ? kVariable.getShape() : null).append(')');
        return stringBuilder.toString();
    }

    @Override
    public boolean getHasActivation() {
        return true;
    }

    @Override
    public int getParamCount() {
        return TrainableLayer.DefaultImpls.getParamCount(this);
    }

    public Dense() {
        this(0, null, null, null, null, null, null, false, null, 511, null);
    }
}

