/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.convolutional;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongSpreadBuilder;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.activation.Activations;
import org.jetbrains.kotlinx.dl.api.core.initializer.HeNormal;
import org.jetbrains.kotlinx.dl.api.core.initializer.HeUniform;
import org.jetbrains.kotlinx.dl.api.core.initializer.Initializer;
import org.jetbrains.kotlinx.dl.api.core.layer.KVariable;
import org.jetbrains.kotlinx.dl.api.core.layer.KVariableKt;
import org.jetbrains.kotlinx.dl.api.core.layer.Layer;
import org.jetbrains.kotlinx.dl.api.core.layer.LayerKt;
import org.jetbrains.kotlinx.dl.api.core.layer.NoGradients;
import org.jetbrains.kotlinx.dl.api.core.layer.ParametrizedLayer;
import org.jetbrains.kotlinx.dl.api.core.layer.TrainableLayerKt;
import org.jetbrains.kotlinx.dl.api.core.layer.convolutional.ConvPadding;
import org.jetbrains.kotlinx.dl.api.core.regularizer.Regularizer;
import org.jetbrains.kotlinx.dl.api.core.shape.ShapeFunctionsKt;
import org.jetbrains.kotlinx.dl.api.core.util.NameConventionsKt;
import org.tensorflow.Operand;
import org.tensorflow.Shape;
import org.tensorflow.op.Ops;
import org.tensorflow.op.nn.BiasAdd;
import org.tensorflow.op.nn.Conv2d;
import org.tensorflow.op.nn.DepthwiseConv2dNative;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u00af\u0001\b\u0016\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\r\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0011\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bB\u00ad\u0001\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u001c\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u001c\u0012\b\b\u0002\u0010\b\u001a\u00020\u001c\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\r\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0011\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001dJB\u0010F\u001a\b\u0012\u0004\u0012\u00020H0G2\u0006\u0010I\u001a\u00020J2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020H0G2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00180G2\u000e\u0010M\u001a\n\u0012\u0004\u0012\u00020H\u0018\u00010GH\u0016J\b\u0010N\u001a\u00020\u001aH\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0011\u0010\u000f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010!R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010)R\u001a\u0010.\u001a\u00020#X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010%\"\u0004\b0\u0010'R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010!R\u0011\u0010\b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010,R\u0014\u00105\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0011\u0010\u0006\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00103R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010)R\u001a\u0010<\u001a\u00020#X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010%\"\u0004\b>\u0010'R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010!R\u0011\u0010\u0007\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u00103R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u00107R\u001a\u0010B\u001a\b\u0012\u0004\u0012\u00020#0C8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010E\u00a8\u0006O"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/SeparableConv2D;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/NoGradients;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/ParametrizedLayer;", "filters", "", "kernelSize", "strides", "dilations", "activation", "Lorg/jetbrains/kotlinx/dl/api/core/activation/Activations;", "depthMultiplier", "depthwiseInitializer", "Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;", "pointwiseInitializer", "biasInitializer", "depthwiseRegularizer", "Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;", "pointwiseRegularizer", "biasRegularizer", "activityRegularizer", "padding", "Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvPadding;", "useBias", "", "name", "", "(IIIILorg/jetbrains/kotlinx/dl/api/core/activation/Activations;ILorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvPadding;ZLjava/lang/String;)V", "", "(I[I[I[ILorg/jetbrains/kotlinx/dl/api/core/activation/Activations;ILorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvPadding;ZLjava/lang/String;)V", "getActivation", "()Lorg/jetbrains/kotlinx/dl/api/core/activation/Activations;", "getActivityRegularizer", "()Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;", "bias", "Lorg/jetbrains/kotlinx/dl/api/core/layer/KVariable;", "getBias$tensorflow", "()Lorg/jetbrains/kotlinx/dl/api/core/layer/KVariable;", "setBias$tensorflow", "(Lorg/jetbrains/kotlinx/dl/api/core/layer/KVariable;)V", "getBiasInitializer", "()Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;", "getBiasRegularizer", "getDepthMultiplier", "()I", "getDepthwiseInitializer", "depthwiseKernel", "getDepthwiseKernel$tensorflow", "setDepthwiseKernel$tensorflow", "getDepthwiseRegularizer", "getDilations", "()[I", "getFilters", "hasActivation", "getHasActivation", "()Z", "getKernelSize", "getPadding", "()Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvPadding;", "getPointwiseInitializer", "pointwiseKernel", "getPointwiseKernel$tensorflow", "setPointwiseKernel$tensorflow", "getPointwiseRegularizer", "getStrides", "getUseBias", "variables", "", "getVariables", "()Ljava/util/List;", "build", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "input", "isTraining", "numberOfLosses", "toString", "tensorflow"})
public final class SeparableConv2D
extends Layer
implements NoGradients,
ParametrizedLayer {
    private final int filters;
    @NotNull
    private final int[] kernelSize;
    @NotNull
    private final int[] strides;
    @NotNull
    private final int[] dilations;
    @NotNull
    private final Activations activation;
    private final int depthMultiplier;
    @NotNull
    private final Initializer depthwiseInitializer;
    @NotNull
    private final Initializer pointwiseInitializer;
    @NotNull
    private final Initializer biasInitializer;
    @Nullable
    private final Regularizer depthwiseRegularizer;
    @Nullable
    private final Regularizer pointwiseRegularizer;
    @Nullable
    private final Regularizer biasRegularizer;
    @Nullable
    private final Regularizer activityRegularizer;
    @NotNull
    private final ConvPadding padding;
    private final boolean useBias;
    public KVariable depthwiseKernel;
    public KVariable pointwiseKernel;
    @Nullable
    private KVariable bias;

    public SeparableConv2D(int filters, @NotNull int[] kernelSize, @NotNull int[] strides, @NotNull int[] dilations, @NotNull Activations activation, int depthMultiplier, @NotNull Initializer depthwiseInitializer, @NotNull Initializer pointwiseInitializer, @NotNull Initializer biasInitializer, @Nullable Regularizer depthwiseRegularizer, @Nullable Regularizer pointwiseRegularizer, @Nullable Regularizer biasRegularizer, @Nullable Regularizer activityRegularizer, @NotNull ConvPadding padding, boolean useBias, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)kernelSize, (String)"kernelSize");
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        Intrinsics.checkNotNullParameter((Object)dilations, (String)"dilations");
        Intrinsics.checkNotNullParameter((Object)((Object)activation), (String)"activation");
        Intrinsics.checkNotNullParameter((Object)depthwiseInitializer, (String)"depthwiseInitializer");
        Intrinsics.checkNotNullParameter((Object)pointwiseInitializer, (String)"pointwiseInitializer");
        Intrinsics.checkNotNullParameter((Object)biasInitializer, (String)"biasInitializer");
        Intrinsics.checkNotNullParameter((Object)((Object)padding), (String)"padding");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.filters = filters;
        this.kernelSize = kernelSize;
        this.strides = strides;
        this.dilations = dilations;
        this.activation = activation;
        this.depthMultiplier = depthMultiplier;
        this.depthwiseInitializer = depthwiseInitializer;
        this.pointwiseInitializer = pointwiseInitializer;
        this.biasInitializer = biasInitializer;
        this.depthwiseRegularizer = depthwiseRegularizer;
        this.pointwiseRegularizer = pointwiseRegularizer;
        this.biasRegularizer = biasRegularizer;
        this.activityRegularizer = activityRegularizer;
        this.padding = padding;
        this.useBias = useBias;
        LayerKt.requireArraySize(this.kernelSize, 2, "kernelSize");
        LayerKt.requireArraySize(this.strides, 4, "strides");
        LayerKt.requireArraySize(this.dilations, 4, "dilations");
    }

    public /* synthetic */ SeparableConv2D(int n, int[] nArray, int[] nArray2, int[] nArray3, Activations activations, int n2, Initializer initializer, Initializer initializer2, Initializer initializer3, Regularizer regularizer, Regularizer regularizer2, Regularizer regularizer3, Regularizer regularizer4, ConvPadding convPadding, boolean bl, String string, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        int[] nArray4;
        if ((n3 & 1) != 0) {
            n = 32;
        }
        if ((n3 & 2) != 0) {
            nArray4 = new int[]{3, 3};
            nArray = nArray4;
        }
        if ((n3 & 4) != 0) {
            nArray4 = new int[]{1, 1, 1, 1};
            nArray2 = nArray4;
        }
        if ((n3 & 8) != 0) {
            nArray4 = new int[]{1, 1, 1, 1};
            nArray3 = nArray4;
        }
        if ((n3 & 0x10) != 0) {
            activations = Activations.Relu;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 1;
        }
        if ((n3 & 0x40) != 0) {
            initializer = new HeNormal(0L, 1, null);
        }
        if ((n3 & 0x80) != 0) {
            initializer2 = new HeNormal(0L, 1, null);
        }
        if ((n3 & 0x100) != 0) {
            initializer3 = new HeUniform(0L, 1, null);
        }
        if ((n3 & 0x200) != 0) {
            regularizer = null;
        }
        if ((n3 & 0x400) != 0) {
            regularizer2 = null;
        }
        if ((n3 & 0x800) != 0) {
            regularizer3 = null;
        }
        if ((n3 & 0x1000) != 0) {
            regularizer4 = null;
        }
        if ((n3 & 0x2000) != 0) {
            convPadding = ConvPadding.SAME;
        }
        if ((n3 & 0x4000) != 0) {
            bl = true;
        }
        if ((n3 & 0x8000) != 0) {
            string = "";
        }
        this(n, nArray, nArray2, nArray3, activations, n2, initializer, initializer2, initializer3, regularizer, regularizer2, regularizer3, regularizer4, convPadding, bl, string);
    }

    public final int getFilters() {
        return this.filters;
    }

    @NotNull
    public final int[] getKernelSize() {
        return this.kernelSize;
    }

    @NotNull
    public final int[] getStrides() {
        return this.strides;
    }

    @NotNull
    public final int[] getDilations() {
        return this.dilations;
    }

    @NotNull
    public final Activations getActivation() {
        return this.activation;
    }

    public final int getDepthMultiplier() {
        return this.depthMultiplier;
    }

    @NotNull
    public final Initializer getDepthwiseInitializer() {
        return this.depthwiseInitializer;
    }

    @NotNull
    public final Initializer getPointwiseInitializer() {
        return this.pointwiseInitializer;
    }

    @NotNull
    public final Initializer getBiasInitializer() {
        return this.biasInitializer;
    }

    @Nullable
    public final Regularizer getDepthwiseRegularizer() {
        return this.depthwiseRegularizer;
    }

    @Nullable
    public final Regularizer getPointwiseRegularizer() {
        return this.pointwiseRegularizer;
    }

    @Nullable
    public final Regularizer getBiasRegularizer() {
        return this.biasRegularizer;
    }

    @Nullable
    public final Regularizer getActivityRegularizer() {
        return this.activityRegularizer;
    }

    @NotNull
    public final ConvPadding getPadding() {
        return this.padding;
    }

    public final boolean getUseBias() {
        return this.useBias;
    }

    public SeparableConv2D(int filters, int kernelSize, int strides, int dilations, @NotNull Activations activation, int depthMultiplier, @NotNull Initializer depthwiseInitializer, @NotNull Initializer pointwiseInitializer, @NotNull Initializer biasInitializer, @Nullable Regularizer depthwiseRegularizer, @Nullable Regularizer pointwiseRegularizer, @Nullable Regularizer biasRegularizer, @Nullable Regularizer activityRegularizer, @NotNull ConvPadding padding, boolean useBias, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)((Object)activation), (String)"activation");
        Intrinsics.checkNotNullParameter((Object)depthwiseInitializer, (String)"depthwiseInitializer");
        Intrinsics.checkNotNullParameter((Object)pointwiseInitializer, (String)"pointwiseInitializer");
        Intrinsics.checkNotNullParameter((Object)biasInitializer, (String)"biasInitializer");
        Intrinsics.checkNotNullParameter((Object)((Object)padding), (String)"padding");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int[] nArray = new int[]{kernelSize, kernelSize};
        int[] nArray2 = nArray;
        nArray = new int[]{1, strides, strides, 1};
        int[] nArray3 = nArray;
        nArray = new int[]{1, dilations, dilations, 1};
        this(filters, nArray2, nArray3, nArray, activation, depthMultiplier, depthwiseInitializer, pointwiseInitializer, biasInitializer, depthwiseRegularizer, pointwiseRegularizer, biasRegularizer, activityRegularizer, padding, useBias, name);
    }

    public /* synthetic */ SeparableConv2D(int n, int n2, int n3, int n4, Activations activations, int n5, Initializer initializer, Initializer initializer2, Initializer initializer3, Regularizer regularizer, Regularizer regularizer2, Regularizer regularizer3, Regularizer regularizer4, ConvPadding convPadding, boolean bl, String string, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 1) != 0) {
            n = 32;
        }
        if ((n6 & 2) != 0) {
            n2 = 3;
        }
        if ((n6 & 4) != 0) {
            n3 = 1;
        }
        if ((n6 & 8) != 0) {
            n4 = 1;
        }
        if ((n6 & 0x10) != 0) {
            activations = Activations.Relu;
        }
        if ((n6 & 0x20) != 0) {
            n5 = 1;
        }
        if ((n6 & 0x40) != 0) {
            initializer = new HeNormal(0L, 1, null);
        }
        if ((n6 & 0x80) != 0) {
            initializer2 = new HeNormal(0L, 1, null);
        }
        if ((n6 & 0x100) != 0) {
            initializer3 = new HeUniform(0L, 1, null);
        }
        if ((n6 & 0x200) != 0) {
            regularizer = null;
        }
        if ((n6 & 0x400) != 0) {
            regularizer2 = null;
        }
        if ((n6 & 0x800) != 0) {
            regularizer3 = null;
        }
        if ((n6 & 0x1000) != 0) {
            regularizer4 = null;
        }
        if ((n6 & 0x2000) != 0) {
            convPadding = ConvPadding.SAME;
        }
        if ((n6 & 0x4000) != 0) {
            bl = true;
        }
        if ((n6 & 0x8000) != 0) {
            string = "";
        }
        this(n, n2, n3, n4, activations, n5, initializer, initializer2, initializer3, regularizer, regularizer2, regularizer3, regularizer4, convPadding, bl, string);
    }

    @NotNull
    public final KVariable getDepthwiseKernel$tensorflow() {
        KVariable kVariable = this.depthwiseKernel;
        if (kVariable != null) {
            return kVariable;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"depthwiseKernel");
        return null;
    }

    public final void setDepthwiseKernel$tensorflow(@NotNull KVariable kVariable) {
        Intrinsics.checkNotNullParameter((Object)kVariable, (String)"<set-?>");
        this.depthwiseKernel = kVariable;
    }

    @NotNull
    public final KVariable getPointwiseKernel$tensorflow() {
        KVariable kVariable = this.pointwiseKernel;
        if (kVariable != null) {
            return kVariable;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"pointwiseKernel");
        return null;
    }

    public final void setPointwiseKernel$tensorflow(@NotNull KVariable kVariable) {
        Intrinsics.checkNotNullParameter((Object)kVariable, (String)"<set-?>");
        this.pointwiseKernel = kVariable;
    }

    @Nullable
    public final KVariable getBias$tensorflow() {
        return this.bias;
    }

    public final void setBias$tensorflow(@Nullable KVariable kVariable) {
        this.bias = kVariable;
    }

    @Override
    @NotNull
    public List<KVariable> getVariables() {
        Object[] objectArray = new KVariable[]{this.getDepthwiseKernel$tensorflow(), this.getPointwiseKernel$tensorflow(), this.bias};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @Override
    @NotNull
    public Operand<Float> build(@NotNull Ops tf, @NotNull Operand<Float> input, @NotNull Operand<Boolean> isTraining, @Nullable Operand<Float> numberOfLosses) {
        Conv2d output;
        block1: {
            long numberOfChannels;
            Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
            Intrinsics.checkNotNullParameter(input, (String)"input");
            Intrinsics.checkNotNullParameter(isTraining, (String)"isTraining");
            Shape inputShape = input.asOutput().shape();
            long inputDepth = numberOfChannels = inputShape.size(inputShape.numDimensions() - 1);
            long outputDepth = numberOfChannels * (long)this.depthMultiplier;
            int fanIn = (int)(inputDepth * (long)this.kernelSize[0] * (long)this.kernelSize[1]);
            int fanOut = MathKt.roundToInt((double)((double)(outputDepth * (long)this.kernelSize[0] * (long)this.kernelSize[1]) / ((double)this.strides[0] * (double)this.strides[1])));
            LongSpreadBuilder longSpreadBuilder = new LongSpreadBuilder(3);
            longSpreadBuilder.addSpread((Object)LayerKt.toLongArray(this.kernelSize));
            longSpreadBuilder.add(numberOfChannels);
            longSpreadBuilder.add((long)this.depthMultiplier);
            Shape depthwiseKernelShape = ShapeFunctionsKt.shapeFromDims(longSpreadBuilder.toArray());
            this.setDepthwiseKernel$tensorflow(KVariableKt.createVariable(tf, NameConventionsKt.separableConv2dDepthwiseKernelVarName(this.getName()), depthwiseKernelShape, fanIn, fanOut, this.depthwiseInitializer, this.depthwiseRegularizer));
            long[] lArray = new long[]{1L, 1L, numberOfChannels * (long)this.depthMultiplier, this.filters};
            Shape pointwiseKernelShape = ShapeFunctionsKt.shapeFromDims(lArray);
            this.setPointwiseKernel$tensorflow(KVariableKt.createVariable(tf, NameConventionsKt.separableConv2dPointwiseKernelVarName(this.getName()), pointwiseKernelShape, fanIn, fanOut, this.pointwiseInitializer, this.pointwiseRegularizer));
            if (this.useBias) {
                Shape biasShape = Shape.make((long)this.filters, (long[])new long[0]);
                String string = NameConventionsKt.separableConv2dBiasVarName(this.getName());
                Intrinsics.checkNotNullExpressionValue((Object)biasShape, (String)"biasShape");
                this.bias = KVariableKt.createVariable(tf, string, biasShape, fanIn, fanOut, this.biasInitializer, this.biasRegularizer);
            }
            String paddingName = this.padding.getPaddingName$tensorflow();
            DepthwiseConv2dNative.Options options = DepthwiseConv2dNative.dilations(LayerKt.toLongList(this.dilations)).dataFormat("NHWC");
            Intrinsics.checkNotNullExpressionValue((Object)options, (String)"dilations(dilations.toLo\u2026ist()).dataFormat(\"NHWC\")");
            DepthwiseConv2dNative.Options depthwiseConv2DOptions = options;
            Object[] objectArray = new DepthwiseConv2dNative.Options[]{depthwiseConv2DOptions};
            DepthwiseConv2dNative depthwiseConv2dNative = tf.nn.depthwiseConv2dNative(input, (Operand)this.getDepthwiseKernel$tensorflow().getVariable(), LayerKt.toLongList(this.strides), paddingName, (DepthwiseConv2dNative.Options[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)depthwiseConv2dNative, (String)"tf.nn.depthwiseConv2dNat\u2026nv2DOptions\n            )");
            Operand depthwiseOutput = (Operand)depthwiseConv2dNative;
            objectArray = new Long[]{1L, 1L, 1L, 1L};
            List pointwiseStrides = CollectionsKt.mutableListOf((Object[])objectArray);
            Conv2d.Options options2 = Conv2d.dataFormat((String)"NHWC");
            Intrinsics.checkNotNullExpressionValue((Object)options2, (String)"dataFormat(\"NHWC\")");
            Conv2d.Options conv2DOptions = options2;
            output = null;
            Conv2d.Options[] optionsArray = new Conv2d.Options[]{conv2DOptions};
            Conv2d conv2d = tf.nn.conv2d(depthwiseOutput, (Operand)this.getPointwiseKernel$tensorflow().getVariable(), pointwiseStrides, "VALID", optionsArray);
            Intrinsics.checkNotNullExpressionValue((Object)conv2d, (String)"tf.nn.conv2d(depthwiseOu\u2026, \"VALID\", conv2DOptions)");
            output = conv2d;
            KVariable kVariable = this.bias;
            if (kVariable == null) break block1;
            KVariable it = kVariable;
            boolean bl = false;
            BiasAdd biasAdd = tf.nn.biasAdd((Operand)output, (Operand)it.getVariable(), new BiasAdd.Options[0]);
            Intrinsics.checkNotNullExpressionValue((Object)biasAdd, (String)"tf.nn.biasAdd(output, it.variable)");
            output = biasAdd;
        }
        return Activations.Companion.convert(this.activation).apply(tf, (Operand<Float>)((Operand)output), this.getName());
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("SeparableConv2D(name = ").append(this.getName()).append(", isTrainable=").append(TrainableLayerKt.isTrainable(this)).append(", filters=").append(this.filters).append(", kernelSize=");
        String string = Arrays.toString(this.kernelSize);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
        StringBuilder stringBuilder3 = stringBuilder2.append(string).append(", strides=");
        String string2 = Arrays.toString(this.strides);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
        StringBuilder stringBuilder4 = stringBuilder3.append(string2).append(", dilations=");
        String string3 = Arrays.toString(this.dilations);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this)");
        stringBuilder4.append(string3).append(", activation=").append((Object)this.activation).append(", depthMultiplier=").append(this.depthMultiplier).append(", depthwiseInitializer=").append(this.depthwiseInitializer).append(", pointwiseInitializer=").append(this.pointwiseInitializer).append(", biasInitializer=").append(this.biasInitializer).append(", depthwiseRegularizer=");
        KVariable kVariable = this.bias;
        stringBuilder.append(this.depthwiseRegularizer).append(", pointwiseRegularizer=").append(this.pointwiseRegularizer).append(", biasRegularizer=").append(this.biasRegularizer).append(", activityRegularizer=").append(this.activityRegularizer).append(", padding=").append((Object)this.padding).append(", useBias=").append(this.useBias).append(", depthwiseShapeArray=").append(this.getDepthwiseKernel$tensorflow().getShape()).append(", pointwiseShapeArray=").append(this.getPointwiseKernel$tensorflow().getShape()).append(", biasShapeArray=").append(kVariable != null ? kVariable.getShape() : null).append(", hasActivation=").append(this.getHasActivation()).append(')');
        return stringBuilder.toString();
    }

    @Override
    public boolean getHasActivation() {
        return true;
    }

    @Override
    public int getParamCount() {
        return ParametrizedLayer.DefaultImpls.getParamCount(this);
    }

    public SeparableConv2D() {
        this(0, null, null, null, null, 0, null, null, null, null, null, null, null, null, false, null, 65535, null);
    }
}

