/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.convolutional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntSpreadBuilder;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongSpreadBuilder;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.layer.KVariable;
import org.jetbrains.kotlinx.dl.api.core.layer.LayerKt;
import org.jetbrains.kotlinx.dl.api.core.layer.convolutional.AbstractConv;
import org.jetbrains.kotlinx.dl.api.core.layer.convolutional.ConvPadding;
import org.jetbrains.kotlinx.dl.api.core.shape.ConvUtilKt;
import org.jetbrains.kotlinx.dl.api.core.shape.ShapeFunctionsKt;
import org.jetbrains.kotlinx.dl.api.core.shape.TensorShape;
import org.jetbrains.kotlinx.dl.api.core.util.NameConventionsKt;
import org.tensorflow.Operand;
import org.tensorflow.Shape;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Squeeze;
import org.tensorflow.op.core.Stack;
import org.tensorflow.op.nn.Conv2dBackpropInput;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b&\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0004J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0015\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u0004\u0018\u00010\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvTranspose;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/AbstractConv;", "dimensions", "", "name", "", "(ILjava/lang/String;)V", "getDimensions", "()I", "outputPadding", "", "getOutputPadding", "()[I", "biasVarName", "computeKernelShape", "Lorg/tensorflow/Shape;", "numberOfChannels", "", "computeOutputShape", "inputShape", "kernelVarName", "toString", "Companion", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nConvTranspose.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvTranspose.kt\norg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvTranspose\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1549#2:138\n1620#2,3:139\n*S KotlinDebug\n*F\n+ 1 ConvTranspose.kt\norg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvTranspose\n*L\n42#1:138\n42#1:139,3\n*E\n"})
public abstract class ConvTranspose
extends AbstractConv {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int dimensions;
    @NotNull
    public static final String EXPLICIT = "EXPLICIT";

    public ConvTranspose(int dimensions, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.dimensions = dimensions;
    }

    public /* synthetic */ ConvTranspose(int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = "";
        }
        this(n, string);
    }

    public final int getDimensions() {
        return this.dimensions;
    }

    @Nullable
    protected abstract int[] getOutputPadding();

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Shape computeOutputShape(@NotNull Shape inputShape) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)inputShape, (String)"inputShape");
        Iterable $this$map$iv = (Iterable)ArraysKt.getIndices((int[])this.getKernelSize());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int[] nArray = this.getOutputPadding();
            int[] nArray2 = this.getOutputPadding();
            collection.add(ConvUtilKt.convTransposeOutputLength(inputShape.size((int)(it + true)), this.getKernelSize()[it], this.getPadding(), nArray != null ? Integer.valueOf(nArray[2 * (it + true)]) : null, nArray2 != null ? Integer.valueOf(nArray2[2 * (it + true) + 1]) : null, this.getStrides()[it + true], this.getDilations()[it + true]));
        }
        List shapes = (List)destination$iv$iv;
        long[] lArray = CollectionsKt.toLongArray((Collection)CollectionsKt.plus((Collection)shapes, (Object)this.getFilters()));
        Shape shape = Shape.make((long)inputShape.size(0), (long[])Arrays.copyOf(lArray, lArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"make(inputShape.size(0),\u2026.toLong()).toLongArray())");
        return shape;
    }

    @Override
    @NotNull
    protected String kernelVarName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return NameConventionsKt.convTransposeKernelVarName(name, this.dimensions);
    }

    @Override
    @NotNull
    protected String biasVarName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return NameConventionsKt.convTransposeBiasVarName(name, this.dimensions);
    }

    @Override
    @NotNull
    protected Shape computeKernelShape(long numberOfChannels) {
        LongSpreadBuilder longSpreadBuilder = new LongSpreadBuilder(3);
        longSpreadBuilder.addSpread((Object)LayerKt.toLongArray(this.getKernelSize()));
        longSpreadBuilder.add((long)this.getFilters());
        longSpreadBuilder.add(numberOfChannels);
        return ShapeFunctionsKt.shapeFromDims(longSpreadBuilder.toArray());
    }

    @NotNull
    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("Conv").append(this.dimensions).append("DTranspose(filters=").append(this.getFilters()).append(", kernelSize=");
        String string2 = Arrays.toString(this.getKernelSize());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
        KVariable kVariable = this.getBias$tensorflow();
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append(", kernelShape=").append(this.getKernel$tensorflow().getShape()).append(", biasShape=").append(kVariable != null ? kVariable.getShape() : null).append(", strides=");
        String string3 = Arrays.toString(this.getStrides());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this)");
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append(", dilations=");
        String string4 = Arrays.toString(this.getDilations());
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(this)");
        stringBuilder4.append(string4).append(", activation=").append((Object)this.getActivation()).append(", kernelInitializer=").append(this.getKernelInitializer()).append(", biasInitializer=").append(this.getBiasInitializer()).append(", biasRegularizer=").append(this.getBiasRegularizer()).append(", kernelRegularizer=");
        StringBuilder stringBuilder5 = stringBuilder.append(this.getKernelRegularizer()).append(", activityRegularizer=").append(this.getActivityRegularizer()).append(", padding=").append((Object)this.getPadding()).append(", outputPadding=");
        int[] nArray = this.getOutputPadding();
        if (nArray != null) {
            String string5 = Arrays.toString(nArray);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(this)");
        } else {
            string = null;
        }
        stringBuilder5.append(string).append(" )");
        return stringBuilder.toString();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ-\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000eH\u0000\u00a2\u0006\u0002\b\u0015J)\u0010\u0016\u001a\u00020\t*\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvTranspose$Companion;", "", "()V", "EXPLICIT", "", "buildOptions", "", "Lorg/tensorflow/op/nn/Conv2dBackpropInput$Options;", "dilations", "", "outputPadding", "buildOptions$tensorflow", "([I[I)[Lorg/tensorflow/op/nn/Conv2dBackpropInput$Options;", "shapeWithDynamicBatchSize", "Lorg/tensorflow/Operand;", "", "Lorg/tensorflow/op/Ops;", "tensorShape", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "input", "", "shapeWithDynamicBatchSize$tensorflow", "withStandardPadding", "padding", "Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvPadding;", "kernelSize", "withStandardPadding$tensorflow", "tensorflow"})
    @SourceDebugExtension(value={"SMAP\nConvTranspose.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvTranspose.kt\norg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvTranspose$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,137:1\n1360#2:138\n1446#2,5:139\n1549#2:144\n1620#2,3:145\n1549#2:150\n1620#2,3:151\n37#3,2:148\n*S KotlinDebug\n*F\n+ 1 ConvTranspose.kt\norg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvTranspose$Companion\n*L\n99#1:138\n99#1:139,5\n119#1:144\n119#1:145,3\n133#1:150\n133#1:151,3\n119#1:148,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final int[] withStandardPadding$tensorflow(@NotNull int[] $this$withStandardPadding, @NotNull ConvPadding padding, @NotNull int[] kernelSize, @NotNull int[] dilations) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$withStandardPadding, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)((Object)padding), (String)"padding");
            Intrinsics.checkNotNullParameter((Object)kernelSize, (String)"kernelSize");
            Intrinsics.checkNotNullParameter((Object)dilations, (String)"dilations");
            Iterable $this$flatMap$iv = (Iterable)ArraysKt.getIndices((int[])kernelSize);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv$iv;
                int dim = element$iv$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                Iterable list$iv$iv = ConvUtilKt.convTransposePadding(padding, $this$withStandardPadding[2 * dim], $this$withStandardPadding[2 * dim + 1], kernelSize[dim], dilations[dim + 1]);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List withStandardPadding = (List)destination$iv$iv;
            IntSpreadBuilder intSpreadBuilder = new IntSpreadBuilder(5);
            intSpreadBuilder.add(0);
            intSpreadBuilder.add(0);
            intSpreadBuilder.addSpread((Object)CollectionsKt.toIntArray((Collection)withStandardPadding));
            intSpreadBuilder.add(0);
            intSpreadBuilder.add(0);
            return intSpreadBuilder.toArray();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Conv2dBackpropInput.Options[] buildOptions$tensorflow(@NotNull int[] dilations, @Nullable int[] outputPadding) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)dilations, (String)"dilations");
            Object[] objectArray = new Conv2dBackpropInput.Options[]{Conv2dBackpropInput.dilations(LayerKt.toLongList(dilations))};
            List options = CollectionsKt.mutableListOf((Object[])objectArray);
            if (outputPadding != null) {
                options.add(Conv2dBackpropInput.explicitPaddings(LayerKt.toLongList(outputPadding)));
            }
            Iterable $this$map$iv = options;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Conv2dBackpropInput.Options options2 = (Conv2dBackpropInput.Options)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.dataFormat("NHWC"));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new Conv2dBackpropInput.Options[0]);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Operand<Integer> shapeWithDynamicBatchSize$tensorflow(@NotNull Ops $this$shapeWithDynamicBatchSize, @NotNull TensorShape tensorShape, @NotNull Operand<Float> input) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$shapeWithDynamicBatchSize, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)tensorShape, (String)"tensorShape");
            Intrinsics.checkNotNullParameter(input, (String)"input");
            int[] nArray = new int[]{0};
            Operand operand = (Operand)$this$shapeWithDynamicBatchSize.constant(nArray);
            nArray = new int[]{1};
            Squeeze batchSize = $this$shapeWithDynamicBatchSize.squeeze((Operand)$this$shapeWithDynamicBatchSize.slice((Operand)$this$shapeWithDynamicBatchSize.shape(input), operand, (Operand)$this$shapeWithDynamicBatchSize.constant(nArray)), new Squeeze.Options[0]);
            Iterable $this$map$iv = CollectionsKt.drop((Iterable)ArraysKt.toList((long[])tensorShape.dims()), (int)1);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                long l = ((Number)item$iv$iv).longValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add($this$shapeWithDynamicBatchSize.constant((int)it));
            }
            List otherDims = (List)destination$iv$iv;
            Stack stack = $this$shapeWithDynamicBatchSize.stack((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)batchSize), (Iterable)otherDims), new Stack.Options[0]);
            Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack(listOf(batchSize) + otherDims)");
            return (Operand)stack;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

