/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.convolutional;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.activation.Activations;
import org.jetbrains.kotlinx.dl.api.core.initializer.HeNormal;
import org.jetbrains.kotlinx.dl.api.core.initializer.HeUniform;
import org.jetbrains.kotlinx.dl.api.core.initializer.Initializer;
import org.jetbrains.kotlinx.dl.api.core.layer.KVariable;
import org.jetbrains.kotlinx.dl.api.core.layer.LayerKt;
import org.jetbrains.kotlinx.dl.api.core.layer.TrainableLayer;
import org.jetbrains.kotlinx.dl.api.core.layer.convolutional.AbstractConv;
import org.jetbrains.kotlinx.dl.api.core.layer.convolutional.ConvPadding;
import org.jetbrains.kotlinx.dl.api.core.regularizer.Regularizer;
import org.jetbrains.kotlinx.dl.api.core.util.NameConventionsKt;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.nn.Conv2d;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u008f\u0001\b\u0016\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000e\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017B\u008d\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0018\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0018\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0018\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000e\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u00100\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J$\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020302H\u0014J\u0010\u00107\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u00108\u001a\u00020\u0016H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\f\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u0014\u0010\u0007\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\"R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010\u0006\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\"R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010&\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/Conv2D;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/AbstractConv;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/TrainableLayer;", "filters", "", "kernelSize", "strides", "dilations", "activation", "Lorg/jetbrains/kotlinx/dl/api/core/activation/Activations;", "kernelInitializer", "Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;", "biasInitializer", "kernelRegularizer", "Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;", "biasRegularizer", "activityRegularizer", "padding", "Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvPadding;", "useBias", "", "name", "", "(IIIILorg/jetbrains/kotlinx/dl/api/core/activation/Activations;Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvPadding;ZLjava/lang/String;)V", "", "(I[I[I[ILorg/jetbrains/kotlinx/dl/api/core/activation/Activations;Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvPadding;ZLjava/lang/String;)V", "getActivation", "()Lorg/jetbrains/kotlinx/dl/api/core/activation/Activations;", "getActivityRegularizer", "()Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;", "getBiasInitializer", "()Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;", "getBiasRegularizer", "getDilations", "()[I", "getFilters", "()I", "isTrainable", "()Z", "setTrainable", "(Z)V", "getKernelInitializer", "getKernelRegularizer", "getKernelSize", "getPadding", "()Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvPadding;", "getStrides", "getUseBias", "biasVarName", "convImplementation", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "input", "kernelVarName", "toString", "tensorflow"})
public final class Conv2D
extends AbstractConv
implements TrainableLayer {
    private final int filters;
    @NotNull
    private final int[] kernelSize;
    @NotNull
    private final int[] strides;
    @NotNull
    private final int[] dilations;
    @NotNull
    private final Activations activation;
    @NotNull
    private final Initializer kernelInitializer;
    @NotNull
    private final Initializer biasInitializer;
    @Nullable
    private final Regularizer kernelRegularizer;
    @Nullable
    private final Regularizer biasRegularizer;
    @Nullable
    private final Regularizer activityRegularizer;
    @NotNull
    private final ConvPadding padding;
    private final boolean useBias;
    private boolean isTrainable;

    public Conv2D(int filters, @NotNull int[] kernelSize, @NotNull int[] strides, @NotNull int[] dilations, @NotNull Activations activation, @NotNull Initializer kernelInitializer, @NotNull Initializer biasInitializer, @Nullable Regularizer kernelRegularizer, @Nullable Regularizer biasRegularizer, @Nullable Regularizer activityRegularizer, @NotNull ConvPadding padding, boolean useBias, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)kernelSize, (String)"kernelSize");
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        Intrinsics.checkNotNullParameter((Object)dilations, (String)"dilations");
        Intrinsics.checkNotNullParameter((Object)((Object)activation), (String)"activation");
        Intrinsics.checkNotNullParameter((Object)kernelInitializer, (String)"kernelInitializer");
        Intrinsics.checkNotNullParameter((Object)biasInitializer, (String)"biasInitializer");
        Intrinsics.checkNotNullParameter((Object)((Object)padding), (String)"padding");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.filters = filters;
        this.kernelSize = kernelSize;
        this.strides = strides;
        this.dilations = dilations;
        this.activation = activation;
        this.kernelInitializer = kernelInitializer;
        this.biasInitializer = biasInitializer;
        this.kernelRegularizer = kernelRegularizer;
        this.biasRegularizer = biasRegularizer;
        this.activityRegularizer = activityRegularizer;
        this.padding = padding;
        this.useBias = useBias;
        this.isTrainable = true;
        LayerKt.requireArraySize(this.getKernelSize(), 2, "kernelSize");
        LayerKt.requireArraySize(this.getStrides(), 4, "strides");
        LayerKt.requireArraySize(this.getDilations(), 4, "dilations");
    }

    public /* synthetic */ Conv2D(int n, int[] nArray, int[] nArray2, int[] nArray3, Activations activations, Initializer initializer, Initializer initializer2, Regularizer regularizer, Regularizer regularizer2, Regularizer regularizer3, ConvPadding convPadding, boolean bl, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        int[] nArray4;
        if ((n2 & 1) != 0) {
            n = 32;
        }
        if ((n2 & 2) != 0) {
            nArray4 = new int[]{3, 3};
            nArray = nArray4;
        }
        if ((n2 & 4) != 0) {
            nArray4 = new int[]{1, 1, 1, 1};
            nArray2 = nArray4;
        }
        if ((n2 & 8) != 0) {
            nArray4 = new int[]{1, 1, 1, 1};
            nArray3 = nArray4;
        }
        if ((n2 & 0x10) != 0) {
            activations = Activations.Relu;
        }
        if ((n2 & 0x20) != 0) {
            initializer = new HeNormal(0L, 1, null);
        }
        if ((n2 & 0x40) != 0) {
            initializer2 = new HeUniform(0L, 1, null);
        }
        if ((n2 & 0x80) != 0) {
            regularizer = null;
        }
        if ((n2 & 0x100) != 0) {
            regularizer2 = null;
        }
        if ((n2 & 0x200) != 0) {
            regularizer3 = null;
        }
        if ((n2 & 0x400) != 0) {
            convPadding = ConvPadding.SAME;
        }
        if ((n2 & 0x800) != 0) {
            bl = true;
        }
        if ((n2 & 0x1000) != 0) {
            string = "";
        }
        this(n, nArray, nArray2, nArray3, activations, initializer, initializer2, regularizer, regularizer2, regularizer3, convPadding, bl, string);
    }

    @Override
    public int getFilters() {
        return this.filters;
    }

    @Override
    @NotNull
    public int[] getKernelSize() {
        return this.kernelSize;
    }

    @Override
    @NotNull
    public int[] getStrides() {
        return this.strides;
    }

    @Override
    @NotNull
    public int[] getDilations() {
        return this.dilations;
    }

    @Override
    @NotNull
    public Activations getActivation() {
        return this.activation;
    }

    @Override
    @NotNull
    public Initializer getKernelInitializer() {
        return this.kernelInitializer;
    }

    @Override
    @NotNull
    public Initializer getBiasInitializer() {
        return this.biasInitializer;
    }

    @Override
    @Nullable
    public Regularizer getKernelRegularizer() {
        return this.kernelRegularizer;
    }

    @Override
    @Nullable
    public Regularizer getBiasRegularizer() {
        return this.biasRegularizer;
    }

    @Override
    @Nullable
    public Regularizer getActivityRegularizer() {
        return this.activityRegularizer;
    }

    @Override
    @NotNull
    public ConvPadding getPadding() {
        return this.padding;
    }

    public boolean getUseBias() {
        return this.useBias;
    }

    @Override
    public boolean isTrainable() {
        return this.isTrainable;
    }

    @Override
    public void setTrainable(boolean bl) {
        this.isTrainable = bl;
    }

    public Conv2D(int filters, int kernelSize, int strides, int dilations, @NotNull Activations activation, @NotNull Initializer kernelInitializer, @NotNull Initializer biasInitializer, @Nullable Regularizer kernelRegularizer, @Nullable Regularizer biasRegularizer, @Nullable Regularizer activityRegularizer, @NotNull ConvPadding padding, boolean useBias, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)((Object)activation), (String)"activation");
        Intrinsics.checkNotNullParameter((Object)kernelInitializer, (String)"kernelInitializer");
        Intrinsics.checkNotNullParameter((Object)biasInitializer, (String)"biasInitializer");
        Intrinsics.checkNotNullParameter((Object)((Object)padding), (String)"padding");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int[] nArray = new int[]{kernelSize, kernelSize};
        int[] nArray2 = nArray;
        nArray = new int[]{1, strides, strides, 1};
        int[] nArray3 = nArray;
        nArray = new int[]{1, dilations, dilations, 1};
        this(filters, nArray2, nArray3, nArray, activation, kernelInitializer, biasInitializer, kernelRegularizer, biasRegularizer, activityRegularizer, padding, useBias, name);
    }

    public /* synthetic */ Conv2D(int n, int n2, int n3, int n4, Activations activations, Initializer initializer, Initializer initializer2, Regularizer regularizer, Regularizer regularizer2, Regularizer regularizer3, ConvPadding convPadding, boolean bl, String string, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 1) != 0) {
            n = 32;
        }
        if ((n5 & 2) != 0) {
            n2 = 3;
        }
        if ((n5 & 4) != 0) {
            n3 = 1;
        }
        if ((n5 & 8) != 0) {
            n4 = 1;
        }
        if ((n5 & 0x10) != 0) {
            activations = Activations.Relu;
        }
        if ((n5 & 0x20) != 0) {
            initializer = new HeNormal(0L, 1, null);
        }
        if ((n5 & 0x40) != 0) {
            initializer2 = new HeUniform(0L, 1, null);
        }
        if ((n5 & 0x80) != 0) {
            regularizer = null;
        }
        if ((n5 & 0x100) != 0) {
            regularizer2 = null;
        }
        if ((n5 & 0x200) != 0) {
            regularizer3 = null;
        }
        if ((n5 & 0x400) != 0) {
            convPadding = ConvPadding.SAME;
        }
        if ((n5 & 0x800) != 0) {
            bl = true;
        }
        if ((n5 & 0x1000) != 0) {
            string = "";
        }
        this(n, n2, n3, n4, activations, initializer, initializer2, regularizer, regularizer2, regularizer3, convPadding, bl, string);
    }

    @Override
    @NotNull
    protected Operand<Float> convImplementation(@NotNull Ops tf, @NotNull Operand<Float> input) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Conv2d.Options options = Conv2d.dilations(LayerKt.toLongList(this.getDilations())).dataFormat("NHWC");
        Conv2d.Options[] optionsArray = new Conv2d.Options[]{options};
        Conv2d conv2d = tf.nn.conv2d(input, (Operand)this.getKernel$tensorflow().getVariable(), LayerKt.toLongList(this.getStrides()), this.getPadding().getPaddingName$tensorflow(), optionsArray);
        Intrinsics.checkNotNullExpressionValue((Object)conv2d, (String)"tf.nn.conv2d(\n          \u2026        options\n        )");
        return (Operand)conv2d;
    }

    @Override
    @NotNull
    protected String kernelVarName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return NameConventionsKt.convKernelVarName(name, 2);
    }

    @Override
    @NotNull
    protected String biasVarName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return NameConventionsKt.convBiasVarName(name, 2);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("Conv2D(name = ").append(this.getName()).append(", isTrainable=").append(this.isTrainable()).append(", filters=").append(this.getFilters()).append(", kernelSize=");
        String string = Arrays.toString(this.getKernelSize());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
        StringBuilder stringBuilder3 = stringBuilder2.append(string).append(", strides=");
        String string2 = Arrays.toString(this.getStrides());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
        StringBuilder stringBuilder4 = stringBuilder3.append(string2).append(", dilations=");
        String string3 = Arrays.toString(this.getDilations());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this)");
        stringBuilder4.append(string3).append(", activation=").append((Object)this.getActivation()).append(", kernelInitializer=").append(this.getKernelInitializer()).append(", biasInitializer=").append(this.getBiasInitializer()).append(", kernelRegularizer=").append(this.getKernelRegularizer()).append(", biasRegularizer=").append(this.getBiasRegularizer()).append(", activityRegularizer=");
        KVariable kVariable = this.getBias$tensorflow();
        stringBuilder.append(this.getActivityRegularizer()).append(", padding=").append((Object)this.getPadding()).append(", useBias=").append(this.getUseBias()).append(", hasActivation=").append(this.getHasActivation()).append(", kernelShapeArray=").append(this.getKernel$tensorflow().getShape()).append(", biasShapeArray=").append(kVariable != null ? kVariable.getShape() : null).append(')');
        return stringBuilder.toString();
    }

    public Conv2D() {
        this(0, null, null, null, null, null, null, null, null, null, null, false, null, 8191, null);
    }
}

