/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.convolutional;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongSpreadBuilder;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.activation.Activations;
import org.jetbrains.kotlinx.dl.api.core.initializer.Initializer;
import org.jetbrains.kotlinx.dl.api.core.layer.KVariable;
import org.jetbrains.kotlinx.dl.api.core.layer.KVariableKt;
import org.jetbrains.kotlinx.dl.api.core.layer.Layer;
import org.jetbrains.kotlinx.dl.api.core.layer.LayerKt;
import org.jetbrains.kotlinx.dl.api.core.layer.ParametrizedLayer;
import org.jetbrains.kotlinx.dl.api.core.layer.convolutional.AbstractConvKt;
import org.jetbrains.kotlinx.dl.api.core.layer.convolutional.ConvPadding;
import org.jetbrains.kotlinx.dl.api.core.regularizer.Regularizer;
import org.jetbrains.kotlinx.dl.api.core.shape.ShapeFunctionsKt;
import org.tensorflow.Operand;
import org.tensorflow.Shape;
import org.tensorflow.op.Ops;
import org.tensorflow.op.nn.BiasAdd;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010;\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H$JB\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=2\u0006\u0010?\u001a\u00020@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020>0=2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020#0=2\u000e\u0010C\u001a\n\u0012\u0004\u0012\u00020>\u0018\u00010=H\u0016J\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0014J\u0010\u0010H\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0014J$\u0010I\u001a\b\u0012\u0004\u0012\u00020>0=2\u0006\u0010?\u001a\u00020@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020>0=H$J\u0010\u0010J\u001a\u00020G2\u0006\u0010F\u001a\u00020GH\u0014J\u0010\u0010K\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H$R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u0004\u0018\u00010\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\rR\u0012\u0010\u001a\u001a\u00020\u001bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u00020\u001fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u000fX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0011\"\u0004\b(\u0010\u0013R\u0012\u0010)\u001a\u00020\u0015X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0017R\u0014\u0010+\u001a\u0004\u0018\u00010\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\rR\u0012\u0010-\u001a\u00020\u001bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001dR\u0012\u0010/\u001a\u000200X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0012\u00103\u001a\u00020\u001bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u001dR\u0012\u00105\u001a\u00020#X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010%R\u001a\u00107\u001a\b\u0012\u0004\u0012\u00020\u000f088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/AbstractConv;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/Layer;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/ParametrizedLayer;", "name", "", "(Ljava/lang/String;)V", "activation", "Lorg/jetbrains/kotlinx/dl/api/core/activation/Activations;", "getActivation", "()Lorg/jetbrains/kotlinx/dl/api/core/activation/Activations;", "activityRegularizer", "Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;", "getActivityRegularizer", "()Lorg/jetbrains/kotlinx/dl/api/core/regularizer/Regularizer;", "bias", "Lorg/jetbrains/kotlinx/dl/api/core/layer/KVariable;", "getBias$tensorflow", "()Lorg/jetbrains/kotlinx/dl/api/core/layer/KVariable;", "setBias$tensorflow", "(Lorg/jetbrains/kotlinx/dl/api/core/layer/KVariable;)V", "biasInitializer", "Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;", "getBiasInitializer", "()Lorg/jetbrains/kotlinx/dl/api/core/initializer/Initializer;", "biasRegularizer", "getBiasRegularizer", "dilations", "", "getDilations", "()[I", "filters", "", "getFilters", "()I", "hasActivation", "", "getHasActivation", "()Z", "kernel", "getKernel$tensorflow", "setKernel$tensorflow", "kernelInitializer", "getKernelInitializer", "kernelRegularizer", "getKernelRegularizer", "kernelSize", "getKernelSize", "padding", "Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvPadding;", "getPadding", "()Lorg/jetbrains/kotlinx/dl/api/core/layer/convolutional/ConvPadding;", "strides", "getStrides", "useBias", "getUseBias$tensorflow", "variables", "", "getVariables", "()Ljava/util/List;", "biasVarName", "build", "Lorg/tensorflow/Operand;", "", "tf", "Lorg/tensorflow/op/Ops;", "input", "isTraining", "numberOfLosses", "computeBiasShape", "Lorg/tensorflow/Shape;", "numberOfChannels", "", "computeKernelShape", "convImplementation", "getOutputDepth", "kernelVarName", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nAbstractConv.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractConv.kt\norg/jetbrains/kotlinx/dl/api/core/layer/convolutional/AbstractConv\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1#2:146\n*E\n"})
public abstract class AbstractConv
extends Layer
implements ParametrizedLayer {
    public KVariable kernel;
    @Nullable
    private KVariable bias;

    public AbstractConv(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
    }

    protected abstract int getFilters();

    @NotNull
    protected abstract int[] getKernelSize();

    @NotNull
    protected abstract int[] getStrides();

    @NotNull
    protected abstract int[] getDilations();

    @NotNull
    protected abstract Activations getActivation();

    @NotNull
    protected abstract Initializer getKernelInitializer();

    @NotNull
    protected abstract Initializer getBiasInitializer();

    @Nullable
    protected abstract Regularizer getKernelRegularizer();

    @Nullable
    protected abstract Regularizer getBiasRegularizer();

    @Nullable
    protected abstract Regularizer getActivityRegularizer();

    @NotNull
    protected abstract ConvPadding getPadding();

    public abstract boolean getUseBias$tensorflow();

    @NotNull
    public final KVariable getKernel$tensorflow() {
        KVariable kVariable = this.kernel;
        if (kVariable != null) {
            return kVariable;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"kernel");
        return null;
    }

    public final void setKernel$tensorflow(@NotNull KVariable kVariable) {
        Intrinsics.checkNotNullParameter((Object)kVariable, (String)"<set-?>");
        this.kernel = kVariable;
    }

    @Nullable
    public final KVariable getBias$tensorflow() {
        return this.bias;
    }

    public final void setBias$tensorflow(@Nullable KVariable kVariable) {
        this.bias = kVariable;
    }

    @Override
    @NotNull
    public List<KVariable> getVariables() {
        Object[] objectArray = new KVariable[]{this.getKernel$tensorflow(), this.bias};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @Override
    @NotNull
    public Operand<Float> build(@NotNull Ops tf, @NotNull Operand<Float> input, @NotNull Operand<Boolean> isTraining, @Nullable Operand<Float> numberOfLosses) {
        BiasAdd biasAdd;
        long numberOfChannels;
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter(isTraining, (String)"isTraining");
        Shape inputShape = input.asOutput().shape();
        long inputDepth = numberOfChannels = inputShape.size(inputShape.numDimensions() - 1);
        long outputDepth = this.getOutputDepth(numberOfChannels);
        int fanIn = (int)(inputDepth * AbstractConvKt.access$multiply(LayerKt.toLongArray(this.getKernelSize())));
        int fanOut = MathKt.roundToInt((double)((double)(outputDepth * AbstractConvKt.access$multiply(LayerKt.toLongArray(this.getKernelSize()))) / (double)AbstractConvKt.access$multiply(LayerKt.toLongArray(this.getStrides()))));
        this.setKernel$tensorflow(KVariableKt.createVariable(tf, this.kernelVarName(this.getName()), this.computeKernelShape(numberOfChannels), fanIn, fanOut, this.getKernelInitializer(), this.getKernelRegularizer()));
        if (this.getUseBias$tensorflow()) {
            this.bias = KVariableKt.createVariable(tf, this.biasVarName(this.getName()), this.computeBiasShape(numberOfChannels), fanIn, fanOut, this.getBiasInitializer(), this.getBiasRegularizer());
        }
        Operand<Float> convolution = this.convImplementation(tf, input);
        KVariable kVariable = this.bias;
        if (kVariable != null) {
            KVariable it = kVariable;
            boolean bl = false;
            biasAdd = tf.nn.biasAdd(convolution, (Operand)it.getVariable(), new BiasAdd.Options[0]);
        } else {
            biasAdd = null;
        }
        Operand<Float> withBias = biasAdd == null ? convolution : (Operand<Float>)biasAdd;
        return Activations.Companion.convert(this.getActivation()).apply(tf, withBias, this.getName());
    }

    @Override
    public boolean getHasActivation() {
        return true;
    }

    protected long getOutputDepth(long numberOfChannels) {
        return this.getFilters();
    }

    @NotNull
    protected Shape computeKernelShape(long numberOfChannels) {
        LongSpreadBuilder longSpreadBuilder = new LongSpreadBuilder(3);
        longSpreadBuilder.addSpread((Object)LayerKt.toLongArray(this.getKernelSize()));
        longSpreadBuilder.add(numberOfChannels);
        longSpreadBuilder.add((long)this.getFilters());
        return ShapeFunctionsKt.shapeFromDims(longSpreadBuilder.toArray());
    }

    @NotNull
    protected Shape computeBiasShape(long numberOfChannels) {
        Shape shape = Shape.make((long)this.getFilters(), (long[])new long[0]);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"make(filters.toLong())");
        return shape;
    }

    @NotNull
    protected abstract String kernelVarName(@NotNull String var1);

    @NotNull
    protected abstract String biasVarName(@NotNull String var1);

    @NotNull
    protected abstract Operand<Float> convImplementation(@NotNull Ops var1, @NotNull Operand<Float> var2);

    @Override
    public int getParamCount() {
        return ParametrizedLayer.DefaultImpls.getParamCount(this);
    }
}

