/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.api.core.layer.activation;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dl.api.core.layer.activation.AbstractActivationLayer;
import org.jetbrains.kotlinx.dl.api.core.layer.activation.ActivationUtilsKt;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/dl/api/core/layer/activation/ReLU;", "Lorg/jetbrains/kotlinx/dl/api/core/layer/activation/AbstractActivationLayer;", "maxValue", "", "negativeSlope", "threshold", "name", "", "(Ljava/lang/Float;FFLjava/lang/String;)V", "getMaxValue", "()Ljava/lang/Float;", "Ljava/lang/Float;", "getNegativeSlope", "()F", "getThreshold", "forward", "Lorg/tensorflow/Operand;", "tf", "Lorg/tensorflow/op/Ops;", "input", "toString", "tensorflow"})
@SourceDebugExtension(value={"SMAP\nReLU.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReLU.kt\norg/jetbrains/kotlinx/dl/api/core/layer/activation/ReLU\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class ReLU
extends AbstractActivationLayer {
    @Nullable
    private final Float maxValue;
    private final float negativeSlope;
    private final float threshold;

    public ReLU(@Nullable Float maxValue, float negativeSlope, float threshold, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.maxValue = maxValue;
        this.negativeSlope = negativeSlope;
        this.threshold = threshold;
        if (!(this.negativeSlope >= 0.0f)) {
            boolean $i$a$-require-ReLU$32 = false;
            String $i$a$-require-ReLU$32 = "Negative slope " + this.negativeSlope + " should be >= 0.0.";
            throw new IllegalArgumentException($i$a$-require-ReLU$32.toString());
        }
        if (!(this.maxValue == null || this.maxValue.floatValue() >= 0.0f)) {
            boolean bl = false;
            String string = "Max value " + this.maxValue + " should be >= 0.0.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ ReLU(Float f, float f2, float f3, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = null;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.0f;
        }
        if ((n & 8) != 0) {
            string = "";
        }
        this(f, f2, f3, string);
    }

    @Nullable
    public final Float getMaxValue() {
        return this.maxValue;
    }

    public final float getNegativeSlope() {
        return this.negativeSlope;
    }

    public final float getThreshold() {
        return this.threshold;
    }

    @Override
    @NotNull
    public Operand<Float> forward(@NotNull Ops tf, @NotNull Operand<Float> input) {
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        return ActivationUtilsKt.commonRelu(tf, input, this.negativeSlope, this.maxValue, this.threshold);
    }

    @NotNull
    public String toString() {
        return "ReLU(name = " + this.getName() + ", maxValue=" + this.maxValue + ", negativeSlope=" + this.negativeSlope + ", threshold=" + this.threshold + ')';
    }

    public ReLU() {
        this(null, 0.0f, 0.0f, null, 15, null);
    }
}

